/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.sampler;

import skyview.geometry.Sampler;

public class LI
extends Sampler {
    private double[] out = new double[2];

    @Override
    public String getName() {
        return "LISampler";
    }

    @Override
    public String getDescription() {
        return "Sample using a bi-linear interpolation";
    }

    @Override
    public void sample(int pix) {
        double[] in = this.outImage.getCenter(pix);
        this.trans.transform(in, this.out);
        double x = this.out[0] - 0.5;
        double y = this.out[1] - 0.5;
        if (x < 0.0 || x > (double)(this.inWidth - 1) || y < 0.0 || y > (double)(this.inHeight - 1)) {
            return;
        }
        int ix = (int)Math.floor(x);
        int iy = (int)Math.floor(y);
        double dx = x - (double)ix;
        double dy = y - (double)iy;
        for (int k = 0; k < this.inDepth; ++k) {
            int inOffset = k * this.inWidth * this.inHeight;
            int outOffset = k * this.outWidth * this.outHeight;
            this.outImage.setData(pix + outOffset, (1.0 - dx) * (1.0 - dy) * this.inImage.getData(ix + this.inWidth * iy + inOffset) + dx * (1.0 - dy) * this.inImage.getData(ix + 1 + this.inWidth * iy + inOffset) + (1.0 - dx) * dy * this.inImage.getData(ix + this.inWidth * (iy + 1) + inOffset) + dx * dy * this.inImage.getData(ix + 1 + this.inWidth * (iy + 1) + inOffset));
        }
    }
}

