/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;

public class StackStatistics
extends ImageStatistics {
    public StackStatistics(ImagePlus imp) {
        this.doCalculations(imp, 256, 0.0, 0.0);
    }

    public StackStatistics(ImagePlus imp, int nBins, double histMin, double histMax) {
        this.doCalculations(imp, nBins, histMin, histMax);
    }

    void doCalculations(ImagePlus imp, int bins, double histogramMin, double histogramMax) {
        double v;
        int rh;
        int rw;
        int ry;
        int rx;
        ImageProcessor ip = imp.getProcessor();
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        double minThreshold = -3.4028234663852886E38;
        double maxThreshold = 3.4028234663852886E38;
        Calibration cal = imp.getCalibration();
        if (limitToThreshold) {
            if (ip.getMinThreshold() != -808080.0) {
                minThreshold = cal.getCValue(ip.getMinThreshold());
                maxThreshold = cal.getCValue(ip.getMaxThreshold());
            }
        }
        this.nBins = bins;
        this.histMin = histogramMin;
        this.histMax = histogramMax;
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        ip.setRoi(imp.getRoi());
        byte[] mask = ip.getMaskArray();
        float[] cTable = imp.getCalibration().getCTable();
        this.histogram = new int[this.nBins];
        double sum = 0.0;
        double sum2 = 0.0;
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        if (roi != null) {
            rx = roi.x;
            ry = roi.y;
            rw = roi.width;
            rh = roi.height;
        } else {
            rx = 0;
            ry = 0;
            rw = width;
            rh = height;
        }
        double pw = 1.0;
        double ph = 1.0;
        this.roiX = (double)rx * pw;
        this.roiY = (double)ry * ph;
        this.roiWidth = (double)rw * pw;
        this.roiHeight = (double)rh * ph;
        boolean fixedRange = this.histMin != 0.0 || this.histMax != 0.0;
        double roiMin = Double.MAX_VALUE;
        double roiMax = -1.7976931348623157E308;
        for (int slice = 1; slice <= size; ++slice) {
            IJ.showStatus("Calculating stack histogram...");
            IJ.showProgress(slice / 2, size);
            ip = stack.getProcessor(slice);
            ip.setCalibrationTable(cTable);
            int y = ry;
            int my = 0;
            while (y < ry + rh) {
                int i = y * width + rx;
                int mi = my * rw;
                for (int x = rx; x < rx + rw; ++x) {
                    if ((mask == null || mask[mi++] != 0) && (v = (double)ip.getPixelValue(x, y)) >= minThreshold && v <= maxThreshold) {
                        if (v < roiMin) {
                            roiMin = v;
                        }
                        if (v > roiMax) {
                            roiMax = v;
                        }
                    }
                    ++i;
                }
                ++y;
                ++my;
            }
        }
        this.min = roiMin;
        this.max = roiMax;
        if (fixedRange) {
            if (this.min < this.histMin) {
                this.min = this.histMin;
            }
            if (this.max > this.histMax) {
                this.max = this.histMax;
            }
        } else {
            this.histMin = this.min;
            this.histMax = this.max;
        }
        double scale = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        boolean first = true;
        for (int slice = 1; slice <= size; ++slice) {
            IJ.showProgress(size / 2 + slice / 2, size);
            ip = stack.getProcessor(slice);
            ip.setCalibrationTable(cTable);
            int y = ry;
            int my = 0;
            while (y < ry + rh) {
                int i = y * width + rx;
                int mi = my * rw;
                for (int x = rx; x < rx + rw; ++x) {
                    if ((mask == null || mask[mi++] != 0) && (v = (double)ip.getPixelValue(x, y)) >= minThreshold && v <= maxThreshold && v >= this.histMin && v <= this.histMax) {
                        ++this.pixelCount;
                        sum += v;
                        sum2 += v * v;
                        int index = (int)(scale * (v - this.histMin));
                        if (index >= this.nBins) {
                            index = this.nBins - 1;
                        }
                        int n = index;
                        this.histogram[n] = this.histogram[n] + 1;
                    }
                    ++i;
                }
                ++y;
                ++my;
            }
        }
        this.area = (double)this.pixelCount * pw * ph;
        this.mean = sum / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, sum, sum2);
        this.histMin = cal.getRawValue(this.histMin);
        this.histMax = cal.getRawValue(this.histMax);
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        this.dmode = this.getMode(cal);
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }

    double getMode(Calibration cal) {
        this.maxCount = 0;
        for (int i = 0; i < this.nBins; ++i) {
            int count = this.histogram[i];
            if (count <= this.maxCount) continue;
            this.maxCount = count;
            this.mode = i;
        }
        return cal.getCValue(this.histMin + (double)this.mode * this.binSize);
    }
}

