/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Zip_Reader
extends ImagePlus
implements PlugIn {
    private static final String TEMP_NAME = "temp.tif";
    private int width;
    private int height;
    private String tifName = "";
    private String dir;

    public void run(String arg) {
        ImagePlus imp;
        OpenDialog od = new OpenDialog("ZIP/TIFF Reader...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        this.dir = IJ.getDirectory("temp");
        if (this.dir == null) {
            this.dir = IJ.getDirectory("startup");
        }
        if (this.dir == null) {
            this.dir = "";
        }
        IJ.showStatus("Opening: " + path);
        try {
            imp = this.openZip(path);
        }
        catch (Exception e) {
            IJ.error("ZIP Reader", e.getMessage());
            return;
        }
        if (imp != null) {
            this.setStack(this.tifName, imp.getStack());
            this.setCalibration(imp.getCalibration());
            if (imp.getStackSize() > 1) {
                int[] dim = imp.getDimensions();
                this.setDimensions(dim[2], dim[3], dim[4]);
            }
            FileInfo fi = new FileInfo();
            fi.fileFormat = 7;
            fi.fileName = name;
            fi.directory = directory;
            fi.width = this.getWidth();
            fi.height = this.getHeight();
            fi.nImages = this.getStackSize();
            this.setFileInfo(fi);
            Object info = imp.getProperty("Info");
            if (info != null) {
                this.setProperty("Info", info);
            }
            if (arg.equals("")) {
                this.show();
            }
        }
    }

    public ImagePlus openZip(String path) throws IOException {
        String name = this.extractFile(path);
        if (name == null) {
            return null;
        }
        this.tifName = name;
        ImagePlus imp = new Opener().openImage(this.dir, TEMP_NAME);
        new File(this.dir + TEMP_NAME).delete();
        return imp;
    }

    String extractFile(String path) throws IOException {
        int len;
        ZipInputStream in = new ZipInputStream(new FileInputStream(path));
        FileOutputStream out = new FileOutputStream(this.dir + TEMP_NAME);
        byte[] buf = new byte[1024];
        ZipEntry entry = in.getNextEntry();
        if (entry == null) {
            return null;
        }
        String name = entry.getName();
        if (name.endsWith(".roi")) {
            ((OutputStream)out).close();
            in.close();
            IJ.runMacro("roiManager(\"Open\", getArgument());", path);
            return null;
        }
        if (!name.endsWith(".tif") && !name.endsWith(".dcm")) {
            ((OutputStream)out).close();
            in.close();
            throw new IOException("This ZIP archive does not appear to contain a \nTIFF (\".tif\") or DICOM (\".dcm\") file, or ROIs (\".roi\").");
        }
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
        return name;
    }
}

