/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.LogParameterUtil;
import alma.acs.logging.LogThrottle;
import alma.acs.logging.config.LogConfig;
import alma.acs.logging.config.LogConfigSubscriber;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.acs.util.StopWatch;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class StdOutConsoleHandler
extends StreamHandler
implements LogConfigSubscriber {
    private LogConfig logConfig;
    private final String loggerName;
    private final LogThrottle logThrottle;
    private final boolean PROFILE = Boolean.getBoolean("alma.acs.logging.profile.local");

    public StdOutConsoleHandler(LogConfig logConfig, String loggerName, LogThrottle logThrottle) {
        this.logConfig = logConfig;
        this.loggerName = loggerName;
        this.logThrottle = logThrottle;
        this.setOutputStream(System.out);
        this.configureLogging(logConfig);
        logConfig.addSubscriber(this);
    }

    @Override
    public void configureLogging(LogConfig newLogConfig) {
        this.logConfig = newLogConfig;
        try {
            AcsLogLevelDefinition minLogLevelACS = AcsLogLevelDefinition.fromXsdLogLevel(this.logConfig.getNamedLoggerConfig(this.loggerName).getMinLogLevelLocal());
            this.setLevel(AcsLogLevel.getLowestMatchingJdkLevel(minLogLevelACS));
        }
        catch (Exception ex) {
            this.publish(new LogRecord(Level.WARNING, "Failed to configure stdout log handler: " + ex.toString()));
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        LogParameterUtil logParamUtil;
        StopWatch sw_parent;
        StopWatch sw_local = null;
        if (this.PROFILE && (sw_parent = (logParamUtil = new LogParameterUtil(record)).getStopWatch()) != null) {
            sw_local = sw_parent.createStopWatchForSubtask("StdOutConsoleHandler");
        }
        if (this.logThrottle == null || this.logThrottle.checkPublishLogRecordLocal()) {
            super.publish(record);
            this.flush();
        }
        if (this.PROFILE && sw_local != null) {
            sw_local.stop();
        }
    }

    @Override
    public void close() {
        this.flush();
        this.logConfig.removeSubscriber(this);
    }
}

