/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.util;

import java.net.InetAddress;
import java.util.Vector;

public class ACSPorts {
    public static final String ACS_BASE_PORT_VARIABLE = "ACS.baseport";
    public static final String ACS_BASE_PORT_DEFAULT = "0";
    private static Vector<ACSPorts> instances = new Vector();
    int basePort;

    public static int getBasePort() {
        return ACSPorts.globalInstanceForSystemProperty().giveBasePort();
    }

    public static String getManagerPort() {
        return ACSPorts.globalInstanceForSystemProperty().giveManagerPort();
    }

    public static String getNamingServicePort() {
        return ACSPorts.globalInstanceForSystemProperty().giveNamingServicePort();
    }

    public static String getNotifyServicePort() {
        return ACSPorts.globalInstanceForSystemProperty().giveNotifyServicePort();
    }

    public static String getAlarmNotifyServicePort() {
        return ACSPorts.globalInstanceForSystemProperty().giveAlarmNotifyServicePort();
    }

    public static String getLoggingServicePort() {
        return ACSPorts.globalInstanceForSystemProperty().giveLoggingServicePort();
    }

    public static String getIRPort() {
        return ACSPorts.globalInstanceForSystemProperty().giveIRPort();
    }

    public static String getLogPort() {
        return ACSPorts.globalInstanceForSystemProperty().giveLogPort();
    }

    public static String getCDBPort() {
        return ACSPorts.globalInstanceForSystemProperty().giveCDBPort();
    }

    public static String getAlarmServicePort() {
        return ACSPorts.globalInstanceForSystemProperty().giveAlarmServicePort();
    }

    public static String getContainerDaemonPort() {
        return ACSPorts.globalInstanceForSystemProperty().giveContainerDaemonPort();
    }

    public static String getServicesDaemonPort() {
        return ACSPorts.globalInstanceForSystemProperty().giveServicesDaemonPort();
    }

    public static String getIP() {
        return ACSPorts.globalInstanceForSystemProperty().giveIP();
    }

    public static String getManagerHost() {
        return ACSPorts.globalInstanceForSystemProperty().giveManagerHost();
    }

    public static ACSPorts globalInstance(int basePort) {
        if (basePort < 0) {
            throw new IllegalArgumentException("invalid baseport: " + basePort);
        }
        for (int i = instances.size(); i < basePort + 1; ++i) {
            instances.add(null);
        }
        ACSPorts instance = instances.get(basePort);
        if (instance == null) {
            instance = new ACSPorts(basePort);
            instances.set(basePort, instance);
        }
        return instance;
    }

    private static ACSPorts globalInstanceForSystemProperty() {
        int instanceIndex = 0;
        try {
            instanceIndex = Integer.parseInt(System.getProperty(ACS_BASE_PORT_VARIABLE, ACS_BASE_PORT_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ACSPorts.globalInstance(instanceIndex);
    }

    private ACSPorts(int basePort) {
        this.basePort = basePort;
    }

    public int giveBasePort() {
        return this.basePort;
    }

    public String giveManagerPort() {
        return String.valueOf(this.basePort * 100 + 3000 + 0);
    }

    public String giveNamingServicePort() {
        return String.valueOf(this.basePort * 100 + 3000 + 1);
    }

    public String giveNotifyServicePort() {
        return String.valueOf(this.basePort * 100 + 3000 + 2);
    }

    public String giveLoggingServicePort() {
        return String.valueOf(this.basePort * 100 + 3000 + 3);
    }

    public String giveIRPort() {
        return String.valueOf(this.basePort * 100 + 3000 + 4);
    }

    public String giveAlarmNotifyServicePort() {
        return String.valueOf(this.basePort * 100 + 3000 + 7);
    }

    public String giveLogPort() {
        return String.valueOf(this.basePort * 100 + 3000 + 11);
    }

    public String giveCDBPort() {
        return String.valueOf(this.basePort * 100 + 3000 + 12);
    }

    public String giveAlarmServicePort() {
        return String.valueOf(this.basePort * 100 + 3000 + 13);
    }

    public String giveContainerDaemonPort() {
        return String.valueOf(2970);
    }

    public String giveServicesDaemonPort() {
        return String.valueOf(2980);
    }

    public String giveIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return "localhost";
        }
    }

    public String giveManagerHost() {
        try {
            String manager = System.getProperty("ACS.manager");
            if (manager != null || (manager = System.getenv("MANAGER_REFERENCE")) != null) {
                return manager.split(":")[2];
            }
            return this.giveIP();
        }
        catch (Exception e) {
            return this.giveIP();
        }
    }

    public String toString() {
        return "ACSPorts@" + this.hashCode() + " [base " + this.basePort + "]";
    }
}

