/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.PolygonIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Polygon2D
implements Shape {
    protected int _coordCount = 0;
    protected boolean _closed = false;

    public void closePath() {
        if (this.getX(this.getVertexCount() - 1) == this.getX(0) && this.getY(this.getVertexCount() - 1) == this.getY(0)) {
            this._coordCount -= 2;
        }
        this._closed = true;
    }

    public boolean contains(double x, double y) {
        double y2;
        double x1;
        int i;
        int crossings = 0;
        if (this._coordCount == 0) {
            return false;
        }
        for (i = 1; i < this.getVertexCount(); ++i) {
            x1 = this.getX(i - 1);
            double x2 = this.getX(i);
            double y1 = this.getY(i - 1);
            y2 = this.getY(i);
            if (!(x < x1) && !(x < x2)) continue;
            if (y == y2) {
                ++crossings;
                continue;
            }
            if (y == y1 || !Line2D.linesIntersect(x, y, Math.max(x1, x2), y, x1, y1, x2, y2)) continue;
            ++crossings;
        }
        x1 = this.getX(i - 1);
        double y1 = this.getY(i - 1);
        double x2 = this.getX(0);
        y2 = this.getY(0);
        if ((x < x1 || x < x2) && Line2D.linesIntersect(x, y, Math.max(x1, x2), y, x1, y1, x2, y2) && y != y1) {
            ++crossings;
        }
        return crossings % 2 == 1;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x1, double y1, double w, double h) {
        double x2 = x1 + w;
        double y2 = y1 + h;
        return this.contains(x1, y1) && this.contains(x1, y2) && this.contains(x2, y1) && this.contains(x2, y2);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public abstract Rectangle2D getBounds2D();

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PolygonIterator(this, at);
    }

    public int getVertexCount() {
        return this._coordCount / 2;
    }

    public abstract double getX(int var1);

    public abstract double getY(int var1);

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(double x1, double y1, double w, double h) {
        int i;
        double x2 = x1 + w;
        double y2 = y1 + h;
        if (this._coordCount == 0) {
            return false;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x1, y1, w, h);
        if (!this.getBounds().intersects(rect)) {
            return false;
        }
        if (this.contains(x1, y1) || this.contains(x1, y2) || this.contains(x2, y1) || this.contains(x2, y2)) {
            return true;
        }
        for (i = 0; i < this.getVertexCount(); ++i) {
            if (!rect.contains(this.getX(i), this.getY(i))) continue;
            return true;
        }
        for (i = 1; i < this.getVertexCount(); ++i) {
            double vy2;
            double vx1 = this.getX(i - 1);
            double vx2 = this.getX(i);
            double vy1 = this.getY(i - 1);
            if (Line2D.linesIntersect(x1, y1, x1, y2, vx1, vy1, vx2, vy2 = this.getY(i))) {
                return true;
            }
            if (Line2D.linesIntersect(x1, y2, x2, y2, vx1, vy1, vx2, vy2)) {
                return true;
            }
            if (Line2D.linesIntersect(x2, y2, x2, y1, vx1, vy1, vx2, vy2)) {
                return true;
            }
            if (!Line2D.linesIntersect(x2, y1, x1, y1, vx1, vy1, vx2, vy2)) continue;
            return true;
        }
        return false;
    }

    public abstract void lineTo(double var1, double var3);

    public abstract void moveTo(double var1, double var3);

    public void reset() {
        this._coordCount = 0;
        this._closed = false;
    }

    public abstract void setX(int var1, double var2);

    public abstract void setY(int var1, double var2);

    public abstract void transform(AffineTransform var1);

    public abstract void translate(double var1, double var3);

    public String toString() {
        String out = this.getClass().getName() + "[\n";
        for (int i = 0; i < this.getVertexCount(); ++i) {
            out = out + "\t" + this.getX(i) + ", " + this.getY(i) + "\n";
        }
        out = out + "]";
        return out;
    }

    public static class Double
    extends Polygon2D {
        double[] _coords;

        public Double(int size) {
            this._coords = new double[2 * size];
        }

        public Double(double[] coords) {
            this._coords = coords;
            this._coordCount = coords.length;
        }

        public Double() {
            this(2);
        }

        public Double(double x, double y) {
            this(2);
            this._coords[0] = x;
            this._coords[1] = y;
            this._coordCount = 2;
        }

        public Rectangle2D getBounds2D() {
            if (this._coordCount <= 0) {
                return new Rectangle2D.Double();
            }
            double x1 = this._coords[0];
            double y1 = this._coords[1];
            double x2 = x1;
            double y2 = y1;
            for (int i = 2; i < this._coordCount; ++i) {
                if (this._coords[i] < x1) {
                    x1 = this._coords[i];
                } else if (this._coords[i] > x2) {
                    x2 = this._coords[i];
                }
                ++i;
                if (this._coords[i] < y1) {
                    y1 = this._coords[i];
                    continue;
                }
                if (!(this._coords[i] > y2)) continue;
                y2 = this._coords[i];
            }
            return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        }

        public int getVertexCount() {
            return this._coordCount / 2;
        }

        public double getX(int index) {
            return this._coords[index * 2];
        }

        public double getY(int index) {
            return this._coords[index * 2 + 1];
        }

        public void lineTo(double x, double y) {
            if (this._coordCount == this._coords.length) {
                double[] temp = new double[this._coordCount * 2];
                System.arraycopy(this._coords, 0, temp, 0, this._coordCount);
                this._coords = temp;
            }
            this._coords[this._coordCount++] = x;
            this._coords[this._coordCount++] = y;
        }

        public void moveTo(double x, double y) {
            if (this._coordCount > 0) {
                throw new UnsupportedOperationException("This polygon already has vertices");
            }
            this._coords[0] = x;
            this._coords[1] = y;
            this._coordCount = 2;
        }

        public void setX(int index, double x) {
            this._coords[index * 2] = x;
        }

        public void setY(int index, double y) {
            this._coords[index * 2 + 1] = y;
        }

        public void transform(AffineTransform at) {
            at.transform(this._coords, 0, this._coords, 0, this._coordCount / 2);
        }

        public void translate(double x, double y) {
            int i = 0;
            while (i < this._coordCount) {
                int n = i++;
                this._coords[n] = this._coords[n] + x;
                int n2 = i++;
                this._coords[n2] = this._coords[n2] + y;
            }
        }
    }

    public static class Float
    extends Polygon2D {
        float[] _coords;

        public Float(int size) {
            this._coords = new float[2 * size];
        }

        public Float(float[] coords) {
            this._coords = coords;
            this._coordCount = coords.length;
        }

        public Float() {
            this(2);
        }

        public Float(float x, float y) {
            this(2);
            this._coords[0] = x;
            this._coords[1] = y;
            this._coordCount = 2;
        }

        public Rectangle2D getBounds2D() {
            if (this._coordCount <= 1) {
                return new Rectangle2D.Float();
            }
            float x1 = this._coords[0];
            float y1 = this._coords[1];
            float x2 = x1;
            float y2 = y1;
            for (int i = 2; i < this._coordCount; ++i) {
                if (this._coords[i] < x1) {
                    x1 = this._coords[i];
                } else if (this._coords[i] > x2) {
                    x2 = this._coords[i];
                }
                ++i;
                if (this._coords[i] < y1) {
                    y1 = this._coords[i];
                    continue;
                }
                if (!(this._coords[i] > y2)) continue;
                y2 = this._coords[i];
            }
            return new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1);
        }

        public double getX(int index) {
            return this._coords[index * 2];
        }

        public double getY(int index) {
            return this._coords[index * 2 + 1];
        }

        public void lineTo(double x, double y) {
            if (this._closed) {
                throw new UnsupportedOperationException("This polygon has already been closed");
            }
            if (this._coordCount == this._coords.length) {
                float[] temp = new float[this._coordCount * 2];
                System.arraycopy(this._coords, 0, temp, 0, this._coordCount);
                this._coords = temp;
            }
            this._coords[this._coordCount++] = (float)x;
            this._coords[this._coordCount++] = (float)y;
        }

        public void moveTo(double x, double y) {
            if (this._coordCount > 0) {
                throw new UnsupportedOperationException("This polygon already has vertices");
            }
            this._coords[0] = (float)x;
            this._coords[1] = (float)y;
            this._coordCount = 2;
        }

        public void setX(int index, double x) {
            this._coords[index * 2] = (float)x;
        }

        public void setY(int index, double y) {
            this._coords[index * 2 + 1] = (float)y;
        }

        public void transform(AffineTransform at) {
            at.transform(this._coords, 0, this._coords, 0, this._coordCount / 2);
        }

        public void translate(double x, double y) {
            float fx = (float)x;
            float fy = (float)y;
            int i = 0;
            while (i < this._coordCount) {
                int n = i++;
                this._coords[n] = this._coords[n] + fx;
                int n2 = i++;
                this._coords[n2] = this._coords[n2] + fy;
            }
        }
    }
}

