/*
 * Decompiled with CFR 0.152.
 */
package alma.maci.loggingconfig;

import alma.maci.loggingconfig.NamedLogger;
import alma.maci.loggingconfig.UnnamedLogger;
import alma.maci.loggingconfig.types.LogLevel;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class LoggingConfig
extends UnnamedLogger
implements Serializable {
    private String centralizedLogger = "Log";
    private int dispatchPacketSize = 100;
    private boolean _hasdispatchPacketSize;
    private LogLevel immediateDispatchLevel = LogLevel.valueOf("10");
    private long flushPeriodSeconds = 10L;
    private boolean _hasflushPeriodSeconds;
    private int maxLogQueueSize = 1000;
    private boolean _hasmaxLogQueueSize;
    private int maxLogsPerSecond = -1;
    private boolean _hasmaxLogsPerSecond;
    private List<NamedLogger> eList;

    public LoggingConfig() {
        this.setCentralizedLogger("Log");
        this.setImmediateDispatchLevel(LogLevel.valueOf("10"));
        this.eList = new ArrayList<NamedLogger>();
    }

    public void addE(NamedLogger vE) throws IndexOutOfBoundsException {
        this.eList.add(vE);
    }

    public void addE(int index, NamedLogger vE) throws IndexOutOfBoundsException {
        this.eList.add(index, vE);
    }

    public void deleteDispatchPacketSize() {
        this._hasdispatchPacketSize = false;
    }

    public void deleteFlushPeriodSeconds() {
        this._hasflushPeriodSeconds = false;
    }

    public void deleteMaxLogQueueSize() {
        this._hasmaxLogQueueSize = false;
    }

    public void deleteMaxLogsPerSecond() {
        this._hasmaxLogsPerSecond = false;
    }

    public Enumeration<? extends NamedLogger> enumerateE() {
        return Collections.enumeration(this.eList);
    }

    public String getCentralizedLogger() {
        return this.centralizedLogger;
    }

    public int getDispatchPacketSize() {
        return this.dispatchPacketSize;
    }

    public NamedLogger getE(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.eList.size()) {
            throw new IndexOutOfBoundsException("getE: Index value '" + index + "' not in range [0.." + (this.eList.size() - 1) + "]");
        }
        return this.eList.get(index);
    }

    public NamedLogger[] getE() {
        NamedLogger[] array = new NamedLogger[]{};
        return this.eList.toArray(array);
    }

    public int getECount() {
        return this.eList.size();
    }

    public long getFlushPeriodSeconds() {
        return this.flushPeriodSeconds;
    }

    public LogLevel getImmediateDispatchLevel() {
        return this.immediateDispatchLevel;
    }

    public int getMaxLogQueueSize() {
        return this.maxLogQueueSize;
    }

    public int getMaxLogsPerSecond() {
        return this.maxLogsPerSecond;
    }

    public boolean hasDispatchPacketSize() {
        return this._hasdispatchPacketSize;
    }

    public boolean hasFlushPeriodSeconds() {
        return this._hasflushPeriodSeconds;
    }

    public boolean hasMaxLogQueueSize() {
        return this._hasmaxLogQueueSize;
    }

    public boolean hasMaxLogsPerSecond() {
        return this._hasmaxLogsPerSecond;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends NamedLogger> iterateE() {
        return this.eList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllE() {
        this.eList.clear();
    }

    public boolean removeE(NamedLogger vE) {
        boolean removed = this.eList.remove(vE);
        return removed;
    }

    public NamedLogger removeEAt(int index) {
        NamedLogger obj = this.eList.remove(index);
        return obj;
    }

    public void setCentralizedLogger(String centralizedLogger) {
        this.centralizedLogger = centralizedLogger;
    }

    public void setDispatchPacketSize(int dispatchPacketSize) {
        this.dispatchPacketSize = dispatchPacketSize;
        this._hasdispatchPacketSize = true;
    }

    public void setE(int index, NamedLogger vE) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.eList.size()) {
            throw new IndexOutOfBoundsException("setE: Index value '" + index + "' not in range [0.." + (this.eList.size() - 1) + "]");
        }
        this.eList.set(index, vE);
    }

    public void setE(NamedLogger[] vEArray) {
        this.eList.clear();
        for (int i = 0; i < vEArray.length; ++i) {
            this.eList.add(vEArray[i]);
        }
    }

    public void setFlushPeriodSeconds(long flushPeriodSeconds) {
        this.flushPeriodSeconds = flushPeriodSeconds;
        this._hasflushPeriodSeconds = true;
    }

    public void setImmediateDispatchLevel(LogLevel immediateDispatchLevel) {
        this.immediateDispatchLevel = immediateDispatchLevel;
    }

    public void setMaxLogQueueSize(int maxLogQueueSize) {
        this.maxLogQueueSize = maxLogQueueSize;
        this._hasmaxLogQueueSize = true;
    }

    public void setMaxLogsPerSecond(int maxLogsPerSecond) {
        this.maxLogsPerSecond = maxLogsPerSecond;
        this._hasmaxLogsPerSecond = true;
    }

    public static LoggingConfig unmarshalLoggingConfig(Reader reader) throws MarshalException, ValidationException {
        return (LoggingConfig)Unmarshaller.unmarshal(LoggingConfig.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

