/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.astrocat;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import jsky.catalog.AbstractCatalogDirectory;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.CatalogFactory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.astrocat.AstroCatXML;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.catalog.skycat.SkycatConfigFile;
import jsky.util.FileUtil;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.Resources;
import jsky.util.gui.DialogUtil;

public class AstroCatConfig
extends AbstractCatalogDirectory {
    private static final I18N _I18N = I18N.getInstance(AstroCatConfig.class);
    private static AstroCatConfig _configFile;
    private static URL _defaultURL;
    private static boolean _reloadFlag;

    public AstroCatConfig() {
        super(_I18N.getString("catalogs"));
        this.setCatalogs(new ArrayList<Catalog>());
    }

    public AstroCatConfig(String name, URL url) {
        super(name);
        this.setURL(url);
        this._load();
    }

    public AstroCatConfig(String name, String configFileOrURL) {
        this(name, FileUtil.makeURL(null, configFileOrURL));
    }

    public AstroCatConfig(String configFileOrURL) {
        this(configFileOrURL, FileUtil.makeURL(null, configFileOrURL));
    }

    public AstroCatConfig(URL url, HTMLQueryResultHandler handler) {
        super(new File(url.toString()).getPath());
        this.setURL(url);
        this.setHTMLQueryResultHandler(handler);
        this._load();
    }

    private void _load() {
        URL url = this.getURL();
        if (url == null) {
            return;
        }
        AstroCatXML astroCatXML = new AstroCatXML();
        astroCatXML.parse(url);
        this.setCatalogs(astroCatXML.getCatalogs());
    }

    public static CatalogDirectory getDirectory() {
        return AstroCatConfig.getConfigFile();
    }

    public static CatalogDirectory getDirectory(AstroCatalog cat) {
        AstroCatConfig dir = AstroCatConfig.getConfigFile();
        dir.setName(cat.getName());
        return dir;
    }

    public static AstroCatConfig getConfigFile(boolean load) {
        boolean reload = _reloadFlag;
        _reloadFlag = false;
        if (_configFile != null && _configFile.getNumCatalogs() != 0 && !reload) {
            return _configFile;
        }
        if (!load && !reload) {
            if (_configFile != null) {
                return _configFile;
            }
            _configFile = new AstroCatConfig();
            return _configFile;
        }
        EventListenerList savedListeners = null;
        if (_configFile != null) {
            savedListeners = AstroCatConfig._configFile._listenerList;
        }
        List<URL> urls = AstroCatConfig._getConfigFileLocations();
        for (URL url : urls) {
            try {
                _configFile = new AstroCatConfig(_I18N.getString("catalogs"), url);
                if (!reload || _configFile == null) break;
                int n = _configFile.getNumCatalogs();
                List<Catalog> catList = _configFile.getCatalogs();
                for (int i = 0; i < n; ++i) {
                    Catalog cat = catList.get(i);
                    catList.set(i, cat.reload());
                }
                break;
            }
            catch (Exception e) {
                if (!url.equals(_defaultURL)) continue;
                throw new RuntimeException(e);
            }
        }
        if (savedListeners != null && savedListeners.getListenerCount() != 0) {
            AstroCatConfig._configFile._listenerList = savedListeners;
            _configFile._fireTreeStructureChanged(_configFile._getTreeModelEvent(_configFile));
        }
        return _configFile;
    }

    public static AstroCatConfig getConfigFile() {
        return AstroCatConfig.getConfigFile(true);
    }

    private static List<URL> _getConfigFileLocations() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String urlStr = System.getProperty("jsky.catalog.astrocat.config");
        if (urlStr != null && urlStr.length() != 0) {
            try {
                urls.add(new URL(urlStr));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        String sep = System.getProperty("file.separator");
        String filename = Preferences.getPreferences().getDir() + sep + "AstroCat.xml";
        File file = new File(filename);
        if (file.exists()) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (_defaultURL == null) {
            _defaultURL = Resources.getResource("AstroCat.xml");
        }
        if (_defaultURL == null) {
            throw new RuntimeException("Can't find the default catalog config file resource (AstroCat.xml).");
        }
        urls.add(_defaultURL);
        return urls;
    }

    @Override
    public Catalog reload() {
        if (this == _configFile) {
            _reloadFlag = true;
            AstroCatConfig catDir = null;
            try {
                catDir = AstroCatConfig.getConfigFile();
            }
            finally {
                _reloadFlag = false;
            }
            return catDir;
        }
        AstroCatConfig config = new AstroCatConfig(this.getName(), this.getURL());
        int n = config.getNumCatalogs();
        List<Catalog> catList = config.getCatalogs();
        for (int i = 0; i < n; ++i) {
            Catalog cat = catList.get(i);
            catList.set(i, cat.reload());
        }
        return config;
    }

    @Override
    public CatalogDirectory loadSubDir(URL url) {
        String filename = url.getFile();
        if (filename.endsWith(".xml")) {
            return new AstroCatConfig(url, this.getHTMLQueryResultHandler());
        }
        if (filename.endsWith(".cfg")) {
            return new SkycatConfigFile(url, this.getHTMLQueryResultHandler());
        }
        throw new RuntimeException("Expected an AstroCat XML file, or a Skycat style .cfg file");
    }

    public static void setConfigFile(URL url) {
        _defaultURL = url;
    }

    public void addCatalogDirectory(String urlStr) {
        if (this.getCatalog(urlStr) != null) {
            return;
        }
        try {
            URL url = new URL(urlStr);
            AstroCatConfig cat = new AstroCatConfig(urlStr, url);
            this.addCatalog(cat);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Catalog> getNameServers() {
        List<Catalog> l = super.getNameServers();
        if (l.size() != 0) {
            return l;
        }
        this._addDefaultNameServers();
        return CatalogFactory.getCatalogsByType("namesvr");
    }

    private void _addDefaultNameServers() {
        AstroCatalog cat = new AstroCatalog();
        cat.setId("simbad_ns@eso");
        cat.setName("SIMBAD Names");
        cat.setType("namesvr");
        cat.setHost("archive.eso.org");
        cat.setURLPath("/skycat/servers/sim-server");
        FieldDesc[] params = new FieldDescAdapter[]{new FieldDescAdapter()};
        FieldDesc param = params[0];
        ((FieldDescAdapter)param).setName("Object Name");
        ((FieldDescAdapter)param).setId("o");
        ((FieldDescAdapter)param).setDescription("Enter the name of the object (star, galaxy)");
        cat.setParams(params);
        CatalogFactory.registerCatalog(cat, false);
        cat = new AstroCatalog();
        cat.setId("ned@eso");
        cat.setName("NED Names");
        cat.setType("namesvr");
        cat.setHost("archive.eso.org");
        cat.setURLPath("/skycat/servers/ned-server");
        params = new FieldDescAdapter[]{new FieldDescAdapter()};
        param = params[0];
        ((FieldDescAdapter)param).setName("Object Name");
        ((FieldDescAdapter)param).setId("o");
        ((FieldDescAdapter)param).setDescription("Enter the name of the object (star, galaxy)");
        cat.setParams(params);
        CatalogFactory.registerCatalog(cat, false);
    }

    @Override
    public boolean configNeedsUrl() {
        return true;
    }

    @Override
    public void save() {
        String sep = System.getProperty("file.separator");
        String fileName = Preferences.getPreferences().getDir() + sep + "AstroCat.xml";
        try {
            this.save(fileName);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public void save(String filename) {
        File file = new File(filename + ".tmp");
        File dir = file.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            DialogUtil.error("Can't create directory: " + dir);
            return;
        }
        try {
            AstroCatXML.save(file, this.getCatalogs());
        }
        catch (Exception e) {
            if (!file.delete()) {
                // empty if block
            }
            throw new RuntimeException(e);
        }
        File newFile = new File(filename);
        if (!newFile.delete()) {
            // empty if block
        }
        if (!file.renameTo(newFile)) {
            DialogUtil.error("Rename " + file + " to " + filename + " failed");
        }
    }

    public static void main(String[] args) {
        String catalogName;
        AstroCatConfig configFile = AstroCatConfig.getConfigFile();
        Catalog cat = configFile.getCatalog(catalogName = "Guide Star Catalog at ESO");
        if (cat == null) {
            System.out.println("Can't find entry for catalog: " + catalogName);
            System.exit(1);
        } else {
            System.out.println("Test passed");
        }
    }

    static {
        _defaultURL = null;
        _reloadFlag = false;
    }
}

