/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public class DoubleParameter
extends Parameter {
    private double doubleval_;
    private Double min_;
    private Double max_;
    private boolean minInclusive_;
    private boolean maxInclusive_;

    public DoubleParameter(String name) {
        super(name);
        this.setUsage("<float-value>");
    }

    public void setMinimum(double min, boolean inclusive) {
        this.min_ = Double.isNaN(min) ? null : new Double(min);
        this.minInclusive_ = inclusive;
    }

    public void setMaximum(double max, boolean inclusive) {
        this.max_ = Double.isNaN(max) ? null : new Double(max);
    }

    public void setValueFromString(Environment env, String stringval) throws TaskException {
        double dval;
        if (this.isNullPermitted() && (stringval == null || stringval.trim().length() == 0)) {
            dval = Double.NaN;
        } else {
            try {
                dval = Double.parseDouble(stringval);
            }
            catch (NumberFormatException e) {
                throw new ParameterValueException((Parameter)this, e.getMessage());
            }
        }
        if (this.min_ != null) {
            double dmin = this.min_;
            if (this.minInclusive_) {
                if (dval < dmin) {
                    throw new ParameterValueException((Parameter)this, dval + " < minimum value " + dmin);
                }
            } else if (dval <= dmin) {
                throw new ParameterValueException((Parameter)this, dval + " <= minimum value " + dmin);
            }
        }
        if (this.max_ != null) {
            double dmax = this.max_;
            if (this.maxInclusive_) {
                if (dval > dmax) {
                    throw new ParameterValueException((Parameter)this, dval + " > maximum value " + dmax);
                }
            } else if (dval >= dmax) {
                throw new ParameterValueException((Parameter)this, dval + " >= maximum value " + dmax);
            }
        }
        this.doubleval_ = dval;
        super.setValueFromString(env, stringval);
    }

    public double doubleValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.doubleval_;
    }
}

