/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager;

public class ReaderPreferenceReadWriteLock {
    protected long activeReaders_ = 0L;
    protected Thread activeWriter_ = null;
    protected long waitingReaders_ = 0L;
    protected long waitingWriters_ = 0L;
    protected final ReaderLock readerLock_ = new ReaderLock();
    protected final WriterLock writerLock_ = new WriterLock();

    public Sync writeLock() {
        return this.writerLock_;
    }

    public Sync readLock() {
        return this.readerLock_;
    }

    protected synchronized void cancelledWaitingReader() {
        --this.waitingReaders_;
    }

    protected synchronized void cancelledWaitingWriter() {
        --this.waitingWriters_;
    }

    protected boolean allowReader() {
        return this.activeWriter_ == null;
    }

    protected synchronized boolean startRead() {
        boolean allowRead = this.allowReader();
        if (allowRead) {
            ++this.activeReaders_;
        }
        return allowRead;
    }

    protected synchronized boolean startWrite() {
        boolean allowWrite;
        boolean bl = allowWrite = this.activeWriter_ == null && this.activeReaders_ == 0L;
        if (allowWrite) {
            this.activeWriter_ = Thread.currentThread();
        }
        return allowWrite;
    }

    protected synchronized boolean startReadFromNewReader() {
        boolean pass = this.startRead();
        if (!pass) {
            ++this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromNewWriter() {
        boolean pass = this.startWrite();
        if (!pass) {
            ++this.waitingWriters_;
        }
        return pass;
    }

    protected synchronized boolean startReadFromWaitingReader() {
        boolean pass = this.startRead();
        if (pass) {
            --this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromWaitingWriter() {
        boolean pass = this.startWrite();
        if (pass) {
            --this.waitingWriters_;
        }
        return pass;
    }

    protected synchronized Signaller endRead() {
        if (--this.activeReaders_ == 0L && this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    protected synchronized Signaller endWrite() {
        this.activeWriter_ = null;
        if (this.waitingReaders_ > 0L && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    protected class ReaderLock
    extends Signaller
    implements Sync {
        protected ReaderLock() {
            super(ReaderPreferenceReadWriteLock.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                if (!ReaderPreferenceReadWriteLock.this.startReadFromNewReader()) {
                    try {
                        do {
                            this.wait();
                        } while (!ReaderPreferenceReadWriteLock.this.startReadFromWaitingReader());
                        return;
                    }
                    catch (InterruptedException ex) {
                        ReaderPreferenceReadWriteLock.this.cancelledWaitingReader();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                ReaderPreferenceReadWriteLock.this.writerLock_.signalWaiters();
            }
        }

        @Override
        public void unlock() {
            Signaller s = ReaderPreferenceReadWriteLock.this.endRead();
            if (s != null) {
                s.signalWaiters();
            }
        }

        @Override
        synchronized void signalWaiters() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                block10: {
                    if (msecs <= 0L) {
                        return ReaderPreferenceReadWriteLock.this.startRead();
                    }
                    if (ReaderPreferenceReadWriteLock.this.startReadFromNewReader()) {
                        return true;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    do {
                        try {
                            this.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            ReaderPreferenceReadWriteLock.this.cancelledWaitingReader();
                            ie = ex;
                            break block10;
                        }
                        if (!ReaderPreferenceReadWriteLock.this.startReadFromWaitingReader()) continue;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    ReaderPreferenceReadWriteLock.this.cancelledWaitingReader();
                }
            }
            ReaderPreferenceReadWriteLock.this.writerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }

    protected class WriterLock
    extends Signaller
    implements Sync {
        protected WriterLock() {
            super(ReaderPreferenceReadWriteLock.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            InterruptedException ie = null;
            WriterLock writerLock = this;
            synchronized (writerLock) {
                if (!ReaderPreferenceReadWriteLock.this.startWriteFromNewWriter()) {
                    try {
                        do {
                            this.wait();
                        } while (!ReaderPreferenceReadWriteLock.this.startWriteFromWaitingWriter());
                        return;
                    }
                    catch (InterruptedException ex) {
                        ReaderPreferenceReadWriteLock.this.cancelledWaitingWriter();
                        this.notify();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                ReaderPreferenceReadWriteLock.this.readerLock_.signalWaiters();
            }
        }

        @Override
        public void unlock() {
            Signaller s = ReaderPreferenceReadWriteLock.this.endWrite();
            if (s != null) {
                s.signalWaiters();
            }
        }

        @Override
        synchronized void signalWaiters() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            WriterLock writerLock = this;
            synchronized (writerLock) {
                block10: {
                    if (msecs <= 0L) {
                        return ReaderPreferenceReadWriteLock.this.startWrite();
                    }
                    if (ReaderPreferenceReadWriteLock.this.startWriteFromNewWriter()) {
                        return true;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    do {
                        try {
                            this.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            ReaderPreferenceReadWriteLock.this.cancelledWaitingWriter();
                            this.notify();
                            ie = ex;
                            break block10;
                        }
                        if (!ReaderPreferenceReadWriteLock.this.startWriteFromWaitingWriter()) continue;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    ReaderPreferenceReadWriteLock.this.cancelledWaitingWriter();
                    this.notify();
                }
            }
            ReaderPreferenceReadWriteLock.this.readerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }

    public static interface Sync {
        public static final long ONE_SECOND = 1000L;
        public static final long ONE_MINUTE = 60000L;
        public static final long ONE_HOUR = 3600000L;
        public static final long ONE_DAY = 86400000L;
        public static final long ONE_WEEK = 604800000L;
        public static final long ONE_YEAR = 31556952000L;
        public static final long ONE_CENTURY = 3155695200000L;

        public void lock();

        public boolean attempt(long var1) throws InterruptedException;

        public void unlock();
    }

    protected abstract class Signaller {
        protected Signaller(ReaderPreferenceReadWriteLock this$0) {
        }

        abstract void signalWaiters();
    }
}

