/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.util.Properties;
import jsky.util.Preferences;

public class ProxyServerUtil {
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";

    public static void init() {
        String httpsNonProxyHosts;
        String httpNonProxyHosts;
        String port;
        String savedHttpProxyHost = Preferences.get(HTTP_PROXY_HOST);
        String savedHttpProxyPort = Preferences.get(HTTP_PROXY_PORT);
        String savedHttpsProxyHost = Preferences.get(HTTPS_PROXY_HOST);
        String savedHttpsProxyPort = Preferences.get(HTTPS_PROXY_PORT);
        String savedHttpNonProxyHosts = Preferences.get(HTTP_NON_PROXY_HOSTS);
        String savedHttpsNonProxyHosts = Preferences.get(HTTPS_NON_PROXY_HOSTS);
        String httpProxyHostOption = System.getProperty(HTTP_PROXY_HOST);
        String httpProxyPortOption = System.getProperty(HTTP_PROXY_PORT);
        String httpsProxyHostOption = System.getProperty(HTTPS_PROXY_HOST);
        String httpsProxyPortOption = System.getProperty(HTTPS_PROXY_PORT);
        String httpNonProxyHostsOption = System.getProperty(HTTP_NON_PROXY_HOSTS);
        String httpsNonProxyHostsOption = System.getProperty(HTTPS_NON_PROXY_HOSTS);
        String host = httpProxyHostOption;
        if (host == null) {
            host = savedHttpProxyHost;
        }
        if (host != null && !host.equals(httpProxyHostOption) && host.length() != 0) {
            System.setProperty(HTTP_PROXY_HOST, host);
        }
        if ((port = httpProxyPortOption) == null) {
            port = savedHttpProxyPort;
        }
        if (port != null && !port.equals(httpProxyPortOption)) {
            System.setProperty(HTTP_PROXY_PORT, port);
        }
        if ((host = httpsProxyHostOption) == null) {
            host = savedHttpsProxyHost;
        }
        if (host != null && !host.equals(httpsProxyHostOption) && host.length() != 0) {
            System.setProperty(HTTPS_PROXY_HOST, host);
        }
        if ((port = httpsProxyPortOption) == null) {
            port = savedHttpsProxyPort;
        }
        if (port != null && !port.equals(httpsProxyPortOption)) {
            System.setProperty(HTTPS_PROXY_PORT, port);
        }
        if ((httpNonProxyHosts = httpNonProxyHostsOption) == null) {
            httpNonProxyHosts = savedHttpNonProxyHosts;
        }
        if (httpNonProxyHosts != null && !httpNonProxyHosts.equals(httpNonProxyHostsOption) && httpNonProxyHosts.length() != 0) {
            System.setProperty(HTTP_NON_PROXY_HOSTS, httpNonProxyHosts);
        }
        if ((httpsNonProxyHosts = httpsNonProxyHostsOption) == null) {
            httpsNonProxyHosts = savedHttpsNonProxyHosts;
        }
        if (httpsNonProxyHosts != null && !httpsNonProxyHosts.equals(httpsNonProxyHostsOption) && httpsNonProxyHosts.length() != 0) {
            System.setProperty(HTTPS_NON_PROXY_HOSTS, httpsNonProxyHosts);
        }
    }

    public static void setProxy(String httpProxyHost, int httpProxyPort, String httpsProxyHost, int httpsProxyPort, String httpNonProxyHosts, String httpsNonProxyHosts) {
        String httpProxyPortStr = String.valueOf(httpProxyPort);
        String httpsProxyPortStr = String.valueOf(httpsProxyPort);
        Preferences.set(HTTP_PROXY_HOST, httpProxyHost);
        Preferences.set(HTTP_PROXY_PORT, httpProxyPortStr);
        Preferences.set(HTTPS_PROXY_HOST, httpsProxyHost);
        Preferences.set(HTTPS_PROXY_PORT, httpsProxyPortStr);
        Preferences.set(HTTP_NON_PROXY_HOSTS, httpNonProxyHosts);
        Preferences.set(HTTPS_NON_PROXY_HOSTS, httpsNonProxyHosts);
        System.setProperty(HTTP_PROXY_HOST, httpProxyHost);
        System.setProperty(HTTP_PROXY_PORT, httpProxyPortStr);
        System.setProperty(HTTPS_PROXY_HOST, httpsProxyHost);
        System.setProperty(HTTPS_PROXY_PORT, httpsProxyPortStr);
        System.setProperty(HTTP_NON_PROXY_HOSTS, httpNonProxyHosts);
        System.setProperty(HTTPS_NON_PROXY_HOSTS, httpsNonProxyHosts);
    }

    public static void clearProxySettings() {
        Preferences.unset(HTTP_PROXY_HOST);
        Preferences.unset(HTTP_PROXY_PORT);
        Preferences.unset(HTTPS_PROXY_HOST);
        Preferences.unset(HTTPS_PROXY_PORT);
        Preferences.unset(HTTP_NON_PROXY_HOSTS);
        Preferences.unset(HTTPS_NON_PROXY_HOSTS);
        Properties props = System.getProperties();
        props.remove(HTTP_PROXY_HOST);
        props.remove(HTTP_PROXY_PORT);
        props.remove(HTTPS_PROXY_HOST);
        props.remove(HTTPS_PROXY_PORT);
        props.remove(HTTP_NON_PROXY_HOSTS);
        props.remove(HTTPS_NON_PROXY_HOSTS);
    }

    public static String getHttpProxyHost() {
        return System.getProperty(HTTP_PROXY_HOST);
    }

    public static int getHttpProxyPort() {
        String s = System.getProperty(HTTP_PROXY_PORT);
        if (s == null) {
            return 80;
        }
        return Integer.parseInt(s);
    }

    public static String getHttpsProxyHost() {
        return System.getProperty(HTTPS_PROXY_HOST);
    }

    public static int getHttpsProxyPort() {
        String s = System.getProperty(HTTPS_PROXY_PORT);
        if (s == null) {
            return 443;
        }
        return Integer.parseInt(s);
    }

    public static String getHttpNonProxyHosts() {
        return System.getProperty(HTTP_NON_PROXY_HOSTS);
    }

    public static String getHttpsNonProxyHosts() {
        return System.getProperty(HTTPS_NON_PROXY_HOSTS);
    }
}

