/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.enumerations.NetSideBand;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ACASpectralWindowPair;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BLSpectralWindowPair;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.bo.schedblock.data.FrequencySetupData;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.SingleContinuumExpert;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.BasebandPostProcessor;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.DGCReferenceB2BSpectralSpecBuilderFactory;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecMap;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.Range;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public abstract class SpectralSpecWorker {
    final SpectralSetupParameters ssp;
    final Velocity velocity;
    protected final CorrelatorExpert correlatorExpert;
    protected final SBGenerationContext sbContext;
    private static final Frequency THREE_GHZ = Frequency.createFrequencyGHZ(3.0);
    private static final Frequency TWO_GHZ = Frequency.createFrequencyGHZ(2.0);

    protected SpectralSpecWorker(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull CorrelatorType correlatorType, @NonNull Velocity velocity, @NonNull SBGenerationContext sBGenerationContext) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (correlatorType == null) {
            throw new NullPointerException("correlatorType is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("soleTargetVelocity is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        this.ssp = spectralSetupParameters;
        this.velocity = velocity.deepCopy();
        this.sbContext = sBGenerationContext;
        this.correlatorExpert = CorrelatorExpert.getInstance(correlatorType);
    }

    public Map<String, SpectralSpec> getSpectralSpecGroup() throws WizardSBGenerationException {
        SpectralSpec spectralSpec = this.createSpectralSpecWithCorrelatorConfiguration();
        spectralSpec.setSbGenerationContext(this.sbContext);
        this.setupScienceSpectralSpec(spectralSpec, this.ssp, false);
        SpectralSpecMap spectralSpecMap = new SpectralSpecMap(this, spectralSpec, this.sbContext);
        spectralSpecMap.put("SCIENCE", spectralSpec);
        return spectralSpecMap;
    }

    protected abstract SpectralSpec createSpectralSpecWithCorrelatorConfiguration();

    void setupScienceSpectralSpec(@NonNull SpectralSpec spectralSpec, @NonNull SpectralSetupParameters spectralSetupParameters, boolean bl) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        String string = spectralSetupParameters.getType();
        Frequency frequency = null;
        Object object = null;
        ReceiverBand receiverBand = null;
        Velocity velocity = bl ? Velocity.createVelocity() : this.velocity.deepCopy();
        spectralSpec.setSourceVelocity(velocity);
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        if (string.equals(SpectralSetupParameters.TYPE_CONTINUUM)) {
            frequency = spectralSetupParameters.getSingleContinuumFrequency();
            if (spectralSetupParameters.isSingleContinuumSkyFrequency() || bl) {
                object = "SkyCont(" + String.valueOf((Object)frequency) + ")";
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
            } else {
                object = "RestCont(" + String.valueOf((Object)frequency) + ")";
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_REST);
            }
        } else if (string.equals(SpectralSetupParameters.TYPE_FULL)) {
            ScienceSpectralWindow scienceSpectralWindow = spectralSetupParameters.getScienceSpectralWindow(0);
            if (spectralSetupParameters.isDerivedSSP() || VLBIExpert.isScienceGoalLegalVLBISpectralLine(spectralSetupParameters.getScienceGoal())) {
                frequency = scienceSpectralWindow.getCenterFrequency();
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
            } else {
                frequency = scienceSpectralWindow.getCenterFrequency();
                frequencySetup.setDopplerReference(bl ? FrequencySetupData.DOPPLERREFERENCE_TOPO : FrequencySetupData.DOPPLERREFERENCE_REST);
            }
            if (spectralSetupParameters.getRepresentativeSpectralWindow() == null) {
                Log.logger(SpectralSpecWorker.class).warning("Unable to determine representative spectral window");
                throw new WizardSBGenerationException("Unable to determine representative spectral window");
            }
            object = spectralSetupParameters.getRepresentativeSpectralWindow().getTransitionName();
        } else if (string.equals(SpectralSetupParameters.TYPE_SCAN)) {
            throw new RuntimeException("Spectral Window Type is not supported : " + string);
        }
        receiverBand = spectralSetupParameters.getReceiverBand();
        if (receiverBand == null) {
            throw new WizardSBGenerationException("Unable to determine receiver band ");
        }
        frequencySetup.getRestFrequency().setContentInGHz(frequency.getContentInGHz());
        spectralSpec.setName((String)object + " Science setup");
        frequencySetup.setRestFrequency(frequency.deepCopy());
        frequencySetup.setTransitionName((String)object);
        frequencySetup.setReceiverBand(receiverBand.getName());
        spectralSpec.setReceiverType(receiverBand.getType());
        this.setupSpectralSpecConfiguration(spectralSpec, spectralSetupParameters);
        boolean bl2 = false;
        try {
            bl2 = ObsProposal.isVLBIRelated();
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        if (!bl2) {
            new BasebandPostProcessor(spectralSpec).sortBasebandsInScienceSpectralSpecByFrequency();
        }
    }

    private void setupSpectralSpecConfiguration(@NonNull SpectralSpec spectralSpec, @NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        this.setupCommonSpectralSpecConfiguration(abstractCorrelatorConfiguration, spectralSetupParameters);
        boolean bl = spectralSetupParameters.isWalshSwitching();
        String string = spectralSpec.getReceiverType();
        this.configureTSBandDSBReceivers(abstractCorrelatorConfiguration, bl, string);
        this.configureSSBReceivers(abstractCorrelatorConfiguration, string);
        if (bl) {
            abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE);
        }
        if (abstractCorrelatorConfiguration.getReceiverBand().getNumber() == 1) {
            abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_TWO_LOS);
        }
    }

    private void configureSSBReceivers(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration, String string) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("cc is marked non-null but is null");
        }
        if (string == SpectralSpec.RECEIVERTYPE_SSB) {
            abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(true);
        }
    }

    private void configureTSBandDSBReceivers(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration, boolean bl, String string) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("cc is marked non-null but is null");
        }
        if (SpectralSpec.RECEIVERTYPE_TSB.equals(string) || SpectralSpec.RECEIVERTYPE_DSB.equals(string)) {
            abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(true);
            String string2 = bl ? AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE : AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_TWO_LOS;
            abstractCorrelatorConfiguration.setLOOffsettingMode(string2);
        }
    }

    void setupContinuumSpectralSpec(@NonNull SpectralSpec spectralSpec, Frequency frequency, @NonNull String string) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (string == null) {
            throw new NullPointerException("transitionName is marked non-null but is null");
        }
        ReceiverBand receiverBand = null;
        try {
            receiverBand = ReceiverBand.getReceiverBand(frequency);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUIUtilities.warning(null, illegalArgumentException.getMessage());
            throw new WizardSBGenerationException(illegalArgumentException.getMessage());
        }
        spectralSpec.setSourceVelocity(this.velocity.deepCopy());
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        Frequency frequency2 = frequency.deepCopy();
        frequencySetup.setRestFrequency(frequency2);
        frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
        spectralSpec.setName("B" + receiverBand.getNumber() + " " + string + " Setup");
        spectralSpec.getFrequencySetup().setRestFrequency(frequency2);
        spectralSpec.getFrequencySetup().setTransitionName(string);
        spectralSpec.getFrequencySetup().setReceiverBand(receiverBand.getName());
        spectralSpec.setReceiverType(receiverBand.getType());
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        CorrConfigMode corrConfigMode = this.correlatorExpert.getContinuumMode(CorrPolarization.DOUBLE);
        SingleContinuumExpert singleContinuumExpert = new SingleContinuumExpert(frequency, Velocity.createVelocity(), ObservingFrequency.FrequencyType.SKY_FREQUENCY);
        Range<Frequency>[] rangeArray = singleContinuumExpert.calculateSingleContinuumBasebands(false);
        for (int i = 0; i < 4; ++i) {
            Frequency frequency3 = rangeArray[i].mid();
            AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
            abstractBaseBandConfig.setCenterFrequency(frequency3);
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        spectralSpec.setLOInSpectralSpec(Velocity.createVelocity());
        spectralSpec.getCorrelatorConfiguration().updateSideband();
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(true);
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE);
    }

    public SpectralSpec getTDMPhaseSpectralSpec(@NonNull SpectralSpec spectralSpec) {
        boolean[] blArray;
        int n;
        int[] nArray;
        if (spectralSpec == null) {
            throw new NullPointerException("scienceSS is marked non-null but is null");
        }
        SpectralSpec spectralSpec2 = spectralSpec.deepCopy();
        Velocity velocity = this.velocity.deepCopy();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec2.getAbstractCorrelatorConfiguration();
        CorrConfigMode corrConfigMode = this.correlatorExpert.getContinuumMode(CorrPolarization.DOUBLE);
        Frequency frequency = spectralSpec.getLO1Frequency();
        ReceiverBand receiverBand = spectralSpec2.getReceiverBand();
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getLOMin());
        Frequency frequency3 = Frequency.createFrequencyGHZ(receiverBand.getLOMax());
        FrequencyRange frequencyRange = new FrequencyRange(frequency2, frequency3);
        frequency = frequencyRange.clip(frequency);
        Frequency frequency4 = frequency.inverseDopplerShifted(velocity);
        spectralSpec2.setSourceVelocity(velocity);
        spectralSpec2.setName("TDM Cal Setup");
        spectralSpec2.setRestFrequency(frequency4);
        spectralSpec2.clearBaseBand();
        FrequencyRange frequencyRange2 = receiverBand.getIFRange();
        Frequency frequency5 = (Frequency)((Object)frequencyRange2.mid());
        if (((Frequency)((Object)frequencyRange2.range())).getContentInGHz() >= 8.0) {
            nArray = new int[]{-3, -1, 1, 3};
            n = this.isMostWindowsInSideband(spectralSpec, SpectralSpec.SideBand.USB);
            blArray = new boolean[]{n, n, n, n};
        } else {
            nArray = new int[]{-1, 1, -1, 1};
            blArray = new boolean[]{false, false, true, true};
        }
        for (n = 0; n < 4; ++n) {
            AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
            Frequency frequency6 = Frequency.createFrequencyGHZ(nArray[n]);
            int n2 = blArray[n] ? 1 : -1;
            Frequency frequency7 = (Frequency)((Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)frequency5.multiply(n2)))).plus((AbstractDoubleWithUnit)frequency6);
            abstractBaseBandConfig.setCenterFrequency(this.velocity.reverseShift(frequency7));
            abstractBaseBandConfig.setLO2Frequency((Frequency)((Frequency)frequency5.plus((AbstractDoubleWithUnit)frequency6)).plus((AbstractDoubleWithUnit)THREE_GHZ));
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        spectralSpec2.setLOInSpectralSpec(this.velocity);
        spectralSpec2.getCorrelatorConfiguration().updateSideband();
        return spectralSpec2;
    }

    public SpectralSpec getDGCRefBWSWSpectralSpec(@NonNull SpectralSpec spectralSpec) {
        boolean[] blArray;
        int n;
        int[] nArray;
        if (spectralSpec == null) {
            throw new NullPointerException("scienceSpectralSpec is marked non-null but is null");
        }
        SpectralSpec spectralSpec2 = spectralSpec.deepCopy();
        Velocity velocity = this.velocity.deepCopy();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec2.getAbstractCorrelatorConfiguration();
        CorrConfigMode corrConfigMode = this.correlatorExpert.getFDMContinuumMode(this.ssp.getCorrPolarization());
        Frequency frequency = spectralSpec.getLO1Frequency();
        ReceiverBand receiverBand = spectralSpec2.getReceiverBand();
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getLOMin());
        Frequency frequency3 = Frequency.createFrequencyGHZ(receiverBand.getLOMax());
        FrequencyRange frequencyRange = new FrequencyRange(frequency2, frequency3);
        frequency = frequencyRange.clip(frequency);
        Frequency frequency4 = frequency.inverseDopplerShifted(velocity);
        spectralSpec2.setSourceVelocity(velocity);
        spectralSpec2.setName("BWSW Cal Setup");
        spectralSpec2.setRestFrequency(frequency4);
        spectralSpec2.clearBaseBand();
        FrequencyRange frequencyRange2 = receiverBand.getIFRange();
        Frequency frequency5 = (Frequency)((Object)frequencyRange2.mid());
        if (((Frequency)((Object)frequencyRange2.range())).getContentInGHz() >= 8.0) {
            nArray = new int[]{-3, -1, 1, 3};
            n = this.isMostWindowsInSideband(spectralSpec, SpectralSpec.SideBand.USB);
            blArray = new boolean[]{n, n, n, n};
        } else {
            nArray = new int[]{-1, 1, -1, 1};
            blArray = new boolean[]{false, false, true, true};
        }
        for (n = 0; n < 4; ++n) {
            AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
            Frequency frequency6 = Frequency.createFrequencyGHZ(nArray[n]);
            int n2 = blArray[n] ? 1 : -1;
            Frequency frequency7 = (Frequency)((Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)frequency5.multiply(n2)))).plus((AbstractDoubleWithUnit)frequency6);
            abstractBaseBandConfig.setCenterFrequency(this.velocity.reverseShift(frequency7));
            abstractBaseBandConfig.setLO2Frequency((Frequency)((Frequency)frequency5.plus((AbstractDoubleWithUnit)frequency6)).plus((AbstractDoubleWithUnit)THREE_GHZ));
            SpectralWindowI spectralWindowI = abstractBaseBandConfig.addNewSpectralWindow();
            if (spectralWindowI instanceof AbstractSpectralWindow) {
                AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)spectralWindowI;
                abstractSpectralWindow.setSpectralAveragingFactor(2);
                abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
                abstractSpectralWindow.adjustCenterFrequency();
                abstractSpectralWindow.publishCorrConfigMode();
                continue;
            }
            if (spectralWindowI instanceof BLSpectralWindowPair) {
                BLSpectralWindowPair bLSpectralWindowPair = (BLSpectralWindowPair)spectralWindowI;
                bLSpectralWindowPair.setSpectralAveragingFactor(2);
                bLSpectralWindowPair.setCorrConfigMode(corrConfigMode);
                bLSpectralWindowPair.adjustCenterFrequency();
                bLSpectralWindowPair.publishCorrConfigMode();
                continue;
            }
            if (spectralWindowI instanceof ACASpectralWindowPair) {
                ACASpectralWindowPair aCASpectralWindowPair = (ACASpectralWindowPair)spectralWindowI;
                aCASpectralWindowPair.setSpectralAveragingFactor(2);
                aCASpectralWindowPair.setCorrConfigMode(corrConfigMode);
                aCASpectralWindowPair.adjustCenterFrequency();
                aCASpectralWindowPair.publishCorrConfigMode();
                continue;
            }
            throw new RuntimeException("Unable to determine the window type : " + spectralWindowI.getClass().getName());
        }
        spectralSpec2.setLOInSpectralSpec(this.velocity);
        spectralSpec2.getCorrelatorConfiguration().updateSideband();
        return spectralSpec2;
    }

    private boolean isMostWindowsInSideband(SpectralSpec spectralSpec, SpectralSpec.SideBand sideBand) {
        int n = 0;
        int n2 = 0;
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                if (spectralWindowI.getSideBandUse().uses(sideBand)) {
                    ++n;
                    continue;
                }
                ++n2;
            }
        }
        return n >= n2;
    }

    protected void setupCommonSpectralSpecConfiguration(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration, @NonNull SpectralSetupParameters spectralSetupParameters) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("cc is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        abstractCorrelatorConfiguration.setAPCDataSets(AbstractCorrelatorConfiguration.APCDATASETS_AP_UNCORRECTED);
        abstractCorrelatorConfiguration.setCAM(AbstractCorrelatorConfiguration.CAM_NORMAL);
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setEnable90DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE);
        this.setupBasebands(abstractCorrelatorConfiguration, spectralSetupParameters);
        boolean bl = this.sbContext.getGoal().getSpectralSetupParameters().isWalshSwitching();
        if (bl) {
            abstractCorrelatorConfiguration.setEnable90DegreeWalshFunction(bl);
        }
    }

    private void setupBasebands(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration, @NonNull SpectralSetupParameters spectralSetupParameters) {
        Object object;
        Object object2;
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("corrConfiguration is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        boolean bl = VLBIExpert.isScienceGoalLegalVLBISpectralLine(spectralSetupParameters.getScienceGoal());
        boolean bl2 = spectralSetupParameters.isSingleContinuum() && spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.isDerivedSSP() || bl;
        Velocity velocity = bl2 ? Velocity.createVelocity() : spectralSetupParameters.getSourceVelocity();
        SpectralSpec spectralSpec = (SpectralSpec)abstractCorrelatorConfiguration.getParent();
        try {
            object2 = new BaseBandDeployer(spectralSetupParameters);
            Frequency[] frequencyArray = ((BaseBandDeployer)object2).getAdjustedBaseBandCenterFrequencies(bl ? BaseBandDeployer.ObservedFrame.Sky : BaseBandDeployer.ObservedFrame.Rest);
            String[] stringArray = BaseBandSpecification.getKnownBaseBandNameList();
            for (int i = 0; i < frequencyArray.length; ++i) {
                if (frequencyArray[i].isEqual((AbstractDoubleWithUnit)BaseBandDeployer.dummyFrequency)) continue;
                object = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
                ((AbstractBaseBandConfig)object).setCenterFrequency(frequencyArray[i]);
                ((AbstractBaseBandConfig)object).setBaseBandName(stringArray[i]);
            }
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            throw new WizardSBGenerationException(baseBandNotDeployableException);
        }
        try {
            object2 = spectralSetupParameters.getGroupIndexSet();
        }
        catch (InvalidGroupIndexException invalidGroupIndexException) {
            invalidGroupIndexException.printStackTrace();
            throw new WizardSBGenerationException(invalidGroupIndexException);
        }
        spectralSpec.setLOInSpectralSpec(velocity);
        int n = 0;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            ScienceSpectralWindow[] scienceSpectralWindowArray;
            object = (Integer)iterator.next();
            for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindowGroup((Integer)object)) {
                AbstractSpectralWindow abstractSpectralWindow = this.addNewSpectralWindow(abstractCorrelatorConfiguration.getBaseBandConfig(n), scienceSpectralWindow);
                abstractSpectralWindow.setCorrConfigMode(scienceSpectralWindow.getCorrConfigMode());
                abstractSpectralWindow.adjustCenterFrequency();
                abstractSpectralWindow.publishCorrConfigMode();
                abstractSpectralWindow.setScienceSpectralWindow(scienceSpectralWindow);
                abstractSpectralWindow.setRepresentativeWindow(scienceSpectralWindow.getRepresentativeWindow());
                SpectralLine spectralLine = SpectralLine.createSpectralLine();
                spectralLine.setRestFrequency(scienceSpectralWindow.getCenterFrequency().deepCopy());
                spectralLine.setTransition(scienceSpectralWindow.getTransitionName());
                spectralLine.setSplatalogId(scienceSpectralWindow.getSplatalogId());
                abstractSpectralWindow.addSpectralLine(spectralLine);
                if (abstractSpectralWindow.getBandwidth().isEqual((AbstractDoubleWithUnit)TWO_GHZ)) continue;
                BaseBandSpecification baseBandSpecification = abstractCorrelatorConfiguration.getBaseBandConfig(n).getBaseBandSpecification();
                Frequency frequency = (Frequency)baseBandSpecification.getCenterFrequencySky().minus((AbstractDoubleWithUnit)baseBandSpecification.getActualBaseBandCenterFrequencySky(), true);
                Frequency frequency2 = abstractSpectralWindow.getSideBand().equals(NetSideBand.USB.toString()) ? (Frequency)abstractSpectralWindow.getCenterFrequency().minus((AbstractDoubleWithUnit)frequency, true) : (Frequency)abstractSpectralWindow.getCenterFrequency().plus((AbstractDoubleWithUnit)frequency, true);
                frequency2.convertToMHz();
                abstractSpectralWindow.setDesiredCenterFrequency(frequency2);
            }
            ++n;
        }
    }

    protected AbstractBaseBandConfig addNewBaseBandConfig(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("cc is marked non-null but is null");
        }
        SpectralSpec spectralSpec = abstractCorrelatorConfiguration.getSpectralSpec();
        AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec.addNewBaseBand().getBaseBandConfig();
        abstractBaseBandConfig.setDataProducts(AbstractBaseBandConfig.DATAPRODUCTS_CROSS_AND_AUTO);
        abstractBaseBandConfig.setSwitchingType(SpectralSpec.SWITCHINGTYPE_NO_SWITCHING);
        return abstractBaseBandConfig;
    }

    protected AbstractSpectralWindow addNewSpectralWindow(@NonNull AbstractBaseBandConfig abstractBaseBandConfig, @NonNull ScienceSpectralWindow scienceSpectralWindow) {
        if (abstractBaseBandConfig == null) {
            throw new NullPointerException("bbc is marked non-null but is null");
        }
        if (scienceSpectralWindow == null) {
            throw new NullPointerException("ssw is marked non-null but is null");
        }
        AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
        Frequency frequency = Frequency.createFrequencyGHZ(1.875);
        abstractSpectralWindow.setEffectiveBandwidth(frequency);
        abstractSpectralWindow.setEffectiveNumberOfChannels(7680);
        abstractSpectralWindow.setAssociatedSpectralWindowNumberInPair(0);
        abstractSpectralWindow.setSpectralAveragingFactor(scienceSpectralWindow.getAdvancedWindowSetup().getSmoothingFactor());
        abstractSpectralWindow.setWindowFunction(scienceSpectralWindow.getAdvancedWindowSetup().getSmoothingFunction());
        String string = this.ssp.getPolarisation();
        if (this.ssp.isFullPolarisation() && this.sbContext.isSolar() && this.sbContext.getArray().isTP()) {
            string = SpectralSetupParameters.POLARISATION_DOUBLE;
        }
        abstractSpectralWindow.setPolnProducts(CorrPolarization.getCorrPolarization((String)string).polnProducts);
        abstractSpectralWindow.setScienceSpectralWindow(scienceSpectralWindow);
        Velocity velocity = this.ssp.isSingleContinuumSkyFrequency() || this.ssp.isDerivedSSP() ? Velocity.createVelocity() : this.ssp.getSourceVelocity();
        Frequency[] frequencyArray = abstractSpectralWindow.getBaseBandConfig().getLOFrequencies();
        Frequency frequency2 = frequencyArray[0];
        Frequency frequency3 = frequencyArray[1];
        Frequency frequency4 = scienceSpectralWindow.getCenterFrequency().dopplerShifted(velocity);
        NetSideBand netSideBand = frequency4.compareTo((AbstractDoubleWithUnit)frequency2) > 0 ? NetSideBand.USB : NetSideBand.LSB;
        abstractSpectralWindow.setSideBand(netSideBand.toString());
        if (scienceSpectralWindow.getBandWidth().isEqual((AbstractDoubleWithUnit)BaseBandDeployer.BASEBANDWIDTH)) {
            abstractSpectralWindow.getCenterFrequency().setContentInMHz(3000.0);
        } else {
            Frequency frequency5 = netSideBand.getBaseBandFrequency(frequency4, frequency2, frequency3);
            abstractSpectralWindow.getCenterFrequency().setContentInMHz(frequency5.getContentInMHz());
        }
        abstractSpectralWindow.setBandParameters((Frequency)((Object)scienceSpectralWindow.getBandWidth()), scienceSpectralWindow.getNumberOfChannels(), SpectralWindowBand.ChannelType.NOMINAL);
        return abstractSpectralWindow;
    }

    public SpectralSpec getDGCRefB2BSpectralSpec(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("scienceSpectralSpec is marked non-null but is null");
        }
        return DGCReferenceB2BSpectralSpecBuilderFactory.getDGCReferenceB2BSpectralSpecBuilder(spectralSpec, Optional.of(this.sbContext)).createDGCReferenceB2BSpectralSpec(spectralSpec, this.ssp, this);
    }
}

