/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.TPSpectralScanSourceSplitter;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTargetFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import lombok.NonNull;

public class TPSpectralScanSBGenerator
extends SBGeneratorTemplate
implements SBGenerator {
    private static final Collection<ObsType> SCIENCE_SB_CALIBRATIONS = List.of(ObsType.POINTING);

    protected TPSpectralScanSBGenerator(@NonNull SBGenerationContext sBGenerationContext) {
        super(sBGenerationContext.getArray());
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        this.sbContext = sBGenerationContext;
    }

    @Override
    public Collection<Collection<SchedBlock>> getSchedBlocks(@NonNull ScienceGoal scienceGoal) {
        Collection<ScienceGoal> collection;
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (!scienceGoal.isSpectralScan()) {
            throw new WizardSBGenerationException("The science goal must be configured for spectral scans");
        }
        try {
            this.antennaRelatedTOSTimeMultiplier = this.getAntennaMultiplier(scienceGoal);
            this.sbContext.setAntennaRelatedTOSTimeMultiplier(this.antennaRelatedTOSTimeMultiplier);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException("Unable to determine the array multiplier : " + invalidObsProgramParametersException.getMessage());
        }
        try {
            enumSet = TPSpectralScanSBGenerator.determineSBGenerationSchema(scienceGoal, RequestedArray.TP.getType());
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new WizardSBGenerationException("Unable to determine SB generation schema : " + unknownEntityException.getMessage());
        }
        this.parentScienceGoal = scienceGoal;
        this.sbContext.setSBGenerationSchema(enumSet).setScienceGoal(scienceGoal);
        try {
            collection = new TPSpectralScanSourceSplitter(scienceGoal).splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException("Unable to create TP spectral scan single source clusters" + invalidObsProgramParametersException.getMessage());
        }
        ArrayList<Collection<SchedBlock>> arrayList = new ArrayList<Collection<SchedBlock>>();
        for (ScienceGoal scienceGoal2 : collection) {
            ArrayList<SchedBlock> arrayList2 = new ArrayList<SchedBlock>();
            SchedBlock schedBlock = this.createTPSpectralScanScienceSB(scienceGoal2, this.sbContext.getSchemaToUseForSBGeneration(), arrayList2);
            this.setObservingGroupDopplerTarget(schedBlock);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    @Override
    protected double getAntennaMultiplier(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        return Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
    }

    private SchedBlock assembleTPScienceSB(@NonNull ScienceGoal scienceGoal, @NonNull List<IntermediateTarget> list, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, double d, @NonNull SBGeneratorTemplate.SchedBlockType schedBlockType) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("intermediateTargets is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        if (schedBlockType == null) {
            throw new NullPointerException("schedBlockType is marked non-null but is null");
        }
        assert (d > 0.0);
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        Target target = null;
        this.sbContext.setScienceGoal(scienceGoal).setSBGenerationSchema(enumSet).setSBType(schedBlockType).setSB(schedBlock).setAntennaRelatedTOSTimeMultiplier(d);
        schedBlock.setSbGenerationContext(this.sbContext.deepCopy());
        this.getObservingGroup(schedBlock, "Calibrators 1");
        for (IntermediateTarget intermediateTarget : list) {
            for (Target target2 : intermediateTarget.getTargets()) {
                this.addTargetToSchedBlock(schedBlock, target2);
            }
            for (OrderedTarget orderedTarget : intermediateTarget.getOrderedTargets()) {
                ObservingGroup observingGroup = this.getObservingGroup(schedBlock, orderedTarget.getTarget());
                orderedTarget.setIndex(observingGroup.getOrderedTargetCount() + 1);
                observingGroup.addOrderedTarget(orderedTarget);
            }
            target = intermediateTarget.getRepresentativeTarget();
            if (target == null) continue;
            this.setRepresentativeTarget(schedBlock, target);
        }
        SchedBlockWorker.setupSchedBlock(scienceGoal, schedBlock, this.array, d, enumSet);
        SchedBlockWorker.renameMultipleTuningObservingGroups(schedBlock, enumSet);
        return schedBlock;
    }

    private SchedBlock createTPSpectralScanScienceSB(@NonNull ScienceGoal scienceGoal, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, @NonNull Collection<SchedBlock> collection) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("memberOUS is marked non-null but is null");
        }
        this.sbContext.setSBType(SBGeneratorTemplate.SchedBlockType.TPSCIENCE);
        List<IntermediateTarget> list = this.createIntermediateTargets(scienceGoal, enumSet);
        SchedBlock schedBlock = this.assembleTPScienceSB(scienceGoal, list, enumSet, this.antennaRelatedTOSTimeMultiplier, this.sbContext.getSBType());
        schedBlock.setName(schedBlock.getName() + " - Science");
        collection.add(schedBlock);
        return schedBlock;
    }

    private List<IntermediateTarget> createIntermediateTargets(@NonNull ScienceGoal scienceGoal, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        int n;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        int n2 = 1;
        List<IntermediateTarget> list = this.getCalibrationIntermediateTargets(scienceGoal, SCIENCE_SB_CALIBRATIONS, n2, this.sbContext, false);
        try {
            n = scienceGoal.getSpectralSetupParameters().getSpectralScan().getTunings().getNumberOfTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            throw new WizardSBGenerationException(unableToFindSolutionException);
        }
        assert (n > 0);
        n2 = 1;
        for (int i = 0; i < n; ++i) {
            list.addAll(this.getScienceIntermediateTargets(scienceGoal, n2++));
        }
        this.sortTargets(list);
        return list;
    }

    private List<IntermediateTarget> getCalibrationIntermediateTargets(@NonNull ScienceGoal scienceGoal, @NonNull Collection<ObsType> collection, @NonNull Integer n, @NonNull SBGenerationContext sBGenerationContext, boolean bl) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("expectedCalibrators is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("tuningGroup is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
        if (calibrationSetupParameters.isSystemDefinedCalibration() || calibrationSetupParameters.isAmplitudeSpecificSystemDefinedCalibration()) {
            arrayList.addAll(this.getSystemCalIntermediateTargets(scienceGoal, collection, n, sBGenerationContext));
        } else {
            arrayList.addAll(this.getUserDefinedCalIntermediateTargets(scienceGoal, collection, n));
        }
        this.sortTargets(arrayList);
        return arrayList;
    }

    private List<IntermediateTarget> getScienceIntermediateTargets(@NonNull ScienceGoal scienceGoal, int n) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(scienceGoal, targetParameters, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        this.sortTargets(arrayList);
        return arrayList;
    }

    private List<IntermediateTarget> getSystemCalIntermediateTargets(@NonNull ScienceGoal scienceGoal, @NonNull Collection<ObsType> collection, int n, SBGenerationContext sBGenerationContext) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("expectedCalibrators is marked non-null but is null");
        }
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        for (ObsType obsType : collection) {
            QuerySource querySource = QuerySource.createQuerySource(obsType.getCalIntent());
            querySource.setKeyTargetParameters(scienceGoal.getKeyTargetParameters());
            double d = obsType.equals((Object)ObsType.DELAY) || obsType.equals((Object)ObsType.FOCUS) ? 45.0 : 20.0;
            querySource.setSearchRadius(Angle.createAngle((double)d, (String)Angle.UNIT_DEG));
            querySource.setQueryCenter(skyCoordinates.deepCopy());
            querySource.setMaxSources(100);
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, spectralSetupParameters, this.array, this.getObservingGroupManager(), n, sBGenerationContext));
            for (IntermediateTarget intermediateTarget : arrayList) {
                for (Target target : intermediateTarget.getTargets()) {
                    if (!target.hasCheckSourceCalParameters() && !target.hasDelayCalParameters() && !target.hasPointingCalParameters() && !target.hasFocusCalParameters()) continue;
                    target.getFieldSource().clearReference();
                }
            }
        }
        return arrayList;
    }

    private List<IntermediateTarget> getUserDefinedCalIntermediateTargets(@NonNull ScienceGoal scienceGoal, @NonNull Collection<ObsType> collection, int n) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("expectedCalibrators is marked non-null but is null");
        }
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POINTING);
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        querySource.setQueryCenter(skyCoordinates.deepCopy());
        querySource.setMaxSources(100);
        arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
        for (CalibrationTargetParameters targetWithIntent : calibrationSetupParameters.getCalibrationTargetParameters()) {
            if (!collection.contains((Object)targetWithIntent.getObsType()) || targetWithIntent.getObsType().equals((Object)ObsType.POINTING)) continue;
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, targetWithIntent, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        for (TargetWithIntent targetWithIntent : calibrationSetupParameters.getQuerySource()) {
            if (!collection.contains((Object)((QuerySource)targetWithIntent).getObsType()) || ((QuerySource)targetWithIntent).getObsType().equals((Object)ObsType.POINTING)) continue;
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, targetWithIntent, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        return arrayList;
    }
}

