/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.RequiredConfigurations;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import lombok.NonNull;

public final class ShadowingExpert {
    private static final String SHADOWING_FACTOR = " shadowing factor: ";

    public static double getShadowingFactor(@NonNull ScienceGoal scienceGoal, @NonNull RequestedArray requestedArray) throws InvalidConfigurationParametersException, InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("secondaryArrayType is marked non-null but is null");
        }
        if (scienceGoal.isStandAloneACA()) {
            return 1.0;
        }
        Configuration configuration = null;
        RequiredConfigurations requiredConfigurations = ConfigurationHelper.getRecommended12mConfigurations(scienceGoal, scienceGoal.getRepresentativeFrequency());
        Configuration configuration2 = requiredConfigurations.getBest12mExtConfig();
        switch (requestedArray) {
            case TWELVE_M: {
                try {
                    configuration = requiredConfigurations.getTwelveMetreCompactConfig();
                }
                catch (SchedBlockExpert.UnableToDetermine12mCompactConfiguration unableToDetermine12mCompactConfiguration) {
                    return 1.0;
                }
                if (configuration != null) break;
                return 1.0;
            }
            case SEVEN_M: {
                try {
                    configuration = Configuration.getACAConfiguration();
                }
                catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {}
                break;
            }
            default: {
                return 1.0;
            }
        }
        double d = configuration2.getShadowingFactorForArray(scienceGoal);
        double d2 = configuration.getShadowingFactorForArray(scienceGoal);
        double d3 = ShadowingExpert.getShadowingFactor(d, d2);
        if (Log.logger(SchedBlockWorker.class).fine()) {
            Log.logger(SchedBlockWorker.class).fine("primaryConfiguration: " + configuration2.getName() + SHADOWING_FACTOR + d);
            Log.logger(SchedBlockWorker.class).fine("secondaryConfiguration: " + configuration.getName() + SHADOWING_FACTOR + d2);
            Log.logger(SchedBlockWorker.class).fine("shadowingMultiplier: " + d3);
        }
        return d3;
    }

    private static double getShadowingFactor(double d, double d2) {
        return Math.pow((1.0 - d / 100.0) / (1.0 - d2 / 100.0), 2.0);
    }

    public static double getShadowingFactor(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        double d = 1.0;
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        switch (sBGenerationContext.getSBType()) {
            case ACA7M: 
            case TWELVEMCOMPACTCONFIGURATION: {
                if (sBGenerationContext.getGoal().isStandAloneACA()) break;
                Configuration configuration = sBGenerationContext.getPrimaryConfiguration().orElseThrow(() -> new WizardSBGenerationException("Primary configuration expected"));
                Configuration configuration2 = sBGenerationContext.getConfiguration();
                try {
                    ScienceGoal scienceGoal = sBGenerationContext.getGoal();
                    double d2 = configuration.getShadowingFactorForArray(scienceGoal);
                    double d3 = configuration2.getShadowingFactorForArray(scienceGoal);
                    d = ShadowingExpert.getShadowingFactor(d2, d3);
                    if (!Log.logger(SchedBlockWorker.class).fine()) break;
                    Log.logger(SchedBlockWorker.class).fine("primaryConfiguration: " + configuration.getName() + SHADOWING_FACTOR + d2);
                    Log.logger(SchedBlockWorker.class).fine("secondaryConfiguration: " + configuration2.getName() + SHADOWING_FACTOR + d3);
                    Log.logger(SchedBlockWorker.class).fine("shadowingMultiplier: " + d);
                    break;
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    throw new WizardSBGenerationException(invalidObsProgramParametersException);
                }
            }
            default: {
                d = 1.0;
            }
        }
        return d;
    }

    private ShadowingExpert() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

