/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.corrconfig;

import alma.ACS.stringSeqHolder;
import alma.acacorrelator.ACACorrConfigValidator.ACACorrConfigValidator;
import alma.acacorrelator.ACACorrConfigValidator.ACA_XMLParser;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.ArrayRequested;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.valdef.corrconfig.CorrConfigValidatorWrapper;

public class ACACorrConfigValidatorWrapper
implements CorrConfigValidatorWrapper {
    protected ACACorrConfigValidator validator = new ACACorrConfigValidator(this.getCorrelatorType());
    protected ACA_XMLParser parser = new ACA_XMLParser();

    @Override
    public String getCorrelatorType() {
        return "ACACORRELATOR";
    }

    @Override
    public int getMaxNumAntennas(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        Integer n = null;
        try {
            SchedBlock schedBlock = abstractCorrelatorConfiguration.getSpectralSpec().getSchedBlock();
            String string = schedBlock.getObsUnitControl().getArrayRequested();
            ArrayRequested arrayRequested = ArrayRequested.getArrayRequested(string);
            n = arrayRequested.getMaxAntennas();
        }
        catch (NullPointerException nullPointerException) {
            try {
                n = AlmaCapabilities.getInstance().getNumAntennas(Array.ARRAY_7M, abstractCorrelatorConfiguration.getReceiverBand());
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                throw new RuntimeException("Unable to deduce max number of antennas: " + receiverNotFoundException.getMessage());
            }
        }
        return n;
    }

    @Override
    public boolean validateSpectralSpec(SpectralSpec spectralSpec, int n, stringSeqHolder stringSeqHolder2) {
        return this.validator.validateSpectralSpec(spectralSpec.toXml(), n, stringSeqHolder2);
    }
}

