/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project.transfer;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.ot.project.ProjectTreeTransferHandler;
import alma.obsprep.ot.project.transfer.TransferExport;
import alma.obsprep.ot.project.transfer.botransferrers.Export;
import alma.obsprep.ot.project.transfer.botransferrers.Export_AbstractScienceGoal;
import alma.obsprep.ot.project.transfer.botransferrers.Export_AttachableToTarget;
import alma.obsprep.ot.project.transfer.botransferrers.Export_CompositionChild;
import alma.obsprep.ot.project.transfer.botransferrers.Export_Field;
import alma.obsprep.ot.project.transfer.botransferrers.Export_ObsUnit;
import alma.obsprep.ot.project.transfer.botransferrers.Export_ObservingGroup;
import alma.obsprep.ot.project.transfer.botransferrers.Export_WorkbookPage;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.logging.Level;

public class TransferExportBo
implements TransferExport {
    private final Log.Logger logger;
    private final Export[] exps = new Export[]{new Export_Field(), new Export_ObsUnit(), new Export_WorkbookPage(), new Export_ObservingGroup(), new Export_AttachableToTarget(), new Export_AbstractScienceGoal(), new Export_CompositionChild()};
    public static DataFlavor PTN_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + ProjectNodeTransport.class.getName(), "ProjectTreeNode");

    public TransferExportBo() {
        this.logger = Log.logger((Object)this);
    }

    private Export findResponsibleExporter(BusinessObject businessObject) {
        for (Export export : this.exps) {
            if (!export.responsibleFor(businessObject)) continue;
            if (this.logger.trace()) {
                this.logger.log(Log.TRACE, "found appropriate exporter for " + businessObject.getClass().getName() + "@" + businessObject.hashCode() + ": " + export.getClass().getName());
            }
            return export;
        }
        if (this.logger.trace()) {
            this.logger.log(Log.TRACE, "couldn't find appropriate exporter for " + businessObject.getClass().getName() + "@" + businessObject.hashCode());
        }
        return null;
    }

    @Override
    public int allowedActions(ProjectTreeNode projectTreeNode) {
        BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
        Export export = this.findResponsibleExporter(businessObject);
        if (export == null) {
            return 0;
        }
        return export.allowedActions(businessObject);
    }

    @Override
    public void addFlavor(ProjectTreeTransferHandler.PTTTransferable pTTTransferable, ProjectTreeNode projectTreeNode) {
        BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
        if (this.logger.finer()) {
            this.logger.finer("packaging for transfer: " + String.valueOf(businessObject) + "@" + businessObject.hashCode());
        }
        ProjectNodeTransport projectNodeTransport = new ProjectNodeTransport(projectTreeNode);
        pTTTransferable.add(projectNodeTransport, PTN_FLAVOR);
    }

    @Override
    public void finishExport(Transferable transferable, int n) {
        if (this.logger.debug()) {
            this.logger.log(Log.DEBUG, this.logger.vformat("finishing the export", new Object[]{transferable, ProjectTreeTransferHandler.decode(n)}));
        }
        try {
            switch (n) {
                case 0x40000000: {
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ProjectNodeTransport projectNodeTransport = (ProjectNodeTransport)transferable.getTransferData(PTN_FLAVOR);
                    ProjectTreeNode projectTreeNode = projectNodeTransport.node;
                    BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
                    Export export = this.findResponsibleExporter(businessObject);
                    if (export == null) {
                        this.logger.info("won't finish export: internal inconsistency");
                        break;
                    }
                    if ((export.allowedActions(businessObject) & 2) == 0) {
                        this.logger.info("won't finish export: move not supported for this element");
                        break;
                    }
                    export.performRemoval(businessObject);
                    break;
                }
                default: {
                    this.logger.info("can't finish export: unexpected action: " + n);
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.FINE, "failed to finish export: " + String.valueOf(exception), (Throwable)exception);
        }
        if (this.logger.fine()) {
            this.logger.fine("end of transfer operation");
        }
    }

    public static class ProjectNodeTransport {
        public ProjectTreeNode node = null;

        public ProjectNodeTransport(ProjectTreeNode projectTreeNode) {
            this.node = projectTreeNode;
        }

        public String toString() {
            String string = this.getClass().getSimpleName();
            String string2 = this.node == null ? "<empty>" : this.node.toString();
            return string + "@" + this.hashCode() + "[content=" + string2 + "]";
        }
    }
}

