/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.valuetypes;

import alma.obsprep.bo.annotations.SkyField;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.models.valuetypes.OffsetModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.valuetypes.SkyCoordinates;

public class CoordsModel
extends Model {
    protected OffsetModel offsetCoordsModel = new OffsetModel(null);
    protected SkyCoordsModel skyCoordsModel = new SkyCoordsModel(null);

    public CoordsModel(SkyField skyField) {
        super(skyField);
        this.registerSubModel(this.offsetCoordsModel);
        this.registerSubModel(this.skyCoordsModel);
        this.setDocument(skyField);
    }

    public SkyField getSkyField() {
        return (SkyField)this.document;
    }

    @Override
    public void publish() {
        if (this.document != null) {
            SkyCoordinates skyCoordinates = this.getSkyField().getFieldCenterCoordinates();
            this.publish(CoordsEditor.FID_COORDS_TYPE, skyCoordinates.getType());
        }
        this.offsetCoordsModel.publish();
        this.skyCoordsModel.publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(CoordsEditor.FID_COORDS_TYPE)) {
            String string = (String)object;
            SkyField skyField = this.getSkyField();
            if (skyField != null) {
                SkyCoordinates skyCoordinates = skyField.getFieldCenterCoordinates();
                skyCoordinates.toCoordinatesInType(skyField.getOrigin(), string);
                this.offsetCoordsModel.publish();
                this.skyCoordsModel.publish();
            }
            return string;
        }
        if (fieldID.equals(CoordsEditor.FID_COORDS_SYSTEM)) {
            this.skyCoordsModel.publish(CoordsEditor.FID_COORDS_SYSTEM, object);
            this.offsetCoordsModel.publish(CoordsEditor.FID_COORDS_SYSTEM, object);
        }
        return object;
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        if (object != null) {
            SkyCoordinates skyCoordinates = this.getSkyField().getFieldCenterCoordinates();
            this.offsetCoordsModel.setonlyDocument(skyCoordinates);
            this.skyCoordsModel.setonlyDocument(skyCoordinates);
        }
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    public OffsetModel getOffsetCoordsModel() {
        return this.offsetCoordsModel;
    }

    public SkyCoordsModel getSkyCoordsModel() {
        return this.skyCoordsModel;
    }
}

