/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.BOFigureListManager;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperEvent;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperListener;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.PatternFigure;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import jsky.coords.CoordinateConverter;
import jsky.image.gui.MainImageDisplay;

public abstract class Mapper
implements MouseListener,
MouseMotionListener {
    protected AlmaNavigatorImageDisplayPanel imagePanel;
    protected MapperModel mapperModel;
    protected BOFigureListManager boFigureListManager;
    protected boolean disable = false;
    protected boolean active = true;
    protected boolean drawing = false;
    protected List<MapperListener> changeListenerList = new ArrayList<MapperListener>();

    protected Mapper(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel, MapperModel mapperModel) {
        this.imagePanel = almaNavigatorImageDisplayPanel;
        this.mapperModel = mapperModel;
        this.boFigureListManager = new BOFigureListManager(almaNavigatorImageDisplayPanel);
    }

    public MapperModel getModel() {
        return this.mapperModel;
    }

    public BaseSpatialVisualModel getSpatialVisualModel() {
        return this.getModel().getSpatialVisualModel();
    }

    protected boolean isActivated() {
        return this.active;
    }

    public void setDisabled(boolean bl) {
        this.disable = bl;
    }

    protected void setActivated(boolean bl) {
        this.active = !this.disable && bl;
    }

    protected boolean isDrawing() {
        return this.drawing;
    }

    protected void setDrawing(boolean bl) {
        this.drawing = bl;
    }

    protected void setVisible(boolean bl) {
        this.boFigureListManager.setVisible(bl);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void deleteSelectedPattern() {
    }

    public void clear() {
        this.boFigureListManager.deleteAll();
    }

    public void initialize() {
        this.boFigureListManager.deleteAll();
        this.boFigureListManager.initialize();
    }

    public boolean isWcsSet(boolean bl) {
        return this.imagePanel.isWcsSet(bl);
    }

    public MainImageDisplay.CoordSystemType getImageCoordinateSystem() throws NoImageWCSException {
        if (!this.isWcsSet(false)) {
            throw new NoImageWCSException("No WCS information is associated with the image");
        }
        return this.imagePanel.getImageDisplay().getCoordSystem();
    }

    public boolean isImageLoaded() {
        return this.imagePanel.getImageDisplay().isImageLoaded();
    }

    protected CoordinateConverter getCoordinateConverter() {
        return this.imagePanel.getImageDisplay().getCoordinateConverter();
    }

    protected SpatialDocument getAncestorSpatialDocument(PatternFigure patternFigure) {
        for (BusinessObject businessObject = patternFigure.getBusinessObject(); businessObject != null; businessObject = businessObject.getParent()) {
            if (!(businessObject instanceof SpatialDocument)) continue;
            return (SpatialDocument)businessObject;
        }
        return null;
    }

    public boolean addMapperChangeListener(MapperListener mapperListener) {
        return this.changeListenerList.add(mapperListener);
    }

    public boolean removeMapperChangeListener(MapperListener mapperListener) {
        return this.changeListenerList.remove(mapperListener);
    }

    public void clearMapperChangeListener() {
        this.changeListenerList.clear();
    }

    protected void mapperChanged(MapperEvent mapperEvent) {
        for (MapperListener mapperListener : this.changeListenerList) {
            mapperListener.mapperChanged(mapperEvent);
        }
    }

    public boolean getImageFlipped() {
        return this.imagePanel.getImageDisplay().getImageFlipped();
    }

    public double getImageAngle() {
        return this.imagePanel.getImageDisplay().getImageRotation();
    }

    public class NoImageWCSException
    extends Exception {
        public NoImageWCSException(String string) {
            super(string);
        }
    }
}

