/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.schedblock.AbstractSwitchingStateTable;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.valuetypes.Angle;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class BeamSwitchingStateTable
extends AbstractSwitchingStateTable {
    private static final long serialVersionUID = 8912350792595521467L;

    public BeamSwitchingStateTable(TableModel tableModel) {
        super(tableModel);
    }

    @Override
    protected void setupTableCellEditors() {
        super.setupTableCellEditors();
        ValueUnitPairCellEditor.AngleEditor angleEditor = new ValueUnitPairCellEditor.AngleEditor();
        TableColumn tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(angleEditor);
        ValueUnitPairCellEditor.TimeEditor timeEditor = new ValueUnitPairCellEditor.TimeEditor();
        tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setCellEditor(timeEditor);
    }

    @Override
    protected void setupTableCellRenderers() {
        super.setupTableCellRenderers();
        ResourceColumnRenderer resourceColumnRenderer = new ResourceColumnRenderer(){
            private static final long serialVersionUID = -9048767156104266422L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Angle angle = (Angle)((Object)object);
                String string = String.format("%.1f %s", angle.getContentInUnits(Angle.UNIT_ARCMIN), Angle.UNIT_ARCMIN);
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        };
        this.table.setDefaultRenderer(Angle.class, resourceColumnRenderer);
    }
}

