/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.misc.ExpertParametersModel;
import alma.obsprep.ot.models.misc.ExpertParametersTableModel;
import alma.valuetypes.KeywordValue;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import lombok.NonNull;

public class ExpertParametersEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    public static final FieldID KEYWORDVALUE_TABLE_FID = new FieldID("KeywordValueTable");
    private final FieldID addKVFID = new FieldID("ExpertParametersEditor.addKVFID");
    private final FieldID delKVFID = new FieldID("ExpertParametersEditor.delKVFID");
    private JButton kvAddButton = null;
    private JButton kvDelButton = null;
    private JTable kvTable = null;
    private String panelLabel;

    public ExpertParametersEditor(Builder builder) {
        Model model = builder.getModel();
        this.panelLabel = builder.getPanelLabel();
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        ExpertParametersModel expertParametersModel = (ExpertParametersModel)this.getModel();
        this.kvAddButton = new JButton("Add");
        this.kvAddButton.setToolTipText("Add a keyword-value pair");
        this.initEvents(this.kvAddButton, this.addKVFID);
        this.kvDelButton = new JButton("Delete");
        this.kvAddButton.setToolTipText("Delete a keyword-value pair");
        this.initEvents(this.kvDelButton, this.delKVFID);
        this.kvTable = new Table(expertParametersModel.getExpertParametersTableModel()){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int[] nArray = this.getSelectedRows();
                super.tableChanged(tableModelEvent);
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] >= this.getRowCount() || nArray[i] < 0) continue;
                    if (i == 0) {
                        this.setRowSelectionInterval(nArray[i], nArray[i]);
                        continue;
                    }
                    this.addRowSelectionInterval(nArray[i], nArray[i]);
                }
            }
        };
        int n = this.kvDelButton.getPreferredSize().height;
        Dimension dimension = new Dimension(this.kvTable.getPreferredSize());
        dimension.height = n * 3;
        dimension.width *= 2;
        this.kvTable.setPreferredScrollableViewportSize(dimension);
        this.kvTable.getTableHeader().setReorderingAllowed(false);
        this.kvTable.setSelectionMode(2);
        this.kvTable.setColumnSelectionAllowed(false);
        this.kvTable.getSelectionModel().addListSelectionListener(this);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.kvTable);
        this.kvTable.setToolTipText("Set of keyword-value pairs");
        this.kvTable.setName("ExpertParametersEditor.kvTable");
        this.initEvents(this.kvTable, KEYWORDVALUE_TABLE_FID);
        this.kvAddButton.setPreferredSize(this.kvDelButton.getPreferredSize());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.kvAddButton);
        jPanel2.add(this.kvDelButton);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel(this.panelLabel));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        this.addComponent(this, this.layout, this.constraints, jPanel);
    }

    @Override
    public void build() {
        super.build("ExpertParametersEditor");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        ExpertParametersModel expertParametersModel = (ExpertParametersModel)this.getModel();
        if (fieldID.equals(this.addKVFID)) {
            int n = this.kvTable.getSelectedRow();
            this.kvTable.clearSelection();
            expertParametersModel.addKeywordValuePair(n + 1);
            this.setButtons(expertParametersModel);
            return;
        }
        if (fieldID.equals(this.delKVFID)) {
            int[] nArray = this.kvTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                expertParametersModel.deleteKeywordValuePair(nArray[i] - i);
            }
            this.kvTable.clearSelection();
            this.setButtons(expertParametersModel);
            return;
        }
        if (fieldID.equals(KEYWORDVALUE_TABLE_FID)) {
            ((ExpertParametersTableModel)this.kvTable.getModel()).fireTableDataChanged();
            return;
        }
        super.update(fieldID, object);
    }

    private void setButtons(ExpertParametersModel expertParametersModel) {
        int n = expertParametersModel.getKeywordValuePairCount();
        this.setEnabled(this.kvAddButton, this.kvTable.getSelectedRowCount() < 2);
        this.setEnabled(this.kvDelButton, n > 0 && this.kvTable.getSelectedRow() != -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons((ExpertParametersModel)this.getModel());
    }

    public JTable getExpertParametersTable() {
        return this.kvTable;
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        PhaseCalParameters phaseCalParameters = PhaseCalParameters.createPhaseCalParameters();
        KeywordValue keywordValue = KeywordValue.createKeywordValue();
        keywordValue.setKeyword("Test1");
        keywordValue.setValue("0");
        KeywordValue keywordValue2 = KeywordValue.createKeywordValue();
        keywordValue2.setKeyword("Test2");
        keywordValue2.setValue("0.0");
        KeywordValue keywordValue3 = KeywordValue.createKeywordValue();
        keywordValue3.setKeyword("Test3");
        keywordValue3.setValue("Fred");
        KeywordValue keywordValue4 = KeywordValue.createKeywordValue();
        keywordValue4.setKeyword("Test4");
        keywordValue4.setValue("true");
        KeywordValue keywordValue5 = KeywordValue.createKeywordValue();
        keywordValue5.setKeyword("Test5");
        keywordValue5.setValue("1.0e-6");
        PhaseCalParameters phaseCalParameters2 = phaseCalParameters;
        phaseCalParameters2.addExpertParameter(keywordValue);
        ExpertParametersModel expertParametersModel = new ExpertParametersModel(null);
        Builder builder = new Builder();
        ExpertParametersEditor expertParametersEditor = builder.model(expertParametersModel).build();
        expertParametersModel.setDocument((Object)phaseCalParameters2);
        expertParametersEditor.setBorder(BorderFactory.createTitledBorder("Expert Parameters Editor"));
        TestUtilities.runTestApp(expertParametersEditor);
    }

    public static class Builder {
        private Model model;
        private String panelLabel = "Expert Parameters : ";

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder panelLabel(@NonNull String string) {
            if (string == null) {
                throw new NullPointerException("panelLabel is marked non-null but is null");
            }
            this.panelLabel = string;
            return this;
        }

        public ExpertParametersEditor build() {
            return new ExpertParametersEditor(this);
        }

        public Model getModel() {
            return this.model;
        }

        public String getPanelLabel() {
            return this.panelLabel;
        }
    }
}

