/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil;

import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;

public class Autocomplete
implements DocumentListener {
    private final OTTextField textField;
    private final List<String> keywords;
    private Mode mode = Mode.INSERT;

    public Autocomplete(OTTextField oTTextField, List<String> list) {
        this.textField = oTTextField;
        this.keywords = list;
        Collections.sort(list);
    }

    public void addKeyword(String string) {
        this.keywords.add(StringUtils.trimToEmpty((String)string));
        Collections.sort(this.keywords);
        List<String> list = this.removeDuplicateKeywords(this.keywords);
        this.keywords.clear();
        this.keywords.addAll(list);
    }

    private List<String> removeDuplicateKeywords(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2;
            String string3 = string2 = list.get(i);
            int n = 0;
            for (int j = i + 1; j < list.size() && (string = list.get(j)).startsWith(string2); ++j) {
                ++n;
                string3 = string;
            }
            arrayList.add(string3);
            i += n;
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        int n;
        if (documentEvent.getLength() != 1) {
            return;
        }
        int n2 = documentEvent.getOffset();
        String string = null;
        try {
            n = this.textField.getText().length();
            if (n - 1 > n2 + 1) {
                return;
            }
            string = this.textField.getText(0, n2 + 1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        for (n = n2; n >= 0 && Character.isJavaIdentifierPart(string.charAt(n)); --n) {
        }
        if (n2 - n < 2) {
            return;
        }
        String string2 = string.substring(n + 1);
        int n3 = Collections.binarySearch(this.keywords, string2);
        if (n3 < 0 && -n3 <= this.keywords.size()) {
            String string3 = this.keywords.get(-n3 - 1).toLowerCase();
            if (string3.startsWith(string2.toLowerCase())) {
                String string4 = string3.substring(n2 - n);
                SwingUtilities.invokeLater(new CompletionTask(string4, n2 + 1));
            }
        } else {
            this.mode = Mode.INSERT;
        }
    }

    private static enum Mode {
        INSERT,
        COMPLETION;

    }

    private class CompletionTask
    implements Runnable {
        private final String completion;
        private final int position;

        CompletionTask(String string, int n) {
            this.completion = string;
            this.position = n;
        }

        @Override
        public void run() {
            StringBuilder stringBuilder = new StringBuilder(Autocomplete.this.textField.getText());
            stringBuilder.insert(this.position, this.completion);
            Autocomplete.this.textField.setText(stringBuilder.toString());
            Autocomplete.this.textField.setCaretPosition(this.position + this.completion.length());
            Autocomplete.this.textField.moveCaretPosition(this.position);
            Autocomplete.this.mode = Mode.COMPLETION;
        }
    }

    public class CommitAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Autocomplete.this.mode == Mode.COMPLETION) {
                int n = Autocomplete.this.textField.getSelectionEnd();
                StringBuilder stringBuilder = new StringBuilder(Autocomplete.this.textField.getText());
                Autocomplete.this.textField.setText(stringBuilder.toString());
                Autocomplete.this.textField.setCaretPosition(n + 1);
                Autocomplete.this.mode = Mode.INSERT;
            } else {
                Autocomplete.this.textField.replaceSelection("\t");
            }
        }
    }
}

