/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.entity.xmlbinding.obsproposal.ObsProposalRefT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.HashCodeGeneratorInterface;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.JointProposal;
import alma.obsprep.bo.obsproposal.data.InvestigatorData;
import alma.obsprep.bo.obsproposal.data.ObsProposalData;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ObsProposal
extends ObsProposalData
implements HashCodeGeneratorInterface {
    private int objectHash = -1;
    public static final String PHASED_ARRAY_MODE_PROJECT_TYPE = "Phased Array";
    private static final String VLBI_PROJECT_TYPE = "VLBI";
    private static final String STANDARD_PROJECT = "Standard";

    public void resetAttentionFlag() {
        this.setAttentionFlag(false);
        this.clearAttentionReason();
    }

    public boolean isSupplementalCallProposal() {
        return StringUtils.endsWith((CharSequence)this.getCycle(), (CharSequence)".2");
    }

    public void addForAttention(AttentionReasons attentionReasons) {
        this.setAttentionFlag(true);
        this.addAttentionReason(attentionReasons.reason);
    }

    public ObsProposal(alma.entity.xmlbinding.obsproposal.ObsProposal obsProposal) {
        super(obsProposal);
        if (!obsProposal.hasStudentProject()) {
            obsProposal.setStudentProject(false);
        }
    }

    public void initAsNew() {
        super.initAsNew();
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        this.setCycle(almaPolicies.isSupplementalCallEnabled() ? almaPolicies.getSupplementalCallCycleNumber() : almaPolicies.getCycleNumber());
        this.setPrincipalInvestigator(InvestigatorData.createInvestigator());
        this.getProposalFeedback().getTimeAllocationBreakdown();
        if (Telescope.getTelescopeSelection() == Telescope.ESALMA || Telescope.getTelescopeSelection() == Telescope.Cycle2) {
            this.setContinuation(false);
        }
        this.setTitle("");
        this.setStudentProject(false);
        this.setMentor(Investigator.createInvestigator());
        this.setJointProposal(JointProposal.createJointProposal());
        this.setSchedulingFeasibility(false);
    }

    public ObsProposalRefT getReference() {
        ObsProposalRefT obsProposalRefT = super.getReference();
        obsProposalRefT.setDocumentVersion("1");
        return obsProposalRefT;
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        return super.getNameOrDefault();
    }

    public String getNameOrDefault() {
        String string;
        String string2 = this.getName();
        if ((string2 == null || string2.trim().length() == 0) && (string = this.getTitle()) != null && string.trim().length() > 0) {
            return string;
        }
        return super.getNameOrDefault();
    }

    public String getTitle() {
        String string = "";
        try {
            ObsProject obsProject = this.getObsProject();
            if (obsProject != null) {
                string = obsProject.getProjectName();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        return string;
    }

    public void setTitle(String string) {
        try {
            ObsProject obsProject = this.getObsProject();
            if (obsProject != null) {
                obsProject.setProjectName(string);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    public Time getTotalRequestedTime() {
        return this.getTotalRequestedTime(Array.ARRAY_12M, true);
    }

    public Time getTotalOtherTime() {
        Time time = Time.createTime();
        for (ScienceGoal scienceGoal : this.getAbstractScienceGoalScienceGoal()) {
            Collection<ScienceGoal> collection;
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (ScienceGoal scienceGoal2 : collection) {
                try {
                    boolean bl = scienceGoal2.getPerformanceParameters().gettrueUseTP();
                    Time time2 = bl ? scienceGoal2.getTotalRequestedTime(Array.ARRAY_TP) : Time.createTimeSec(0.0);
                    Time time3 = scienceGoal2.getTotalRequestedTime(Array.ARRAY_7M);
                    Time time4 = time2.isGreaterThan((AbstractDoubleWithUnit)time3) ? time2 : time3;
                    time.aggregate(time4);
                    Log.logger((Object)this).info(" In TotalOtherTime:  tpTime = " + String.valueOf(time2) + " , 7m Time  = " + String.valueOf(time3) + ", other time = " + String.valueOf(time4) + "new totalOtherTime = " + String.valueOf(time));
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    Log.logger((Object)this).warning(invalidObsProgramParametersException.getMessage());
                }
            }
        }
        return time;
    }

    public Time getTotalRequestedTime(Array array, boolean bl) {
        Time time = Time.createTime();
        for (ScienceGoal scienceGoal : this.getAbstractScienceGoalScienceGoal()) {
            Collection<ScienceGoal> collection;
            Time time2 = Time.createTime();
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (ScienceGoal scienceGoal2 : collection) {
                try {
                    if (array.equals((Object)Array.ARRAY_12M)) {
                        if (scienceGoal2.isStandAloneACA()) {
                            if (bl) {
                                Time time3 = scienceGoal2.getTotalRequestedTime(Array.ARRAY_7M);
                                var14_17 = scienceGoal2.getTotalRequestedTime(Array.ARRAY_TP);
                                assert (time3 != null && var14_17 != null);
                                time2 = Time.max(time3, (Time)var14_17);
                            }
                        } else {
                            time2 = scienceGoal2.getTotalTimeForSGWithoutACA(false);
                        }
                    } else {
                        boolean bl2 = scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation();
                        var14_17 = SchedBlockExpert.getInstance(scienceGoal);
                        time2 = Array.isTP(array) && bl2 && !((SchedBlockExpert)var14_17).getUseTPArray() ? Time.createTimeSec(0.0) : scienceGoal2.getTotalRequestedTime(bl2 ? Array.ARRAY_12M : array);
                    }
                    time.aggregate(time2);
                }
                catch (ObservingTimeCalculator.UnableToCalculateTimeEstimateException | InvalidObsProgramParametersException exception) {
                    Log.logger((Object)this).warning(exception.getMessage());
                }
            }
        }
        return time;
    }

    private boolean isNonStandardMode(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        boolean bl = false;
        try {
            bl = !SingleFieldScienceGoalModel.establishNonStandardObservingModes(scienceGoal).isEmpty();
        }
        catch (SingleFieldScienceGoalModel.UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
            bl = scienceGoal.getMode().equals(ScienceGoal.MODE_OTHER);
        }
        return bl;
    }

    public Time getTotal12mNonStandardTime() {
        Time time = Time.createTime();
        for (ScienceGoal scienceGoal : this.getAbstractScienceGoalScienceGoal()) {
            Collection<ScienceGoal> collection;
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (ScienceGoal scienceGoal2 : collection) {
                if (!this.isNonStandardMode(scienceGoal2)) continue;
                try {
                    Time time2 = scienceGoal2.getTotalTimeForSGWithoutACA(false);
                    time2.convertToUnit(Time.UNIT_H);
                    time.aggregate(time2);
                }
                catch (ObservingTimeCalculator.UnableToCalculateTimeEstimateException unableToCalculateTimeEstimateException) {
                    Log.logger((Object)this).warning(unableToCalculateTimeEstimateException.getMessage());
                }
            }
        }
        return time;
    }

    public boolean isToO() {
        String string = this.getProposalTypeCode();
        return string != null && string.equals("T");
    }

    public boolean isVLBIorPhasedArray() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getProposalTypeString().trim(), (CharSequence)VLBI_PROJECT_TYPE) || this.isPhasedArray();
    }

    public boolean isVLBI() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getProposalTypeString().trim(), (CharSequence)VLBI_PROJECT_TYPE);
    }

    public boolean isPhasedArray() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getProposalTypeString().trim(), (CharSequence)PHASED_ARRAY_MODE_PROJECT_TYPE);
    }

    public static boolean isProposalPhasedArray() throws UnknownEntityException {
        ObsProject obsProject;
        try {
            obsProject = ObservingToolController.getMyInstance().getPrimaryProject();
        }
        catch (Exception exception) {
            obsProject = ImpexFactory.getInstance().getLastObsProjectLoaded();
        }
        if (obsProject == null) {
            return false;
        }
        ObsProposal obsProposal = obsProject.getObsProposal();
        return obsProposal.isPhasedArray();
    }

    public static boolean isProjectCodeVLBIRelated(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("projectCode is marked non-null but is null");
        }
        return string.equals("V") || string.equals("P");
    }

    public static boolean isVLBIRelated() throws UnknownEntityException {
        ObsProject obsProject;
        try {
            obsProject = ObservingToolController.getMyInstance().getPrimaryProject();
        }
        catch (Exception exception) {
            obsProject = ImpexFactory.getInstance().getLastObsProjectLoaded();
        }
        if (obsProject == null) {
            return false;
        }
        ObsProposal obsProposal = obsProject.getObsProposal();
        return StringUtils.equalsIgnoreCase((CharSequence)obsProposal.getProposalTypeString().trim(), (CharSequence)VLBI_PROJECT_TYPE) || obsProposal.isPhasedArray();
    }

    public static boolean isProposalVLBI() throws UnknownEntityException {
        ObsProject obsProject;
        try {
            obsProject = ObservingToolController.getMyInstance().getPrimaryProject();
        }
        catch (Exception exception) {
            obsProject = ImpexFactory.getInstance().getLastObsProjectLoaded();
        }
        if (obsProject == null) {
            return false;
        }
        ObsProposal obsProposal = obsProject.getObsProposal();
        if (ObsProposal.isProposalPhasedArray()) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)obsProposal.getProposalTypeString().trim(), (CharSequence)VLBI_PROJECT_TYPE);
    }

    public boolean isLargeProgram() {
        String string = this.getProposalTypeCode();
        return string != null && string.equals("L");
    }

    public String getProposalTypeString() {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        String string = super.getProposalTypeString();
        if (StringUtils.equalsIgnoreCase((CharSequence)string.trim(), (CharSequence)STANDARD_PROJECT)) {
            String string2 = almaPolicies.getProposalTypeForCode("S");
            this.setProposalTypeString(string2);
            return string2;
        }
        return string;
    }

    public void setProposalTypeString(String string) {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        if (StringUtils.equalsIgnoreCase((CharSequence)string.trim(), (CharSequence)STANDARD_PROJECT)) {
            string = almaPolicies.getProposalTypeForCode("S");
        }
        super.setProposalTypeString(string);
    }

    public void updateLocalReference() {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getProposalTypeString().trim(), (CharSequence)STANDARD_PROJECT)) {
            this.setProposalTypeString(almaPolicies.getProposalTypeForCode("S"));
        }
    }

    public boolean isACAUsed() {
        for (AbstractScienceGoal abstractScienceGoal : this.getAbstractScienceGoal()) {
            ScienceGoal scienceGoal;
            if (!(abstractScienceGoal instanceof ScienceGoal) || !(scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).getPerformanceParameters().gettrueUseACA()) continue;
            return true;
        }
        return false;
    }

    public void updateRevisionNumberToCurrent() throws ObsProject.UnableToGetDocumentRevisionNumberException {
        String string = MiscUtils.getCurrentDocumentRevisionNumber();
        alma.entity.xmlbinding.obsproposal.ObsProposal obsProposal = this.getCastorObject();
        obsProposal.setRevision(string);
    }

    public boolean isProjectSunBased() {
        for (AbstractScienceGoal abstractScienceGoal : this.getAbstractScienceGoal()) {
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                if (!targetParameters.getNonSiderealMotion() || !targetParameters.getSourceName().equals(TargetParameters.SOLARSYSTEMOBJECT_SUN)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTimeConstrained() {
        for (AbstractScienceGoal abstractScienceGoal : this.getAbstractScienceGoal()) {
            ScienceGoal scienceGoal;
            if (!(abstractScienceGoal instanceof ScienceGoal) || !(scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).getPerformanceParameters().getIsTimeConstrained()) continue;
            return true;
        }
        return false;
    }

    public static boolean isProjectTypeVLBIRelated(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("projectType is marked non-null but is null");
        }
        return string.equals(PHASED_ARRAY_MODE_PROJECT_TYPE) || string.equals(VLBI_PROJECT_TYPE);
    }

    public boolean isUserCoI() throws UnableToDetermineIfUserIsCoIException {
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        UserAuthenticator userAuthenticator = observingToolController.getUserAuthenticator();
        if (userAuthenticator == null) {
            throw new UnableToDetermineIfUserIsCoIException();
        }
        String string = userAuthenticator.getUsername();
        return Stream.of(this.getCoInvestigator()).map(investigator -> investigator.getUserId()).anyMatch(string2 -> string2.equals(string));
    }

    public boolean isUserCoPI() throws UnableToDetermineIfUserIsCoPIException {
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        UserAuthenticator userAuthenticator = observingToolController.getUserAuthenticator();
        if (userAuthenticator == null) {
            throw new UnableToDetermineIfUserIsCoPIException();
        }
        String string = userAuthenticator.getUsername();
        return Stream.of(this.getCoPrincipalInvestigator()).map(investigator -> investigator.getUserId()).anyMatch(string2 -> string2.equals(string));
    }

    public void resetTDMSpectralAveragingForProposal() {
        for (ScienceGoal scienceGoal : this.getAbstractScienceGoalScienceGoal()) {
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            spectralSetupParameters.setSingleContinuumCorrelatorMode(SpectralSetupParameters.SINGLECONTINUUMCORRELATORMODE_LOWRES);
            Stream.of(spectralSetupParameters.getAbstractScienceSpectralWindowScienceSpectralWindow()).forEach(scienceSpectralWindow -> scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(1));
        }
    }

    @Override
    public void generateObjectHash() {
        this.objectHash = MiscUtils.convertToString((BusinessObject)this).hashCode();
    }

    public String toString() {
        return "ObsProposal(objectHash=" + this.getObjectHash() + ")";
    }

    @Override
    public int getObjectHash() {
        return this.objectHash;
    }

    public static enum AttentionReasons {
        SMALLTEXTINPDF("Too much of the PDF text is less than 12 point.");

        private String reason;

        private AttentionReasons(String string2) {
            this.reason = string2;
        }
    }

    public static class UnableToDetermineIfUserIsCoIException
    extends Exception {
    }

    public static class UnableToDetermineIfUserIsCoPIException
    extends Exception {
    }

    public static class VLBIProposalDetectedException
    extends Exception {
        private static final long serialVersionUID = -2007913573548351272L;
    }
}

