/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ObservatoryGoalT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.annotations.SpatialPartOfSpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.data.ObservatoryGoalData;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.boEditors.Wizard;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.services.observatorygoal.ObservatoryGoalWizard;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class ObservatoryGoal
extends ObservatoryGoalData
implements SpectralSpecDocument,
SpatialPartOfSpectralSpecDocument,
CalibratedAbstractScienceGoal {
    public static final String CALIBRATOR_SURVEY = "Calibrator Survey";
    public static final String RADIOMETRIC_POINTING = "Radiometric Pointing";
    public static final String BASELINE_CALIBRATION = "Baseline Calibration";
    private SpectralSetupParameters parentSpectralSetupParameters;

    public ObservatoryGoal(ObservatoryGoalT observatoryGoalT) {
        super(observatoryGoalT);
    }

    public static ObservatoryGoal createObservatoryGoal(String string) {
        ObservatoryGoal observatoryGoal = ObservatoryGoal.createObservatoryGoal();
        observatoryGoal.setPurpose(string);
        return observatoryGoal;
    }

    public static ObservatoryGoal createCalibratorSurveyGoal() {
        return ObservatoryGoal.createObservatoryGoal(CALIBRATOR_SURVEY);
    }

    public static ObservatoryGoal createRadiometricPointingGoal() {
        return ObservatoryGoal.createObservatoryGoal(RADIOMETRIC_POINTING);
    }

    public static ObservatoryGoal createBaselineCalibrationGoal() {
        return ObservatoryGoal.createObservatoryGoal(BASELINE_CALIBRATION);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.getObservatoryGoalQueryParameters();
        this.setUseQuery(true);
        this.getSpectralSetupParameters();
    }

    protected String toTreeStringType() {
        return this.getPurpose();
    }

    public Wizard getWizard() {
        if (this.wizard == null) {
            this.wizard = new ObservatoryGoalWizard(this);
        }
        return this.wizard;
    }

    public Collection<BusinessObject> instantiated() {
        Vector<BusinessObject> vector = new Vector<BusinessObject>();
        return vector;
    }

    public SummaryTableColumns getSummaryTableColumns() {
        return new NullSummaryTableColumn(this);
    }

    public void setTargets(List<ObservatoryGoalTargetParameters> list) {
        this.clearObservatoryGoalTargetParameters();
        this.addAllTargets(list);
    }

    public void addAllTargets(Collection<ObservatoryGoalTargetParameters> collection) {
        for (ObservatoryGoalTargetParameters observatoryGoalTargetParameters : collection) {
            this.addObservatoryGoalTargetParameters(observatoryGoalTargetParameters);
        }
    }

    public void removeAllTargets(Collection<ObservatoryGoalTargetParameters> collection) {
        for (ObservatoryGoalTargetParameters observatoryGoalTargetParameters : collection) {
            this.removeObservatoryGoalTargetParameters(observatoryGoalTargetParameters);
        }
    }

    @Override
    public SpatialPartOfSpectralSpecDocument getSpatialPartOfSpectralSpecDocument() {
        return null;
    }

    @Override
    public SpectralSpec getSpectralSpec() {
        return null;
    }

    @Override
    public Velocity getSourceVelocity() {
        return Velocity.createVelocity();
    }

    public Frequency getRepresentativeFrequency() {
        return this.getSpectralSetupParameters().getSoleFrequency();
    }

    public void setParentSpectralSetupParameters(SpectralSetupParameters spectralSetupParameters) {
        this.parentSpectralSetupParameters = spectralSetupParameters;
    }

    class NullSummaryTableColumn
    implements SummaryTableColumns {
        NullSummaryTableColumn(ObservatoryGoal observatoryGoal) {
        }

        @Override
        public String getHeaderText() {
            return null;
        }

        @Override
        public String getLineText() {
            return null;
        }

        @Override
        public Object[] getLongValues() {
            return null;
        }

        @Override
        public Class<?> getSummaryColumnClass(int n) {
            return null;
        }

        @Override
        public int getSummaryColumnCount() {
            return 0;
        }

        @Override
        public Object[] getSummaryColumnKnownItemList(int n) {
            return null;
        }

        @Override
        public String getSummaryColumnName(int n) {
            return null;
        }

        @Override
        public SummaryTableRow getSummaryTableRow() {
            return null;
        }

        @Override
        public Object getSummaryValueAt(int n) {
            return null;
        }

        @Override
        public boolean isSummaryCellEditable(int n) {
            return false;
        }

        @Override
        public boolean isSummaryCellEnable(int n) {
            return false;
        }

        @Override
        public void setSummaryValueAt(Object object, int n) {
        }
    }
}

