/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import alma.acs.logging.AcsLogLevel;
import alma.cdbErrType.CDBFieldDoesNotExistEx;
import alma.cdbErrType.CDBFieldIsReadOnlyEx;
import alma.cdbErrType.WrongCDBDataTypeEx;
import alma.cdbErrType.wrappers.AcsJCDBFieldDoesNotExistEx;
import com.cosylab.CDB.WDAOPOA;
import com.cosylab.cdb.jdal.DAOImpl;
import com.cosylab.cdb.jdal.WDALImpl;
import com.cosylab.cdb.jdal.XMLTreeNode;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class WDAOImpl
extends WDAOPOA {
    private final DAOImpl daoImpl;
    private final WDALImpl wdal;
    private final Logger m_logger;

    public WDAOImpl(WDALImpl wdal, String name, DAOImpl daoImpl, POA poa, Logger logger) {
        if (wdal == null) {
            throw new NullPointerException("wdal must not be null");
        }
        if (daoImpl == null) {
            throw new NullPointerException("daoImpl must not be null");
        }
        this.wdal = wdal;
        this.daoImpl = daoImpl;
        this.m_logger = logger;
    }

    public void set_long(String propertyName, int value) throws CDBFieldDoesNotExistEx, CDBFieldIsReadOnlyEx {
        try {
            this.setField(propertyName, String.valueOf(value));
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
    }

    public void set_double(String propertyName, double value) throws CDBFieldDoesNotExistEx, CDBFieldIsReadOnlyEx {
        try {
            this.setField(propertyName, String.valueOf(value));
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
    }

    public void set_string(String propertyName, String value) throws CDBFieldDoesNotExistEx, CDBFieldIsReadOnlyEx {
        try {
            this.setField(propertyName, value);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
    }

    public void set_field_data(String propertyName, String value) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx, CDBFieldIsReadOnlyEx {
        try {
            this.setField(propertyName, value);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
    }

    public void set_string_seq(String propertyName, String[] value) throws CDBFieldDoesNotExistEx, CDBFieldIsReadOnlyEx {
        StringBuffer strValue = new StringBuffer(64);
        for (int i = 0; i < value.length; ++i) {
            strValue.append(value[i]).append(',');
        }
        try {
            this.setField(propertyName, strValue.toString());
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
    }

    public void set_long_seq(String propertyName, int[] value) throws CDBFieldDoesNotExistEx, CDBFieldIsReadOnlyEx {
        StringBuffer strValue = new StringBuffer(64);
        for (int i = 0; i < value.length; ++i) {
            strValue.append(value[i]).append(',');
        }
        try {
            this.setField(propertyName, strValue.toString());
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
    }

    public void set_double_seq(String propertyName, double[] value) throws CDBFieldDoesNotExistEx, CDBFieldIsReadOnlyEx {
        StringBuffer strValue = new StringBuffer(64);
        for (int i = 0; i < value.length; ++i) {
            strValue.append(value[i]).append(',');
        }
        try {
            this.setField(propertyName, strValue.toString());
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
    }

    public int get_long(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.daoImpl.get_long(propertyName);
    }

    public double get_double(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.daoImpl.get_double(propertyName);
    }

    public String get_string(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.daoImpl.get_string(propertyName);
    }

    public String get_field_data(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.daoImpl.get_field_data(propertyName);
    }

    public String[] get_string_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.daoImpl.get_string_seq(propertyName);
    }

    public int[] get_long_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.daoImpl.get_long_seq(propertyName);
    }

    public double[] get_double_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        return this.daoImpl.get_double_seq(propertyName);
    }

    public void destroy() {
        this.daoImpl.destroy();
        try {
            POA poa = this.getPOA();
            byte[] thisId = poa.servant_to_id((Servant)this);
            poa.deactivate_object(thisId);
        }
        catch (Exception e) {
            this.m_logger.log((Level)AcsLogLevel.NOTICE, "Exception destroying object " + this + " : " + e);
            e.printStackTrace();
        }
    }

    public XMLTreeNode getRootNode() {
        return this.daoImpl.getRootNode();
    }

    public String getName() {
        return this.daoImpl.getName();
    }

    public POA getPOA() {
        return this.daoImpl.getPOA();
    }

    private void setField(String strFieldName, String value) throws AcsJCDBFieldDoesNotExistEx {
        XMLTreeNode pNode = this.getRootNode();
        StringTokenizer st = new StringTokenizer(strFieldName, "/");
        String fieldName = st.nextToken();
        while (st.hasMoreTokens()) {
            pNode = pNode.m_subNodesMap.get(fieldName);
            if (pNode == null) {
                AcsJCDBFieldDoesNotExistEx e = new AcsJCDBFieldDoesNotExistEx();
                e.setFieldName(strFieldName);
                throw e;
            }
            fieldName = st.nextToken();
        }
        String currentValue = pNode.m_fieldMap.get(fieldName);
        if (currentValue == null) {
            this.m_logger.log((Level)AcsLogLevel.NOTICE, "setField():'" + this.getName() + "' Unable to find field: '" + strFieldName + "'");
            AcsJCDBFieldDoesNotExistEx e = new AcsJCDBFieldDoesNotExistEx();
            e.setFieldName(strFieldName);
            throw e;
        }
        this.m_logger.log((Level)AcsLogLevel.INFO, "setField():'" + this.getName() + "' set '" + strFieldName + "'=" + value);
        this.m_logger.log((Level)AcsLogLevel.DEBUG, "setField(): - Set value in memory");
        pNode.m_fieldMap.put(fieldName, value);
        this.m_logger.log((Level)AcsLogLevel.DEBUG, "setField(): - Set value in disk");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(strFieldName, value);
        try {
            this.m_logger.log((Level)AcsLogLevel.DEBUG, "setField(): - Saving Changes");
            this.wdal.saveChanges(this.getName(), map);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

