/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import alma.acs.logging.AcsLogLevel;
import alma.cdbErrType.CDBExceptionEx;
import alma.cdbErrType.CDBFieldDoesNotExistEx;
import alma.cdbErrType.CDBRecordAlreadyExistsEx;
import alma.cdbErrType.CDBRecordDoesNotExistEx;
import alma.cdbErrType.CDBRecordIsReadOnlyEx;
import alma.cdbErrType.CDBXMLErrorEx;
import alma.cdbErrType.wrappers.AcsJCDBExceptionEx;
import alma.cdbErrType.wrappers.AcsJCDBFieldDoesNotExistEx;
import alma.cdbErrType.wrappers.AcsJCDBRecordAlreadyExistsEx;
import alma.cdbErrType.wrappers.AcsJCDBXMLErrorEx;
import com.cosylab.CDB.DAOPOATie;
import com.cosylab.CDB.WDAO;
import com.cosylab.CDB.WDAOHelper;
import com.cosylab.cdb.jdal.DALImpl;
import com.cosylab.cdb.jdal.DAOImpl;
import com.cosylab.cdb.jdal.WDALBaseImpl;
import com.cosylab.cdb.jdal.WDAOImpl;
import com.cosylab.cdb.jdal.XMLHandler;
import com.cosylab.cdb.jdal.XMLTreeNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class WDALImpl
extends WDALBaseImpl {
    private POA poa = null;
    private HashMap<String, WDAO> wdaoMap = new HashMap();

    public WDALImpl(String[] args, ORB orb, POA poa, Logger logger) {
        super(args, orb, poa, logger);
        this.poa = poa;
    }

    DALImpl getDALImplDelegate() {
        return this.dalImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WDAO get_WDAO_Servant(String curl) throws CDBXMLErrorEx {
        this.dalImpl.totalDALInvocationCounter.incrementAndGet();
        HashMap<String, WDAO> hashMap = this.wdaoMap;
        synchronized (hashMap) {
            if (this.wdaoMap.containsKey(curl)) {
                return this.wdaoMap.get(curl);
            }
        }
        try {
            Servant daoServant = this.poa.reference_to_servant((Object)this.dalImpl.get_DAO_Servant(curl));
            DAOImpl daoImpl = (DAOImpl)((DAOPOATie)daoServant)._delegate();
            WDAOImpl wdaoImpl = new WDAOImpl(this, curl, daoImpl, this.poa, this.logger);
            String name = "WDAO-" + curl;
            byte[] id = name.getBytes();
            this.poa.activate_object_with_id(id, (Servant)wdaoImpl);
            WDAO href = WDAOHelper.narrow((Object)this.poa.servant_to_reference((Servant)wdaoImpl));
            this.wdaoMap.put(curl, href);
            return href;
        }
        catch (Throwable t) {
            String info = "WDAL::get_WDAO_Servant " + t;
            CDBXMLErrorEx xmlErr = new CDBXMLErrorEx();
            this.logger.log((Level)AcsLogLevel.NOTICE, info);
            throw xmlErr;
        }
    }

    public void add_node(String curl, String xml) throws CDBRecordAlreadyExistsEx, CDBXMLErrorEx, CDBExceptionEx {
        this.dalImpl.totalDALInvocationCounter.incrementAndGet();
        this.logger.log((Level)AcsLogLevel.INFO, "add_node " + curl);
        if (this.nodeExists(curl)) {
            this.logger.log((Level)AcsLogLevel.NOTICE, "Record already exists: " + curl);
            AcsJCDBRecordAlreadyExistsEx e2 = new AcsJCDBRecordAlreadyExistsEx();
            e2.setCurl(curl);
            e2.log(this.logger);
            throw e2.toCDBRecordAlreadyExistsEx();
        }
        try {
            this.validateXML(xml);
        }
        catch (AcsJCDBXMLErrorEx e) {
            e.log(this.logger);
            throw e.toCDBXMLErrorEx();
        }
        this.getNodeFile(curl).getParentFile().mkdirs();
        try {
            this.writeXmlData(curl, xml);
        }
        catch (AcsJCDBExceptionEx e) {
            throw e.toCDBExceptionEx();
        }
    }

    public void remove_node(String curl) throws CDBRecordDoesNotExistEx, CDBRecordIsReadOnlyEx {
        this.dalImpl.totalDALInvocationCounter.incrementAndGet();
        this.logger.log((Level)AcsLogLevel.INFO, "remove_node " + curl);
        if (!this.nodeExists(curl)) {
            this.logger.log((Level)AcsLogLevel.NOTICE, "Record does not exist: " + curl);
            throw new CDBRecordDoesNotExistEx();
        }
        File xmlFile = this.getNodeFile(curl);
        boolean deleted = xmlFile.delete();
        if (!deleted) {
            throw new CDBRecordIsReadOnlyEx();
        }
        xmlFile.getParentFile().delete();
        this.clear_cache(curl);
    }

    public void set_DAO(String curl, String xml) throws CDBRecordDoesNotExistEx, CDBFieldDoesNotExistEx, CDBRecordIsReadOnlyEx, CDBXMLErrorEx, CDBExceptionEx {
        this.dalImpl.totalDALInvocationCounter.incrementAndGet();
        this.logger.log((Level)AcsLogLevel.INFO, "set_DAO " + curl);
        if (!this.nodeExists(curl)) {
            this.logger.log((Level)AcsLogLevel.NOTICE, "Record does not exist: " + curl);
            throw new CDBRecordDoesNotExistEx();
        }
        File xmlFile = this.getNodeFile(curl);
        if (!xmlFile.canWrite()) {
            throw new CDBRecordIsReadOnlyEx();
        }
        DAOImpl daoImp = null;
        XMLHandler daoXMLSolver = null;
        XMLHandler xmlSolver = new XMLHandler(false, this.logger);
        this.parseXML(xml, xmlSolver);
        xml = this.dalImpl.get_DAO(curl);
        daoXMLSolver = new XMLHandler(false, this.logger);
        this.parseXML(xml, daoXMLSolver);
        daoImp = new DAOImpl(curl, daoXMLSolver.m_rootNode, this.poa, this.logger);
        LinkedHashMap map = new LinkedHashMap();
        try {
            this.checkforChanges("", xmlSolver.m_rootNode, map, daoImp);
            this.saveChanges(curl, map);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
        catch (AcsJCDBXMLErrorEx e) {
            throw e.toCDBXMLErrorEx();
        }
        catch (AcsJCDBExceptionEx e) {
            throw e.toCDBExceptionEx();
        }
    }

    private void parseXML(String xml, XMLHandler xmlSolver) throws CDBXMLErrorEx {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)xmlSolver);
            if (xmlSolver.m_errorString != null) {
                String info = "XML parser error: " + xmlSolver.m_errorString;
                CDBXMLErrorEx xmlErr = new CDBXMLErrorEx();
                this.logger.log((Level)AcsLogLevel.NOTICE, info);
                throw xmlErr;
            }
        }
        catch (Throwable t) {
            String info = "SAXException " + t;
            CDBXMLErrorEx xmlErr = new CDBXMLErrorEx();
            this.logger.log((Level)AcsLogLevel.NOTICE, info);
            throw xmlErr;
        }
    }

    private synchronized void writeXmlData(String curl, String xmlData) throws AcsJCDBExceptionEx {
        File xmlFile = this.getNodeFile(curl);
        try {
            xmlFile.createNewFile();
            FileWriter fw = new FileWriter(xmlFile);
            fw.write(xmlData);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            AcsJCDBExceptionEx e2 = new AcsJCDBExceptionEx((Throwable)e);
            throw e2;
        }
        this.clear_cache(curl);
    }

    private void checkforChanges(String name, XMLTreeNode node, Map map, DAOImpl dao) throws AcsJCDBFieldDoesNotExistEx, AcsJCDBXMLErrorEx {
        for (String key : node.m_subNodesMap.keySet()) {
            XMLTreeNode childNode = node.m_subNodesMap.get(key);
            if (!childNode.isMapNode()) continue;
            for (String childKey : childNode.m_fieldMap.keySet()) {
                map.put("_MapNode_/" + key + "/" + childKey, childNode.m_fieldMap.get(childKey));
            }
            node.m_subNodesMap.clear();
        }
        for (String key : node.m_fieldMap.keySet()) {
            String currentValue;
            String propertyName = name + "/" + key;
            try {
                currentValue = dao.get_field_data(propertyName);
            }
            catch (Exception e) {
                e.printStackTrace();
                AcsJCDBXMLErrorEx xmlErr = new AcsJCDBXMLErrorEx((Throwable)e);
                throw xmlErr;
            }
            String value = node.m_fieldMap.get(key);
            if (value.equals(currentValue)) continue;
            map.put(propertyName, value);
        }
        for (String key : node.m_subNodesMap.keySet()) {
            this.checkforChanges(name + "/" + key, node.m_subNodesMap.get(key), map, dao);
        }
    }

    public boolean nodeExists(String curl) {
        return this.getNodeFile(curl).exists();
    }

    public File getNodeFile(String curl) {
        String xmlPath = this.dalImpl.getRecordPath(curl);
        this.logger.log((Level)AcsLogLevel.DEBUG, "getNodeFile(" + curl + ") = " + xmlPath);
        return new File(xmlPath);
    }

    public void saveChanges(String curl, Map propertyMap) throws AcsJCDBXMLErrorEx, AcsJCDBExceptionEx, AcsJCDBFieldDoesNotExistEx {
        if (!this.nodeExists(curl)) {
            return;
        }
        WriteXMLHandler xmlHandler = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            xmlHandler = new WriteXMLHandler(this, propertyMap);
            java.lang.Object lexicalParser = saxParser.getProperty("http://xml.org/sax/properties/lexical-handler");
            saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", xmlHandler);
            this.logger.log((Level)AcsLogLevel.DEBUG, "saveChanges('" + curl + "'): - Parsing");
            saxParser.parse(this.getNodeFile(curl), (DefaultHandler)xmlHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            AcsJCDBXMLErrorEx e2 = new AcsJCDBXMLErrorEx((Throwable)e);
            e2.setCurl(curl);
            throw e2;
        }
        StringWriter sw = new StringWriter();
        xmlHandler.writeXML(sw);
        this.validateXML(sw.toString());
        this.writeXmlData(curl, sw.toString());
    }

    public void validateXML(String xml) throws AcsJCDBXMLErrorEx {
        try {
            XMLHandler dalSolver = new XMLHandler(true, this.logger);
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)dalSolver);
            if (dalSolver.m_errorString != null) {
                this.logger.log((Level)AcsLogLevel.NOTICE, dalSolver.m_errorString);
                AcsJCDBXMLErrorEx e2 = new AcsJCDBXMLErrorEx();
                e2.setErrorString(dalSolver.m_errorString);
                throw e2;
            }
        }
        catch (AcsJCDBXMLErrorEx e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            AcsJCDBXMLErrorEx e2 = new AcsJCDBXMLErrorEx(t);
            throw e2;
        }
    }

    private class WriteXMLHandler
    extends XMLHandler
    implements LexicalHandler {
        private Writer writer = null;
        private Map propertyMap = null;
        private String existingComment = null;
        private HashMap arrayMap = null;

        public WriteXMLHandler(WDALImpl wDALImpl, Map propertyMap) {
            super(false, wDALImpl.logger);
            this.propertyMap = propertyMap;
            this.setMarkArrays(1);
        }

        public void writeXML(Writer writer) throws AcsJCDBFieldDoesNotExistEx, AcsJCDBExceptionEx {
            this.writer = writer;
            for (String propertyName : this.propertyMap.keySet()) {
                String value = (String)this.propertyMap.get(propertyName);
                this.setField(propertyName, value, false);
            }
            if (this.arrayMap != null) {
                for (String key : this.arrayMap.keySet()) {
                    this.setField(key, null, true);
                }
            }
            try {
                this.write("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
                this.writeComment();
                this.writeNode(this.m_rootNode, 0);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new AcsJCDBExceptionEx((Throwable)e);
            }
        }

        private void write(String string) throws IOException {
            this.writer.write(string);
        }

        private void writeComment() throws IOException {
            boolean historyExists = false;
            if (this.existingComment == null) {
                this.existingComment = "";
            } else {
                boolean bl = historyExists = this.existingComment.indexOf("- History:") != -1;
            }
            if (!historyExists) {
                this.existingComment = this.existingComment + "\n   - History:\n";
            }
            this.existingComment = this.existingComment + "   -   " + new Date() + " modified by jDAL\n";
            this.write("<!--" + this.existingComment + "-->\n");
        }

        private void setField(String strFieldName, String value, boolean asArray) throws AcsJCDBFieldDoesNotExistEx {
            XMLTreeNode pNode = this.m_rootNode;
            StringTokenizer st = new StringTokenizer(strFieldName, "/");
            String fieldName = st.nextToken();
            while (st.hasMoreTokens()) {
                if (pNode.m_subNodesMap.get(fieldName) == null && strFieldName.startsWith("_MapNode_")) {
                    XMLTreeNode newNode = new XMLTreeNode(pNode);
                    newNode.m_name = fieldName;
                    pNode.m_subNodesMap.put(fieldName, newNode);
                }
                if ((pNode = pNode.m_subNodesMap.get(fieldName)) == null) {
                    AcsJCDBFieldDoesNotExistEx e2 = new AcsJCDBFieldDoesNotExistEx();
                    e2.setFieldName(strFieldName);
                    throw e2;
                }
                fieldName = st.nextToken();
            }
            if (asArray) {
                if (value == null) {
                    value = pNode.m_fieldMap.get(fieldName);
                }
            } else {
                pNode.m_fieldMap.put(fieldName, value);
            }
        }

        private void writeIndent(int indent) throws IOException {
            for (int i = 0; i < indent; ++i) {
                this.write("\t");
            }
        }

        private void writeNode(XMLTreeNode node, int indent) throws IOException {
            this.write(node.toString(false));
        }

        private void putArrayMap(String key, String value) {
            if (this.arrayMap == null) {
                this.arrayMap = new HashMap();
            }
            if (!this.arrayMap.containsKey(key)) {
                this.arrayMap.put(key, value);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (this.m_parent.isArrayNode()) {
                this.putArrayMap(this.m_parent.m_name, attributes.getQName(0));
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.existingComment = new String(ch, start, length);
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }
    }
}

