/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.toolbox;

import diva.canvas.AbstractFigure;
import diva.util.java2d.PaintedShape;
import diva.util.java2d.ShapeUtilities;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class StateBubble
extends AbstractFigure {
    private PaintedShape _outsideEllipse;
    private PaintedShape _insideEllipse;
    private double _spacing = 10.0;
    private int _stateType = 35;
    public static final int NORMAL_STATE = 35;
    public static final int INITIAL_STATE = 36;
    public static final int FINAL_STATE = 37;

    public StateBubble(double x, double y, double width, double height) {
        Ellipse2D.Double s = new Ellipse2D.Double(x, y, width, height);
        this._outsideEllipse = new PaintedShape(s);
    }

    public StateBubble(double x, double y, double width, double height, Paint fill) {
        Ellipse2D.Double s = new Ellipse2D.Double(x, y, width, height);
        this._outsideEllipse = new PaintedShape((Shape)s, fill);
    }

    public Rectangle2D getBounds() {
        return this._outsideEllipse.getBounds();
    }

    public Shape getShape() {
        return this._outsideEllipse.shape;
    }

    public int getStateType() {
        return this._stateType;
    }

    public Stroke getStroke() {
        return this._outsideEllipse.getStroke();
    }

    public Paint getStrokePaint() {
        return this._outsideEllipse.strokePaint;
    }

    public boolean hit(Rectangle2D r) {
        if (!this.isVisible()) {
            return false;
        }
        return this._outsideEllipse.hit(r);
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        this._outsideEllipse.paint(g);
        if (this._insideEllipse != null) {
            this._insideEllipse.paint(g);
        }
    }

    public void setFillPaint(Paint p) {
        this._outsideEllipse.fillPaint = p;
        if (this._insideEllipse != null) {
            this._insideEllipse.fillPaint = p;
        }
        this.repaint();
    }

    public void setStroke(BasicStroke s) {
        this.repaint();
        this._outsideEllipse.stroke = s;
        if (this._insideEllipse != null) {
            this._insideEllipse.stroke = s;
        }
        this.repaint();
    }

    public void setStateType(int type) {
        this.repaint();
        this._stateType = type;
        switch (type) {
            case 35: {
                if (this._insideEllipse != null) {
                    this._insideEllipse = null;
                }
                this._outsideEllipse.setLineWidth(1.0f);
                break;
            }
            case 36: {
                Ellipse2D bounds = (Ellipse2D)this._outsideEllipse.shape;
                Ellipse2D.Double s = new Ellipse2D.Double(bounds.getX() + this._spacing, bounds.getY() + this._spacing, bounds.getWidth() - 2.0 * this._spacing, bounds.getHeight() - 2.0 * this._spacing);
                this._insideEllipse = new PaintedShape(s);
                this._outsideEllipse.setLineWidth(1.0f);
                break;
            }
            case 37: {
                if (this._insideEllipse != null) {
                    this._insideEllipse = null;
                }
                this._outsideEllipse.setLineWidth((float)this._spacing);
            }
        }
        this.repaint();
    }

    public void setStrokePaint(Paint p) {
        this._outsideEllipse.strokePaint = p;
        if (this._insideEllipse != null) {
            this._insideEllipse.strokePaint = p;
        }
        this.repaint();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._outsideEllipse.shape = ShapeUtilities.transformModify(this._outsideEllipse.shape, at);
        if (this._insideEllipse != null) {
            this._insideEllipse.shape = ShapeUtilities.transformModify(this._insideEllipse.shape, at);
        }
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        this._outsideEllipse.shape = ShapeUtilities.translateModify(this._outsideEllipse.shape, x, y);
        if (this._insideEllipse != null) {
            this._insideEllipse.shape = ShapeUtilities.translateModify(this._insideEllipse.shape, x, y);
        }
        this.repaint();
    }
}

