/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.arch.io.hcompress;

import java.io.IOException;
import java.io.OutputStream;

final class HCompressEncoder {
    private StringBuffer error_msg;
    private int PR_SUCCESS = 0;
    private int PR_E_IO = -1;
    private int[] code;
    private int[] ncode;
    private int bitcount;
    private int bo_buffer;
    private int bo_bits_to_go;
    private int qt_bitbuffer;
    private int qt_bits_to_go;

    public HCompressEncoder() {
        int[] nArray = new int[16];
        nArray[0] = 62;
        nArray[2] = 1;
        nArray[3] = 8;
        nArray[4] = 2;
        nArray[5] = 9;
        nArray[6] = 26;
        nArray[7] = 27;
        nArray[8] = 3;
        nArray[9] = 28;
        nArray[10] = 10;
        nArray[11] = 29;
        nArray[12] = 11;
        nArray[13] = 30;
        nArray[14] = 63;
        nArray[15] = 12;
        this.code = nArray;
        this.ncode = new int[]{6, 3, 3, 4, 3, 4, 5, 5, 3, 5, 4, 5, 4, 5, 6, 4};
        this.error_msg = new StringBuffer();
    }

    private int bufcopy(byte[] byArray, int n, byte[] byArray2, MutableInt mutableInt, int n2) {
        int n3 = mutableInt.intValue();
        int n4 = 0;
        while (n4 < n) {
            if (byArray[n4] != 0) {
                this.qt_bitbuffer |= this.code[byArray[n4]] << this.qt_bits_to_go;
                this.qt_bits_to_go += this.ncode[byArray[n4]];
                if (this.qt_bits_to_go >= 8) {
                    byArray2[n3] = (byte)(this.qt_bitbuffer & 0xFF);
                    if (++n3 >= n2) {
                        mutableInt.setValue(n3);
                        return 1;
                    }
                    this.qt_bitbuffer >>= 8;
                    this.qt_bits_to_go -= 8;
                }
            }
            ++n4;
        }
        mutableInt.setValue(n3);
        return 0;
    }

    int doencode(OutputStream outputStream, int[] nArray, int n, int n2, byte[] byArray) {
        int n3 = (n + 1) / 2;
        int n4 = (n2 + 1) / 2;
        this.start_outputing_bits();
        int n5 = this.PR_SUCCESS;
        n5 = this.qtree_encode(outputStream, nArray, 0, n2, n3, n4, byArray[0]);
        if (n5 != this.PR_SUCCESS) {
            return n5;
        }
        n5 = this.qtree_encode(outputStream, nArray, n4, n2, n3, n2 / 2, byArray[1]);
        if (n5 != this.PR_SUCCESS) {
            return n5;
        }
        n5 = this.qtree_encode(outputStream, nArray, n2 * n3, n2, n / 2, n4, byArray[1]);
        if (n5 != this.PR_SUCCESS) {
            return n5;
        }
        n5 = this.qtree_encode(outputStream, nArray, n2 * n3 + n4, n2, n / 2, n2 / 2, byArray[2]);
        if (n5 != this.PR_SUCCESS) {
            return n5;
        }
        this.output_nybble(outputStream, 0);
        this.done_outputing_bits(outputStream);
        return n5;
    }

    int done_outputing_bits(OutputStream outputStream) {
        if (this.bo_bits_to_go < 8) {
            byte by = (byte)(this.bo_buffer << this.bo_bits_to_go);
            try {
                outputStream.write(by);
            }
            catch (IOException iOException) {
                return this.PR_E_IO;
            }
            this.bitcount += this.bo_bits_to_go;
        }
        return this.PR_SUCCESS;
    }

    public int encode(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        int[] nArray2 = new int[3];
        byte[] byArray = new byte[3];
        int n3 = n * n2;
        byte[] byArray2 = new byte[(n3 + 7) / 8];
        int n4 = 0;
        int n5 = 8;
        byArray2[0] = 0;
        int n6 = 0;
        while (n6 < n3) {
            if (nArray[n6] > 0) {
                int n7 = n4;
                byArray2[n7] = (byte)(byArray2[n7] << 1);
                --n5;
            } else if (nArray[n6] < 0) {
                int n8 = n4;
                byArray2[n8] = (byte)(byArray2[n8] << 1);
                int n9 = n4;
                byArray2[n9] = (byte)(byArray2[n9] | 1);
                --n5;
                nArray[n6] = -nArray[n6];
            }
            if (n5 == 0) {
                n5 = 8;
                byArray2[++n4] = 0;
            }
            ++n6;
        }
        if (n5 != 8) {
            int n10 = n4++;
            byArray2[n10] = (byte)(byArray2[n10] << n5);
        }
        int n11 = 0;
        while (n11 < 3) {
            nArray2[n11] = 0;
            ++n11;
        }
        int n12 = (n + 1) / 2;
        int n13 = (n2 + 1) / 2;
        int n14 = 0;
        int n15 = 0;
        n6 = 0;
        while (n6 < n3) {
            n11 = n14 >= n13 && n15 >= n12 ? 2 : (n14 >= n13 || n15 >= n12 ? 1 : 0);
            if (nArray2[n11] < nArray[n6]) {
                nArray2[n11] = nArray[n6];
            }
            if (++n14 >= n2) {
                n14 = 0;
                ++n15;
            }
            ++n6;
        }
        n11 = 0;
        while (n11 < 3) {
            Integer n16 = new Integer((int)(Math.log(nArray2[n11] + 1) / Math.log(2.0) + 0.5));
            byArray[n11] = n16.byteValue();
            if (nArray2[n11] + 1 > 1 << byArray[n11]) {
                int n17 = n11;
                byArray[n17] = (byte)(byArray[n17] + 1);
            }
            ++n11;
        }
        outputStream.write(byArray);
        int n18 = this.doencode(outputStream, nArray, n, n2, byArray);
        if (n18 != this.PR_SUCCESS) {
            throw new IOException("hcompress encoding failed");
        }
        if (n4 > 0) {
            outputStream.write(byArray2, 0, n4);
        }
        return 7 + this.bitcount / 8 + n4;
    }

    private int output_huffman(OutputStream outputStream, int n) {
        return this.output_nbits(outputStream, this.code[n], this.ncode[n]);
    }

    int output_nbits(OutputStream outputStream, int n, int n2) {
        this.bo_buffer <<= n2;
        this.bo_buffer |= n & (1 << n2) - 1;
        this.bo_bits_to_go -= n2;
        if (this.bo_bits_to_go <= 0) {
            byte by = (byte)(this.bo_buffer >> -this.bo_bits_to_go & 0xFF);
            try {
                outputStream.write(by);
            }
            catch (IOException iOException) {
                return this.PR_E_IO;
            }
            this.bo_bits_to_go += 8;
        }
        this.bitcount += n2;
        return this.PR_SUCCESS;
    }

    private int output_nybble(OutputStream outputStream, int n) {
        return this.output_nbits(outputStream, n, 4);
    }

    int qtree_encode(OutputStream outputStream, int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        MutableInt mutableInt = new MutableInt(0);
        boolean bl = false;
        int n7 = n3 > n4 ? n3 : n4;
        if (n7 > 1 << (n6 = (int)(Math.log(n7) / Math.log(2.0) + 0.5))) {
            ++n6;
        }
        int n8 = (n3 + 1) / 2;
        int n9 = (n4 + 1) / 2;
        int n10 = (n8 * n9 + 1) / 2;
        byte[] byArray = new byte[2 * n10];
        byte[] byArray2 = new byte[n10];
        int n11 = n5 - 1;
        while (n11 >= 0) {
            mutableInt.setValue(0);
            this.qt_bitbuffer = 0;
            this.qt_bits_to_go = 0;
            bl = false;
            this.qtree_onebit(nArray, n, n2, n3, n4, byArray, n11);
            int n12 = n3 + 1 >> 1;
            int n13 = n4 + 1 >> 1;
            int n14 = this.bufcopy(byArray, n12 * n13, byArray2, mutableInt, n10);
            if (n14 == 1) {
                n14 = this.write_bdirect(outputStream, nArray, n, n2, n3, n4, byArray, n11);
                if (n14 != this.PR_SUCCESS) {
                    return n14;
                }
            } else {
                int n15 = 1;
                while (n15 < n6 && !bl) {
                    this.qtree_reduce(byArray, n13, n12, n13, byArray);
                    n12 = n12 + 1 >> 1;
                    n13 = n13 + 1 >> 1;
                    n14 = this.bufcopy(byArray, n12 * n13, byArray2, mutableInt, n10);
                    if (n14 == 1) {
                        n14 = this.write_bdirect(outputStream, nArray, n, n2, n3, n4, byArray, n11);
                        if (n14 != this.PR_SUCCESS) {
                            return n14;
                        }
                        bl = true;
                    }
                    ++n15;
                }
                if (!bl) {
                    n14 = this.output_nybble(outputStream, 15);
                    if (n14 != this.PR_SUCCESS) {
                        return n14;
                    }
                    if (mutableInt.intValue() == 0) {
                        if (this.qt_bits_to_go > 0 ? (n14 = this.output_nbits(outputStream, this.qt_bitbuffer & (1 << this.qt_bits_to_go) - 1, this.qt_bits_to_go)) != this.PR_SUCCESS : (n14 = this.output_huffman(outputStream, 0)) != this.PR_SUCCESS) {
                            return n14;
                        }
                    } else {
                        if (this.qt_bits_to_go > 0 && (n14 = this.output_nbits(outputStream, this.qt_bitbuffer & (1 << this.qt_bits_to_go) - 1, this.qt_bits_to_go)) != this.PR_SUCCESS) {
                            return n14;
                        }
                        int n16 = mutableInt.intValue() - 1;
                        while (n16 >= 0) {
                            n14 = this.output_nbits(outputStream, byArray2[n16], 8);
                            if (n14 != this.PR_SUCCESS) {
                                return n14;
                            }
                            --n16;
                        }
                    }
                }
            }
            --n11;
        }
        return this.PR_SUCCESS;
    }

    void qtree_onebit(int[] nArray, int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        int n6;
        int n7;
        int n8 = 1 << n5;
        int n9 = n8 << 1;
        int n10 = n8 << 2;
        int n11 = n8 << 3;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n3 - 1) {
            n7 = n2 * n13;
            int n14 = n7 + n2;
            n6 = 0;
            while (n6 < n4 - 1) {
                byArray[n12] = (byte)((nArray[n + n14 + 1] & n8 | nArray[n + n14] << 1 & n9 | nArray[n + n7 + 1] << 2 & n10 | nArray[n + n7] << 3 & n11) >> n5);
                ++n12;
                n7 += 2;
                n14 += 2;
                n6 += 2;
            }
            if (n6 < n4) {
                byArray[n12] = (byte)((nArray[n + n14] << 1 & n9 | nArray[n + n7] << 3 & n11) >> n5);
                ++n12;
            }
            n13 += 2;
        }
        if (n13 < n3) {
            n7 = n2 * n13;
            n6 = 0;
            while (n6 < n4 - 1) {
                byArray[n12] = (byte)((nArray[n + n7 + 1] << 2 & n10 | nArray[n + n7] << 3 & n11) >> n5);
                ++n12;
                n7 += 2;
                n6 += 2;
            }
            if (n6 < n4) {
                byArray[n12] = (byte)((nArray[n + n7] << 3 & n11) >> n5);
                ++n12;
            }
        }
    }

    void qtree_reduce(byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n2 - 1) {
            n7 = n * n9;
            int n10 = n7 + n;
            n6 = 0;
            while (n6 < n3 - 1) {
                int n11 = 0;
                int n12 = 0;
                n5 = 0;
                n4 = 0;
                if (byArray[n10 + 1] != 0) {
                    n4 = 1;
                }
                if (byArray[n10] != 0) {
                    n5 = 1;
                }
                if (byArray[n7 + 1] != 0) {
                    n12 = 1;
                }
                if (byArray[n7] != 0) {
                    n11 = 1;
                }
                byArray2[n8] = (byte)(n4 | n5 << 1 | n12 << 2 | n11 << 3);
                ++n8;
                n7 += 2;
                n10 += 2;
                n6 += 2;
            }
            if (n6 < n3) {
                n5 = 0;
                n4 = 0;
                if (byArray[n10] != 0) {
                    n4 = 1;
                }
                if (byArray[n7] != 0) {
                    n5 = 1;
                }
                byArray2[n8] = (byte)(n4 << 1 | n5 << 3);
                ++n8;
            }
            n9 += 2;
        }
        if (n9 < n2) {
            n7 = n * n9;
            n6 = 0;
            while (n6 < n3 - 1) {
                n5 = 0;
                n4 = 0;
                if (byArray[n7 + 1] != 0) {
                    n4 = 1;
                }
                if (byArray[n7] != 0) {
                    n5 = 1;
                }
                byArray2[n8] = (byte)(n4 << 2 | n5 << 3);
                ++n8;
                n7 += 2;
                n6 += 2;
            }
            if (n6 < n3) {
                n4 = 0;
                if (byArray[n7] != 0) {
                    n4 = 1;
                }
                byArray2[n8] = (byte)(n4 << 3);
                ++n8;
            }
        }
    }

    void start_outputing_bits() {
        this.bo_buffer = 0;
        this.bo_bits_to_go = 8;
        this.bitcount = 0;
    }

    int write_bdirect(OutputStream outputStream, int[] nArray, int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        this.output_nybble(outputStream, 0);
        this.qtree_onebit(nArray, n, n2, n3, n4, byArray, n5);
        int n6 = 0;
        while (n6 < (n3 + 1) / 2 * ((n4 + 1) / 2)) {
            this.output_nybble(outputStream, byArray[n6]);
            ++n6;
        }
        return this.PR_SUCCESS;
    }

    class MutableInt {
        private int value;

        public MutableInt(int n) {
            this.value = n;
        }

        public MutableInt(Integer n) {
            this.value = n;
        }

        public int intValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

