/*
 * Decompiled with CFR 0.152.
 */
package alma.Control;

import alma.ACS.TimeHelper;
import alma.AntennaMotionPatternMod.AntennaMotionPatternHelper;
import alma.CalDataOriginMod.CalDataOriginHelper;
import alma.CalibrationFunctionMod.CalibrationFunctionHelper;
import alma.CalibrationSetMod.CalibrationSetHelper;
import alma.Control.ArrayIdHelper;
import alma.Control.ScanIntentDataHelper;
import alma.Control.ScanIntentDataSeqHelper;
import alma.Control.ScanStartedEvent;
import alma.ScanIntentMod.ScanIntentHelper;
import alma.asdmIDLTypes.IDLEntityRef;
import alma.asdmIDLTypes.IDLEntityRefHelper;
import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class ScanStartedEventHelper {
    private static volatile TypeCode _type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCode type() {
        if (_type != null) return _type;
        Class<ScanStartedEventHelper> clazz = ScanStartedEventHelper.class;
        synchronized (ScanStartedEventHelper.class) {
            if (_type != null) return _type;
            _type = ORB.init().create_struct_tc(ScanStartedEventHelper.id(), "ScanStartedEvent", new StructMember[]{new StructMember("execId", ScanStartedEventHelper.execIdFactory(), null), new StructMember("arrayName", ScanStartedEventHelper.arrayNameFactory(), null), new StructMember("scanNumber", ScanStartedEventHelper.scanNumberFactory(), null), new StructMember("scanType", ScanStartedEventHelper.scanTypeFactory(), null), new StructMember("startTime", ScanStartedEventHelper.startTimeFactory(), null)});
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type;
        }
    }

    private static TypeCode scanNumberFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)3));
    }

    private static TypeCode arrayNameFactory() {
        return ORB.init().create_alias_tc(ArrayIdHelper.id(), "ArrayId", ORB.init().create_string_tc(0));
    }

    private static TypeCode startTimeFactory() {
        return ORB.init().create_alias_tc(TimeHelper.id(), "Time", ORB.init().get_primitive_tc(TCKind.from_int((int)24)));
    }

    private static TypeCode scanTypeFactory() {
        return ORB.init().create_alias_tc(ScanIntentDataSeqHelper.id(), "ScanIntentDataSeq", ORB.init().create_sequence_tc(0, ORB.init().create_struct_tc(ScanIntentDataHelper.id(), "ScanIntentData", new StructMember[]{new StructMember("scanIntent", ORB.init().create_enum_tc(ScanIntentHelper.id(), "ScanIntent", new String[]{"CALIBRATE_AMPLI", "CALIBRATE_ATMOSPHERE", "CALIBRATE_BANDPASS", "CALIBRATE_DELAY", "CALIBRATE_FLUX", "CALIBRATE_FOCUS", "CALIBRATE_FOCUS_X", "CALIBRATE_FOCUS_Y", "CALIBRATE_PHASE", "CALIBRATE_POINTING", "CALIBRATE_POLARIZATION", "CALIBRATE_SIDEBAND_RATIO", "CALIBRATE_WVR", "DO_SKYDIP", "MAP_ANTENNA_SURFACE", "MAP_PRIMARY_BEAM", "OBSERVE_TARGET", "CALIBRATE_POL_LEAKAGE", "CALIBRATE_POL_ANGLE", "TEST", "UNSPECIFIED", "CALIBRATE_ANTENNA_POSITION", "CALIBRATE_ANTENNA_PHASE", "MEASURE_RFI", "CALIBRATE_ANTENNA_POINTING_MODEL", "SYSTEM_CONFIGURATION", "CALIBRATE_APPPHASE_ACTIVE", "CALIBRATE_APPPHASE_PASSIVE", "OBSERVE_CHECK_SOURCE", "CALIBRATE_DIFFGAIN"}), null), new StructMember("calDataOrig", ORB.init().create_enum_tc(CalDataOriginHelper.id(), "CalDataOrigin", new String[]{"TOTAL_POWER", "WVR", "CHANNEL_AVERAGE_AUTO", "CHANNEL_AVERAGE_CROSS", "FULL_RESOLUTION_AUTO", "FULL_RESOLUTION_CROSS", "OPTICAL_POINTING", "HOLOGRAPHY", "NONE"}), null), new StructMember("calSet", ORB.init().create_enum_tc(CalibrationSetHelper.id(), "CalibrationSet", new String[]{"NONE", "AMPLI_CURVE", "ANTENNA_POSITIONS", "PHASE_CURVE", "POINTING_MODEL", "ACCUMULATE", "TEST", "UNSPECIFIED"}), null), new StructMember("calFunction", ORB.init().create_enum_tc(CalibrationFunctionHelper.id(), "CalibrationFunction", new String[]{"FIRST", "LAST", "UNSPECIFIED"}), null), new StructMember("antennaMotionPattern", ORB.init().create_enum_tc(AntennaMotionPatternHelper.id(), "AntennaMotionPattern", new String[]{"NONE", "CROSS_SCAN", "SPIRAL", "CIRCLE", "THREE_POINTS", "FOUR_POINTS", "FIVE_POINTS", "TEST", "UNSPECIFIED", "STAR", "LISSAJOUS"}), null), new StructMember("onlineCalibration", ORB.init().get_primitive_tc(TCKind.from_int((int)8)), null)})));
    }

    private static TypeCode execIdFactory() {
        return ORB.init().create_struct_tc(IDLEntityRefHelper.id(), "IDLEntityRef", new StructMember[]{new StructMember("entityId", ORB.init().create_string_tc(0), null), new StructMember("partId", ORB.init().create_string_tc(0), null), new StructMember("entityTypeName", ORB.init().create_string_tc(0), null), new StructMember("instanceVersion", ORB.init().create_string_tc(0), null)});
    }

    public static void insert(Any any, ScanStartedEvent s) {
        any.type(ScanStartedEventHelper.type());
        ScanStartedEventHelper.write(any.create_output_stream(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanStartedEvent extract(Any any) {
        InputStream in = any.create_input_stream();
        try {
            ScanStartedEvent scanStartedEvent = ScanStartedEventHelper.read(in);
            return scanStartedEvent;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception " + e.toString());
            }
        }
    }

    public static String id() {
        return "IDL:alma/Control/ScanStartedEvent:1.0";
    }

    public static ScanStartedEvent read(InputStream in) {
        ScanStartedEvent result = new ScanStartedEvent();
        result.execId = IDLEntityRefHelper.read((InputStream)in);
        result.arrayName = in.read_string();
        result.scanNumber = in.read_long();
        result.scanType = ScanIntentDataSeqHelper.read(in);
        result.startTime = in.read_ulonglong();
        return result;
    }

    public static void write(OutputStream out, ScanStartedEvent s) {
        IDLEntityRefHelper.write((OutputStream)out, (IDLEntityRef)s.execId);
        String tmpResult3 = s.arrayName;
        out.write_string(tmpResult3);
        out.write_long(s.scanNumber);
        ScanIntentDataSeqHelper.write(out, s.scanType);
        out.write_ulonglong(s.startTime);
    }
}

