/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table.reduction;

import alma.acs.logging.table.reduction.Antennae;
import alma.acs.logging.table.reduction.ReductionRule;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class AntennaRule
extends ReductionRule {
    private final String baseMessage;
    private final String initialAntenna;
    private final Set<String> antennaNames = new TreeSet<String>();
    private final String initialMessage;
    protected final boolean reducible;

    public AntennaRule(ILogEntry logEntry) {
        super(logEntry);
        this.initialMessage = (String)logEntry.getField(LogField.LOGMESSAGE);
        boolean bl = this.reducible = Antennae.matchAntenna(this.initialMessage) != Antennae.NO_ANTENNA;
        if (this.reducible) {
            StringBuilder temp = new StringBuilder(this.initialMessage);
            this.initialAntenna = Antennae.matchAndReplaceAntenna(temp, "\u0000\u0000\u0000\u0000");
            this.baseMessage = temp.toString();
        } else {
            this.baseMessage = null;
            this.initialAntenna = null;
        }
    }

    @Override
    public boolean applyRule(ILogEntry logToReduce) {
        if (!this.reducible || logToReduce == null) {
            return false;
        }
        String msgStr = logToReduce.getField(LogField.LOGMESSAGE) != null ? (String)logToReduce.getField(LogField.LOGMESSAGE) : "";
        StringBuilder msg = new StringBuilder(msgStr);
        String antName = Antennae.matchAndReplaceAntenna(msg, "\u0000\u0000\u0000\u0000");
        if (antName == null) {
            return false;
        }
        if (this.baseMessage.compareTo(msg.toString()) == 0) {
            if (!antName.equals(this.initialAntenna)) {
                this.antennaNames.add(antName);
            }
            return true;
        }
        return false;
    }

    public String getReducedItems() {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (String antName : this.antennaNames) {
            if (!first) {
                ret.append(',');
                ret.append(' ');
            } else {
                first = false;
            }
            ret.append(antName);
        }
        return ret.toString();
    }

    @Override
    public ILogEntry getReducedLog() {
        String reducedItems = this.getReducedItems();
        if (reducedItems == null || reducedItems.isEmpty()) {
            return this.initialLog;
        }
        Long milliseconds = (Long)this.initialLog.getField(LogField.TIMESTAMP);
        Integer entrytype = ((LogTypeHelper)this.initialLog.getField(LogField.ENTRYTYPE)).ordinal();
        String file = (String)this.initialLog.getField(LogField.FILE);
        Integer line = (Integer)this.initialLog.getField(LogField.LINE);
        String routine = (String)this.initialLog.getField(LogField.ROUTINE);
        String host = (String)this.initialLog.getField(LogField.HOST);
        String process = (String)this.initialLog.getField(LogField.PROCESS);
        String context = (String)this.initialLog.getField(LogField.CONTEXT);
        String thread = (String)this.initialLog.getField(LogField.THREAD);
        String logid = (String)this.initialLog.getField(LogField.LOGID);
        Integer priority = (Integer)this.initialLog.getField(LogField.PRIORITY);
        String uri = (String)this.initialLog.getField(LogField.URI);
        String stackid = (String)this.initialLog.getField(LogField.STACKID);
        Integer stacklevel = (Integer)this.initialLog.getField(LogField.STACKLEVEL);
        String logmessage = (String)this.initialLog.getField(LogField.LOGMESSAGE) + " and also " + reducedItems;
        String srcObject = (String)this.initialLog.getField(LogField.SOURCEOBJECT);
        String audience = (String)this.initialLog.getField(LogField.AUDIENCE);
        String array = (String)this.initialLog.getField(LogField.ARRAY);
        String antenna = (String)this.initialLog.getField(LogField.ANTENNA);
        Vector addDatas = this.initialLog.getAdditionalData();
        LogEntry ret = new LogEntry(milliseconds, entrytype, file, line, routine, host, process, context, thread, logid, priority, uri, stackid, stacklevel, logmessage, srcObject, audience, array, antenna, addDatas);
        return ret;
    }

    @Override
    public boolean isReducingLogs() {
        return !this.antennaNames.isEmpty();
    }

    @Override
    public boolean isReducible() {
        return this.reducible;
    }
}

