/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class UrlDownloader {
    private final URL url;
    private final String fileName;

    public UrlDownloader(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Invalid null URL to download");
        }
        this.url = url;
        this.fileName = this.extractFileName();
    }

    private String extractFileName() {
        int pos = this.url.toString().lastIndexOf("/");
        return pos == -1 ? this.url.toString() : this.url.toString().substring(pos);
    }

    private String getTempFolder() {
        String acsTtempFolder = System.getProperty("ACS.tmp", ".");
        if (acsTtempFolder.equals(".")) {
            acsTtempFolder = System.getProperty("java.io.tmpdir", ".");
        }
        return acsTtempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String download() throws IOException {
        String outFolder = this.getTempFolder();
        String outFName = outFolder + File.separator + this.fileName;
        System.out.println("UrlDownloader: Downloading " + this.url + " as " + outFName);
        ReadableByteChannel rbc = Channels.newChannel(this.url.openStream());
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(outFName);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        System.out.println("UrlDownloader: " + this.url + " downloaded as " + outFName);
        return outFName;
    }
}

