/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.components;

import alma.ACS.OffShootOperations;
import alma.acs.container.ContainerServices;
import alma.acsErrTypeAlarmSourceFactory.ACSASFactoryNotInitedEx;
import alma.acsErrTypeAlarmSourceFactory.FaultStateCreationErrorEx;
import alma.acsErrTypeAlarmSourceFactory.SourceCreationErrorEx;
import alma.alarmsystem.source.ACSAlarmSystemInterface;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import alma.alarmsystem.source.ACSFaultState;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.ArchiveCommunicationException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.helpers.InternalCommunicationHelper;
import alma.xmlstore.AdministrativeOperations;
import alma.xmlstore.AdministrativePackage.MalformedURI;
import alma.xmlstore.AdministrativePackage.NotFound;
import alma.xmlstore.ArchiveInternalError;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdministrativeImpl
implements OffShootOperations,
AdministrativeOperations {
    private Logger logger;
    protected ContainerServices m_containerServices;
    protected String myName;
    private String user;
    private InternalIF internal = null;
    private DBConfiguration dbConfig = null;
    private boolean alarmActive = false;
    private String m_password = "almabtrieb";

    public AdministrativeImpl(String user, Logger logger, ContainerServices containerServices) throws ArchiveException {
        this.m_containerServices = containerServices;
        this.myName = containerServices.getName();
        this.user = user;
        this.logger = logger;
        try {
            this.dbConfig = DBConfiguration.instance((Logger)logger);
        }
        catch (DatabaseException e) {
            logger.severe("Couldn't read dbConfig file.");
            throw new ArchiveException((Throwable)e);
        }
        try {
            this.connect();
        }
        catch (ArchiveInternalError e) {
            logger.severe("Couldn't connect to the internal interface");
            throw new ArchiveException((Throwable)e);
        }
    }

    public boolean ping(boolean fast, boolean recursive, int id) {
        if (fast) {
            return true;
        }
        try {
            InternalIF intIF = InternalIFFactory.getInternalIF((Logger)this.logger);
            boolean ret = intIF.ping();
            if (!ret) {
                this.send_alarm(true);
            } else if (this.alarmActive) {
                this.send_alarm(false);
            }
            return ret;
        }
        catch (Exception e) {
            this.logger.warning("Caught exception: " + e.toString());
            this.send_alarm(true);
            return false;
        }
    }

    public void init(String password) throws ArchiveInternalError {
        if (!password.equals(this.m_password)) {
            throw new ArchiveInternalError("Uncorrect password provided to call this method.");
        }
        try {
            this.internal.init();
        }
        catch (ModuleCriticalException e) {
            try {
                InternalCommunicationHelper.notifyMaster(e, this.m_containerServices, this.myName, this.logger);
            }
            catch (ArchiveCommunicationException e1) {
                this.logger.warning("Can not connect to Archive subsystem master.");
            }
            this.logger.severe("Could not init Administrative component: " + e.toString());
            throw new ArchiveInternalError("Can not initialize internal interface.");
        }
        catch (ArchiveException e) {
            this.logger.severe("Could not init Administrative component: " + e.toString());
            throw new ArchiveInternalError("Can not initialize internal interface.");
        }
    }

    public void reinit(String password) throws ArchiveInternalError {
        if (!password.equals(this.m_password)) {
            throw new ArchiveInternalError("Uncorrect password provided to call this method.");
        }
        try {
            DBConfiguration.instance((Logger)this.logger).reinit(this.logger);
        }
        catch (DatabaseException e) {
            this.logger.warning("Problem during reinit of Archive/Administrative" + e.toString());
            throw new ArchiveInternalError(e.toString());
        }
        this.init(this.m_password);
    }

    private void connect() throws ArchiveInternalError {
        if (this.internal == null) {
            try {
                this.internal = InternalIFFactory.getInternalIF((Logger)this.logger);
                this.logger.log(Level.INFO, "Connected to the internal interface");
            }
            catch (ModuleCriticalException e) {
                try {
                    InternalCommunicationHelper.notifyMaster(e, this.m_containerServices, this.myName, this.logger);
                }
                catch (ArchiveCommunicationException e1) {
                    this.logger.warning("Can not connect to Archive subsystem master");
                }
                this.logger.log(Level.SEVERE, "Unable to connect to the internal interface " + e.getCause().getMessage(), e);
                throw new ArchiveInternalError(e.getCause().toString());
            }
            catch (ArchiveException e) {
                this.logger.log(Level.SEVERE, "Unable to connect to the internal interface " + e.getMessage(), e);
            }
        }
    }

    public String config(String name) {
        if (this.dbConfig.get(name) != null) {
            return this.dbConfig.get(name);
        }
        return "";
    }

    public void close(String password) throws ArchiveInternalError {
        if (!password.equals(this.m_password)) {
            throw new ArchiveInternalError("Uncorrect password provided to call this method.");
        }
        if (this.internal != null) {
            try {
                this.internal.close();
                this.logger.log(Level.INFO, "Disconnected from the internal interface");
            }
            catch (ModuleCriticalException e) {
                try {
                    InternalCommunicationHelper.notifyMaster(e, this.m_containerServices, this.myName, this.logger);
                }
                catch (ArchiveCommunicationException e1) {
                    this.logger.warning("Cannot connect to Archive subsystem master");
                }
                this.logger.log(Level.INFO, "Unable to disconnect from the internal interface");
                throw new ArchiveInternalError(e.getMessage());
            }
            catch (ArchiveException e) {
                this.logger.log(Level.INFO, "Unable to disconnect from the internal interface");
                throw new ArchiveInternalError(e.getMessage());
            }
        }
    }

    public void remove(String uid, boolean deep) throws NotFound, MalformedURI, ArchiveInternalError {
        if (this.internal == null) {
            throw new ArchiveInternalError("ARCHIVE: The Archive has not been initialised call .init()");
        }
        try {
            URI uri = new URI(uid);
            this.internal.remove(uri, false, this.user);
        }
        catch (URISyntaxException e) {
            throw new MalformedURI(e.getMessage());
        }
        catch (ModuleCriticalException e) {
            try {
                InternalCommunicationHelper.notifyMaster(e, this.m_containerServices, this.myName, this.logger);
            }
            catch (ArchiveCommunicationException e1) {
                this.logger.warning("Can nont connect to Archive subsystem master");
            }
            throw new ArchiveInternalError(e.getCause().getMessage());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.getMessage());
        }
    }

    public void cleanTestArea() throws ArchiveInternalError {
        if (this.internal == null) {
            throw new ArchiveInternalError("ARCHIVE: The Archive has not been initialised call .init()");
        }
        try {
            this.internal.cleanTestArea(this.user);
        }
        catch (ModuleCriticalException e) {
            try {
                InternalCommunicationHelper.notifyMaster(e, this.m_containerServices, this.myName, this.logger);
            }
            catch (ArchiveCommunicationException e1) {
                this.logger.warning("Can nont connect to Archive subsystem master");
            }
            throw new ArchiveInternalError(e.getCause().getMessage());
        }
        catch (ArchiveException e) {
            throw new ArchiveInternalError(e.getMessage());
        }
    }

    protected void send_alarm(boolean active) {
        String faultFamily = "Backend";
        int faultCode = 1;
        String faultMember = this.config("archive.db.backend").equals("oracle") ? "Oracle" : "eXist";
        String faultState = active ? "ACTIVE" : "TERMINATE";
        try {
            this.send_alarm(faultFamily, faultMember, faultCode, faultState);
            this.alarmActive = active;
        }
        catch (ACSASFactoryNotInitedEx e) {
            this.logger.warning("Could not activate/deactivate alarm: " + e.toString());
        }
        catch (SourceCreationErrorEx e) {
            this.logger.warning("Could not activate/deactivate alarm: " + e.toString());
        }
        catch (FaultStateCreationErrorEx e) {
            this.logger.warning("Could not activate/deactivate alarm: " + e.toString());
        }
    }

    protected void send_alarm(String faultFamily, String faultMember, int faultCode, String faultState) throws ACSASFactoryNotInitedEx, SourceCreationErrorEx, FaultStateCreationErrorEx {
        ACSAlarmSystemInterface alarmSource = ACSAlarmSystemInterfaceFactory.createSource((String)this.myName);
        ACSFaultState fs = ACSAlarmSystemInterfaceFactory.createFaultState((String)faultFamily, (String)faultMember, (int)faultCode);
        fs.setDescriptor(faultState);
        fs.setUserTimestamp(new Timestamp(System.currentTimeMillis()));
        Properties props = new Properties();
        props.setProperty("ASI_PREFIX", "prefix");
        props.setProperty("ASI_SUFFIX", "suffix");
        fs.setUserProperties(props);
        alarmSource.push(fs);
    }
}

