/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jsky.science.AbstractScienceObject;
import jsky.util.FormatUtilities;

public abstract class Quantity
extends AbstractScienceObject {
    protected double fValue;
    private static Map sListeners = new HashMap();
    private static Map sUnits = new HashMap();
    private static Map sAbbrev = new HashMap();
    private static Map sDefaults = new HashMap();
    private static Map sUnitsProperties = new HashMap();
    private static final long serialVersionUID = 1L;

    public abstract double getValue(String var1);

    public abstract Quantity newInstance(double var1);

    protected abstract void setValue(double var1, String var3);

    public static void initializeSubClass(Class cl, List unitNames, List abbrevStrings, String defaultUnits, String defaultUnitsChangeProperty) {
        if (sUnits.get(cl) != null) {
            sUnits.remove(cl);
            sAbbrev.remove(cl);
            sDefaults.remove(cl);
            sListeners.remove(cl);
            sUnitsProperties.remove(cl);
        }
        sUnits.put(cl, unitNames);
        sAbbrev.put(cl, abbrevStrings);
        sDefaults.put(cl, defaultUnits);
        sListeners.put(cl, new HashSet(10));
        sUnitsProperties.put(cl, defaultUnitsChangeProperty);
    }

    public static boolean isInitialized(Class thisClass) {
        return sUnits.get(thisClass) != null;
    }

    public static String getDefaultUnitsAbbrev(Class cl) {
        String def = Quantity.getDefaultUnits(cl);
        return Quantity.getUnitsAbbrev(cl, def);
    }

    public static String getUnitsAbbrev(Class cl, String def) {
        if (def == null) {
            return null;
        }
        List units = (List)sUnits.get(cl);
        int index = units.indexOf(def);
        if (index >= 0) {
            List abbrev = (List)sAbbrev.get(cl);
            return (String)abbrev.get(index);
        }
        return null;
    }

    public static String getDefaultUnits(Class cl) {
        return (String)sDefaults.get(cl);
    }

    public static String getDefaultUnitsProperty(Class cl) {
        return (String)sUnitsProperties.get(cl);
    }

    public static void setDefaultUnits(Class cl, String inUnits) {
        String oldDefault = (String)sDefaults.get(cl);
        if (oldDefault == null || !oldDefault.equals(inUnits)) {
            sDefaults.remove(cl);
            sDefaults.put(cl, inUnits);
            PropertyChangeEvent evt = new PropertyChangeEvent(cl.toString(), (String)sUnitsProperties.get(cl), oldDefault, inUnits);
            Quantity.fireDefaultUnitsChange(cl, evt);
        }
    }

    public double getValue() {
        return this.getValue(this.getDefaultUnits());
    }

    public String getDefaultUnits() {
        return (String)sDefaults.get(this.getClass());
    }

    @Override
    public String toString() {
        return this.toString(2);
    }

    public String toString(int decs) {
        return FormatUtilities.formatDouble(this.getValue(), decs) + " " + Quantity.getDefaultUnitsAbbrev(this.getClass());
    }

    @Override
    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof Quantity)) {
            return false;
        }
        return this.fValue == ((Quantity)that).fValue;
    }

    public int hashCode() {
        return (int)this.fValue;
    }

    public static List getAllUnits(Class cl) {
        return (List)sUnits.get(cl);
    }

    public List getAllUnits() {
        return (List)sUnits.get(this.getClass());
    }

    public static List getAllUnitsAbbrev(Class cl) {
        return (List)sAbbrev.get(cl);
    }

    public List getAllUnitsAbbrev() {
        return (List)sAbbrev.get(this.getClass());
    }

    public static String getUnitsIgnoreCase(Class cl, String inUnits) {
        for (String u : (List)sUnits.get(cl)) {
            if (!inUnits.equalsIgnoreCase(u)) continue;
            return u;
        }
        return null;
    }

    public static void addDefaultUnitsChangeListener(Class cl, PropertyChangeListener listener) {
        Collection myListeners = (Collection)sListeners.get(cl);
        if (!myListeners.contains(listener)) {
            myListeners.add(listener);
        }
    }

    public Quantity add(Quantity q) throws ClassCastException {
        if (!this.getClass().equals(q.getClass())) {
            throw new ClassCastException("Cannot add " + q.getClass() + " to " + this.getClass());
        }
        Quantity q2 = (Quantity)this.clone();
        String defUnits = Quantity.getDefaultUnits(q2.getClass());
        q2.setValue(this.getValue(defUnits) + q.getValue(defUnits), defUnits);
        return q2;
    }

    public static void removeDefaultUnitsChangeListener(Class cl, PropertyChangeListener listener) {
        Collection myListeners = (Collection)sListeners.get(cl);
        if (myListeners.contains(listener)) {
            myListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireDefaultUnitsChange(Class cl, PropertyChangeEvent evt) {
        Collection listeners;
        Map map = sListeners;
        synchronized (map) {
            listeners = (Collection)sListeners.get(cl);
        }
        for (PropertyChangeListener listener : listeners) {
            listener.propertyChange(evt);
        }
    }

    protected void fireDefaultUnitsChange(PropertyChangeEvent evt) {
        Quantity.fireDefaultUnitsChange(this.getClass(), evt);
    }
}

