/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.idlgen;

import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jacorb.idl.AcsAdapterForOldJacorb;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Definition;
import org.jacorb.idl.EnumType;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.InterfaceBody;
import org.jacorb.idl.Member;
import org.jacorb.idl.MemberList;
import org.jacorb.idl.Module;
import org.jacorb.idl.OpDecl;
import org.jacorb.idl.ParamDecl;
import org.jacorb.idl.Spec;
import org.jacorb.idl.StructType;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VectorType;
import org.jacorb.idl.javamapping.JavaMappingGeneratingVisitor;
import org.jacorb.idl.parser;

public class JacorbVisitor
extends JavaMappingGeneratingVisitor {
    public static final String XML_ENTITY_STRUCT_NAME = "XmlEntityStruct";
    public static final String ACSCOMPONENT_IDLTYPE = "IDL:alma/ACS/ACSComponent:1.0";
    public static final String ACSOFFSHOOT_IDLTYPE = "IDL:alma/ACS/OffShoot:1.0";
    final Set<AliasTypeSpec> xmlTypedefs = new LinkedHashSet<AliasTypeSpec>();
    final Set<StructType> xmlAwareStructs = new LinkedHashSet<StructType>();
    final Set<Interface> xmlAwareIFs = new LinkedHashSet<Interface>();
    final Set<Interface> acsCompIFs = new LinkedHashSet<Interface>();
    private final Set<Interface> interfaceStack = new LinkedHashSet<Interface>();

    public void visitSpec(Spec spec) {
        super.visitSpec(spec);
    }

    public void visitModule(Module module) {
        if (module.is_included() && !this.generateIncluded()) {
            return;
        }
        super.visitModule(module);
    }

    public void visitAlias(AliasTypeSpec aliasTypeSpec) {
        if (this.isOrHasXmlEntityStruct((TypeSpec)aliasTypeSpec, 0)) {
            this.xmlTypedefs.add(aliasTypeSpec);
        }
    }

    public void visitStruct(StructType structType) {
        if (this.hasXmlEntityStruct(structType, 0)) {
            this.xmlAwareStructs.add(structType);
        }
    }

    public void visitInterface(Interface interface_) {
        String[] stringArray = interface_.get_ids();
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].equals(ACSCOMPONENT_IDLTYPE)) {
                bl = true;
                this.acsCompIFs.add(interface_);
                break;
            }
            if (!stringArray[i].equals(ACSOFFSHOOT_IDLTYPE)) continue;
            bl = true;
            break;
        }
        if (bl && !this.interfaceStack.contains(interface_)) {
            this.interfaceStack.add(interface_);
            super.visitInterface(interface_);
            this.interfaceStack.remove(interface_);
        }
    }

    public void visitInterfaceBody(InterfaceBody interfaceBody) {
        super.visitInterfaceBody(interfaceBody);
        for (Definition definition : interfaceBody.v) {
            Declaration declaration = definition.get_declaration();
            if (declaration instanceof OpDecl) continue;
            definition.accept((IDLTreeVisitor)this);
        }
    }

    public void visitOpDecl(OpDecl opDecl) {
        Interface interface_ = (Interface)opDecl.myInterface;
        if (this.xmlAwareIFs.contains(interface_)) {
            return;
        }
        TypeSpec typeSpec = opDecl.opTypeSpec;
        boolean bl = this.isOrHasXmlEntityStruct(typeSpec, 0);
        if (bl) {
            this.xmlAwareIFs.add(interface_);
            bl = true;
        } else {
            Enumeration enumeration = opDecl.paramDecls.elements();
            while (enumeration.hasMoreElements()) {
                ParamDecl paramDecl = (ParamDecl)enumeration.nextElement();
                paramDecl.setEnclosingSymbol((IdlSymbol)opDecl);
                paramDecl.accept((IDLTreeVisitor)this);
            }
        }
    }

    public void visitParamDecl(ParamDecl paramDecl) {
        OpDecl opDecl = (OpDecl)paramDecl.getEnclosingSymbol();
        Interface interface_ = (Interface)opDecl.myInterface;
        TypeSpec typeSpec = paramDecl.paramTypeSpec;
        if (this.isOrHasXmlEntityStruct(typeSpec, 0)) {
            this.xmlAwareIFs.add(interface_);
        }
    }

    private boolean isOrHasXmlEntityStruct(TypeSpec typeSpec, int n) {
        boolean bl = false;
        if (typeSpec instanceof AliasTypeSpec) {
            AliasTypeSpec aliasTypeSpec = (AliasTypeSpec)typeSpec;
            TypeSpec typeSpec2 = aliasTypeSpec.originalType();
            bl = this.isOrHasXmlEntityStruct(typeSpec2, n + 1);
        } else if (typeSpec instanceof VectorType) {
            VectorType vectorType = (VectorType)typeSpec;
            bl = this.isOrHasXmlEntityStruct(vectorType.elementTypeSpec(), n + 1);
        } else if (typeSpec instanceof ConstrTypeSpec) {
            TypeDeclaration typeDeclaration = ((ConstrTypeSpec)typeSpec.typeSpec()).c_type_spec.declaration();
            if (typeDeclaration instanceof StructType) {
                StructType structType = (StructType)typeDeclaration;
                bl = structType.name().equals(XML_ENTITY_STRUCT_NAME) ? true : this.hasXmlEntityStruct(structType, n);
            } else if (typeDeclaration instanceof Interface) {
                Interface interface_ = (Interface)typeDeclaration;
                if (interface_.body == null) {
                    interface_ = JacorbVisitor.resolveForwardDecl(interface_);
                    this.visitInterface(interface_);
                }
                if (this.xmlAwareIFs.contains(interface_)) {
                    bl = true;
                }
            } else if (!(typeDeclaration instanceof EnumType)) {
                System.out.println("*** isOrHasXmlEntityStruct: Unexpected ConstrTypeSpec with TypeDeclaration subtype " + typeDeclaration.getClass().getSimpleName());
            }
        }
        return bl;
    }

    private boolean hasXmlEntityStruct(StructType structType, int n) {
        MemberList memberList = structType.memberlist;
        if (memberList != null) {
            Enumeration enumeration = memberList.elements();
            while (enumeration.hasMoreElements()) {
                TypeSpec typeSpec = ((Member)enumeration.nextElement()).type_spec;
                if (!this.isOrHasXmlEntityStruct(typeSpec, n + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public static Interface resolveForwardDecl(Interface interface_) {
        Interface interface_2 = interface_;
        if (interface_.body == null) {
            String string = interface_.pack_name + "." + interface_.name();
            interface_2 = (Interface)((ConstrTypeSpec)AcsAdapterForOldJacorb.getFromTypeMap((String)string)).c_type_spec;
        }
        return interface_2;
    }

    private boolean generateIncluded() {
        return parser.generateIncluded() && !parser.getInhibitionState();
    }

    public void visitDeclaration(Declaration declaration) {
    }

    public void visitEnum(EnumType enumType) {
    }
}

