/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.CubeWriter;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.WordParser;
import uk.ac.starlink.ttools.task.WordsParameter;
import uk.ac.starlink.util.Destination;

public class CubeMode
implements ProcessingMode {
    private final WordsParameter boundsParam_ = new WordsParameter("bounds");
    private final WordsParameter binsizeParam_;
    private final WordsParameter nbinParam_;
    private final OutputStreamParameter outParam_;
    private final ChoiceParameter typeParam_;
    private final Parameter scaleParam_;
    private WordsParameter colsParam_;
    private static final Class[] OUT_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};

    public CubeMode() {
        this.boundsParam_.setNullPermitted(true);
        this.boundsParam_.setDefault(null);
        this.boundsParam_.setWordParser(new BoundsParser());
        this.boundsParam_.setWordUsage("[<lo>]:[<hi>]");
        this.boundsParam_.setPrompt("Data bounds for each dimension");
        this.boundsParam_.setDescription(new String[]{"<p>Gives the bounds for each dimension of the cube in data", "coordinates.  The form of the value is a space-separated list", "of words, each giving an optional lower bound, then a colon,", "then an optional upper bound, for instance", "\"1:100 0:20\" to represent a range for two-dimensional output", "between 1 and 100 of the first coordinate (table column)", "and between 0 and 20 for the second.", "Either or both numbers may be omitted to indicate that the", "bounds should be determined automatically by assessing the", "range of the data in the table.", "A null value for the parameter indicates that all bounds should", "be determined automatically for all the dimensions.", "</p>", "<p>If any of the bounds need to be determined automatically", "in this way, two passes through the data will be required,", "the first to determine bounds and the second", "to populate the cube.", "</p>"});
        this.binsizeParam_ = new WordsParameter("binsizes");
        this.binsizeParam_.setWordParser(new DoubleParser());
        this.binsizeParam_.setWordUsage("<size>");
        this.binsizeParam_.setPrompt("Extent of bins in each dimension");
        this.binsizeParam_.setDescription(new String[]{"<p>Gives the extent of of the data bins (cube pixels) in each", "dimension in data coordinates.", "The form of the value is a space-separated list of values,", "giving a list of extents for the first, second, ... dimension.", "Either this parameter or the <code>nbins</code> parameter", "must be supplied.", "</p>"});
        this.nbinParam_ = new WordsParameter("nbins");
        this.nbinParam_.setWordParser(new IntegerParser());
        this.nbinParam_.setWordUsage("<num>");
        this.nbinParam_.setNullPermitted(true);
        this.nbinParam_.setPrompt("Number of bins in each dimension");
        this.nbinParam_.setDescription(new String[]{"<p>Gives the number of bins (cube pixels) in each dimension.", "The form of the value is a space-separated list of integers,", "giving the number of pixels for the output cube in the", "first, second, ... dimension.", "Either this parameter or the <code>binsizes</code> parameter", "must be supplied.", "</p>"});
        this.outParam_ = new OutputStreamParameter("out");
        this.outParam_.setPreferExplicit(true);
        this.outParam_.setPrompt("Location of output FITS file");
        this.outParam_.setDescription(new String[]{this.outParam_.getDescription(), "<p>The output cube is currently written as", "a single-HDU FITS file.", "</p>"});
        this.typeParam_ = new ChoiceParameter("otype", (Object[])OUT_TYPES);
        this.typeParam_.setNullPermitted(true);
        this.typeParam_.setDefault(null);
        this.typeParam_.setPrompt("Type of output array elements");
        this.typeParam_.setDescription(new String[]{"<p>The type of numeric value which will fill the output array.", "If no selection is made, the output type will be", "determined automatically as the shortest type required to hold", "all the values in the array.", "Currently, integers are always signed (no BSCALE/BZERO),", "so for instance the largest value that can be recorded", "in 8 bits is 127.", "</p>"});
        this.scaleParam_ = new Parameter("scale");
        this.scaleParam_.setUsage("<col-id>");
        this.scaleParam_.setNullPermitted(true);
        this.scaleParam_.setDefault(null);
        this.scaleParam_.setPrompt("Value by which to scale counts");
        this.scaleParam_.setDescription(new String[]{"<p>Optionally gives a value by which the count in each bin is", "scaled.", "If this value is <code>null</code> (the default) then for each", "row that falls within the bounds of a pixel, the pixel value", "will be incremented by 1.", "If a column ID is given, then instead of 1 being added,", "the value of that column for the row in question is added.", "The effect of this is that the output image contains the mean", "of the given column for the rows corresponding to each pixel", "rather than just a count of them.", "</p>"});
    }

    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Makes an N-dimensional histogram of the columns in the", "input table.", "The result is an N-dimensional array which is output as a", "FITS file.", "</p>"});
    }

    public Parameter[] getAssociatedParameters() {
        return new Parameter[]{this.boundsParam_, this.binsizeParam_, this.nbinParam_, this.outParam_, this.typeParam_, this.scaleParam_};
    }

    public TableConsumer createConsumer(Environment env) throws TaskException {
        double[] binsizes;
        int[] nbins;
        String[] colIds = this.colsParam_.wordsValue(env);
        int ndim = colIds.length;
        this.boundsParam_.setRequiredWordCount(ndim);
        this.binsizeParam_.setRequiredWordCount(ndim);
        this.nbinParam_.setRequiredWordCount(ndim);
        String scaleId = this.scaleParam_.stringValue(env);
        Object[] boundsWords = this.boundsParam_.parsedWordsValue(env);
        double[] loBounds = new double[ndim];
        double[] hiBounds = new double[ndim];
        if (boundsWords != null) {
            for (int i = 0; i < ndim; ++i) {
                double[] bounds = (double[])boundsWords[i];
                loBounds[i] = bounds[0];
                hiBounds[i] = bounds[1];
            }
        } else {
            Arrays.fill(loBounds, Double.NaN);
            Arrays.fill(hiBounds, Double.NaN);
        }
        Object[] nbinWords = this.nbinParam_.parsedWordsValue(env);
        if (nbinWords != null) {
            this.binsizeParam_.setNullPermitted(true);
            this.binsizeParam_.setValueFromString(env, null);
            nbins = new int[ndim];
            for (int i = 0; i < ndim; ++i) {
                nbins[i] = (Integer)nbinWords[i];
                if (nbins[i] > 0) continue;
                throw new ParameterValueException((Parameter)this.nbinParam_, "Non-positive value");
            }
            binsizes = null;
        } else {
            this.binsizeParam_.setNullPermitted(false);
            Object[] binsizeWords = this.binsizeParam_.parsedWordsValue(env);
            binsizes = new double[ndim];
            for (int i = 0; i < ndim; ++i) {
                binsizes[i] = (Double)binsizeWords[i];
                if (binsizes[i] > 0.0) continue;
                throw new ParameterValueException((Parameter)this.binsizeParam_, "Non-positive value");
            }
            nbins = null;
        }
        Destination dest = this.outParam_.destinationValue(env);
        Class outType = (Class)this.typeParam_.objectValue(env);
        return new CubeWriter(loBounds, hiBounds, nbins, binsizes, colIds, scaleId, dest, outType);
    }

    public void setColumnsParameter(WordsParameter colsParam) {
        this.colsParam_ = colsParam;
    }

    private static class IntegerParser
    implements WordParser {
        private IntegerParser() {
        }

        public Object parseWord(String word) throws TaskException {
            try {
                return new Integer(Integer.parseInt(word));
            }
            catch (NumberFormatException e) {
                throw new UsageException("Bad integer format", (Throwable)e);
            }
        }
    }

    private static class DoubleParser
    implements WordParser {
        private DoubleParser() {
        }

        public Object parseWord(String word) throws TaskException {
            try {
                return new Double(Double.parseDouble(word));
            }
            catch (NumberFormatException e) {
                throw new UsageException("Bad number format", (Throwable)e);
            }
        }
    }

    private static class BoundsParser
    implements WordParser {
        final Pattern boundsRegex_ = Pattern.compile("(.*):(.*)");

        private BoundsParser() {
        }

        public Object parseWord(String word) throws TaskException {
            Matcher matcher = this.boundsRegex_.matcher(word);
            if (matcher.matches()) {
                double[] bounds = new double[]{Double.NaN, Double.NaN};
                for (int i = 0; i < 2; ++i) {
                    String sval = matcher.group(i + 1).trim();
                    if (sval.length() <= 0) continue;
                    try {
                        bounds[i] = Double.parseDouble(sval);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new UsageException("Bad bound string \"" + sval + "\"", (Throwable)e);
                    }
                }
                if (bounds[0] >= bounds[1]) {
                    throw new UsageException("Bad bound string \"" + word + "\": lo>=hi");
                }
                return bounds;
            }
            throw new UsageException("Bad <lo>:<hi> bounds string");
        }
    }
}

