/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Locator;
import uk.ac.starlink.ttools.lint.CheckerFactory;
import uk.ac.starlink.ttools.lint.ElementHandler;
import uk.ac.starlink.ttools.lint.ElementRef;
import uk.ac.starlink.ttools.lint.HandlerFactory;
import uk.ac.starlink.ttools.lint.LintException;
import uk.ac.starlink.ttools.lint.RefChecker;

public class LintContext {
    private Locator locator_;
    private PrintStream out_ = System.err;
    private int errCount_;
    private String version_;
    private boolean validate_;
    private boolean debug_;
    private final Map idMap_ = new HashMap();
    private final Map refMap_ = new HashMap();
    private final Map msgMap_ = new HashMap();
    private final Map namespaceMap_ = new HashMap();
    private final CheckerFactory checkerFactory_ = new CheckerFactory(this);
    private final HandlerFactory handlerFactory_ = new HandlerFactory(this);
    public static final String V10 = "1.0";
    public static final String V11 = "1.1";
    public static final String[] VOT_VERSIONS = new String[]{"1.0", "1.1"};
    public static final int MAX_REPEAT = 4;

    public LintContext() {
        this(null);
    }

    public LintContext(String version) {
        this.setVersion(version);
    }

    public String getVersion() {
        return this.version_;
    }

    public void setVersion(String version) {
        if (version == null || version.equals(V10) || version.equals(V11)) {
            this.version_ = version;
        } else {
            this.warning("Unknown VOTable version " + version);
        }
    }

    public void setValidating(boolean validate) {
        this.validate_ = validate;
    }

    public boolean isValidating() {
        return this.validate_;
    }

    public void setLocator(Locator locator) {
        this.locator_ = locator;
    }

    public Locator getLocator() {
        return this.locator_;
    }

    public void setDebug(boolean debug) {
        this.debug_ = debug;
    }

    public boolean isDebug() {
        return this.debug_;
    }

    public PrintStream getOutput() {
        return this.out_;
    }

    public void setOutput(PrintStream out) {
        this.out_ = out;
    }

    public ElementHandler createHandler(String localName) {
        return this.handlerFactory_.createHandler(localName);
    }

    public Map getAttributeCheckers(String localName) {
        return this.checkerFactory_.getAttributeCheckers(localName);
    }

    public Map getNamespaceMap() {
        return this.namespaceMap_;
    }

    public void registerID(String id, ElementHandler handler) {
        if (this.idMap_.containsKey(id)) {
            ElementRef ref = (ElementRef)this.idMap_.get(id);
            this.error("ID " + id + " already defined " + ref);
        } else {
            this.idMap_.put(id, handler.getRef());
        }
        if (this.refMap_.containsKey(id)) {
            UncheckedReference unref = (UncheckedReference)this.refMap_.remove(id);
            ElementRef to = (ElementRef)this.idMap_.get(id);
            unref.checkLink(to);
        }
    }

    public void registerRef(String id, ElementRef from, RefChecker checker) {
        UncheckedReference unref = new UncheckedReference(id, from, checker);
        if (this.idMap_.containsKey(id)) {
            ElementRef to = (ElementRef)this.idMap_.get(id);
            unref.checkLink(to);
        } else {
            this.refMap_.put(id, unref);
        }
    }

    public void reportUncheckedRefs() {
        Iterator it = this.refMap_.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            UncheckedReference unref = (UncheckedReference)this.refMap_.get(id);
            it.remove();
            ElementRef from = unref.from_;
            this.error("ID " + id + " referenced from " + from + " never found");
        }
    }

    public void info(String msg) {
        this.message("INFO", msg, null);
    }

    public void warning(String msg) {
        this.message("WARNING", msg, null);
    }

    public void error(String msg) {
        ++this.errCount_;
        this.message("ERROR", msg, null);
    }

    public void message(String type, String msg, Throwable e) {
        if (msg == null && e != null && (msg = e.getMessage()) == null) {
            msg = e.toString();
        }
        int repeat = this.msgMap_.containsKey(msg) ? (Integer)this.msgMap_.get(msg) : 0;
        this.msgMap_.put(msg, new Integer(repeat + 1));
        if (repeat < 4) {
            StringBuffer sbuf = new StringBuffer().append(type);
            int il = -1;
            int ic = -1;
            if (this.locator_ != null) {
                ic = this.locator_.getColumnNumber();
                il = this.locator_.getLineNumber();
            }
            if (il > 0) {
                sbuf.append(" (l.").append(il);
                if (ic > 0) {
                    sbuf.append(", c.").append(ic);
                }
                sbuf.append(")");
            }
            sbuf.append(": ").append(msg);
            if (repeat == 3) {
                sbuf.append(" (more...)");
            }
            String text = sbuf.toString();
            this.out_.println(text);
            if (this.debug_) {
                if (e == null) {
                    e = new LintException(msg);
                    e.fillInStackTrace();
                }
                e.printStackTrace(this.out_);
                this.out_.println();
            }
        }
    }

    private class UncheckedReference {
        final String id_;
        final ElementRef from_;
        final RefChecker refChecker_;

        UncheckedReference(String id, ElementRef from, RefChecker refChecker) {
            this.id_ = id;
            this.from_ = from;
            this.refChecker_ = refChecker;
        }

        void checkLink(ElementRef to) {
            this.refChecker_.checkLink(LintContext.this, this.id_, this.from_, to);
        }
    }
}

