/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.debug;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.util.MiscUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class RegistryViewer {
    protected RegistryReader registryReader;
    protected JComponent panel;
    protected JTable table;
    protected MapTableModel tm;
    protected JTextArea textarea;
    protected JTextField txtFind;

    public static void main(String[] stringArray) {
        RegistryReader registryReader = new RegistryReader(){
            List<Row> data = new ArrayList<Row>();
            int counter = 0;

            @Override
            public String frameTitle() {
                return "Castor2WrapperRegistry";
            }

            @Override
            public String[] columnNames() {
                return new String[]{"Storage Object", "Business Object"};
            }

            @Override
            public List<Row> read() {
                if (this.data.size() > 0) {
                    this.data.remove(0);
                }
                for (int i = 1; i <= 5; ++i) {
                    ++this.counter;
                    Row row = new Row("key#" + this.counter, "val#" + this.counter);
                    this.data.add(row);
                }
                return this.data;
            }
        };
        RegistryViewer registryViewer = new RegistryViewer(registryReader);
        boolean bl = false;
        if (bl) {
            registryViewer.update();
            registryViewer.update();
        }
        registryViewer.showFrame();
    }

    public static RegistryViewer createIdObjectRegistryViewer() {
        RegistryReader registryReader = new RegistryReader(){

            @Override
            public String frameTitle() {
                return "IdObjectRegistry";
            }

            @Override
            public String[] columnNames() {
                return new String[]{"Entity Id", "Business Object"};
            }

            @Override
            public List<Row> read() {
                return new ArrayList<Row>();
            }
        };
        RegistryViewer registryViewer = new RegistryViewer(registryReader);
        return registryViewer;
    }

    public RegistryViewer(RegistryReader registryReader) {
        this.registryReader = registryReader;
        this.tm = new MapTableModel(registryReader.columnNames());
        this.panel = this.makeTable();
        this.update();
        this.table.setAutoResizeMode(1);
        this.table.setDefaultRenderer(Object.class, new ObjectClassRenderer(this, this.tm));
    }

    protected JComponent makeTable() {
        this.table = new JTable(this.tm);
        this.table.setRowSorter(new TableRowSorter<MapTableModel>(this.tm));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel jPanel2 = new JPanel();
        this.textarea = new JTextArea(2, 25);
        this.textarea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textarea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel2.add(jScrollPane);
        JButton jButton = new JButton("Update");
        jButton.setToolTipText("Check for updates");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegistryViewer.this.update();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalStrut(30));
        this.txtFind = new JTextField(15);
        jPanel2.add(this.txtFind);
        JButton jButton2 = new JButton("Find");
        jButton2.setToolTipText("Highlight entries containing string");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = RegistryViewer.this.txtFind.getText();
                if (string.equals("")) {
                    for (int i = 0; i < RegistryViewer.this.tm.data.size(); ++i) {
                        RegistryViewer.this.tm.data.get((int)i).highlight = false;
                    }
                    RegistryViewer.this.tm.fireTableDataChanged();
                    return;
                }
                int n = 0;
                block1: for (int i = 0; i < RegistryViewer.this.tm.data.size(); ++i) {
                    for (int j = 0; j < 2; ++j) {
                        boolean bl;
                        String string2 = String.valueOf(RegistryViewer.this.tm.getValueAt(i, j));
                        RegistryViewer.this.tm.data.get((int)i).highlight = bl = string2.contains(string);
                        if (!bl) continue;
                        ++n;
                        continue block1;
                    }
                }
                RegistryViewer.this.tm.fireTableDataChanged();
                RegistryViewer.this.textarea.append("\n      " + n + " entries match \"" + string + "\"");
                RegistryViewer.this.textarea.setCaretPosition(RegistryViewer.this.textarea.getDocument().getLength());
            }
        });
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    public void showFrame() {
        JFrame jFrame = new JFrame(this.registryReader.frameTitle());
        jFrame.getContentPane().add(this.panel);
        jFrame.setDefaultCloseOperation(2);
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
        jFrame.validate();
    }

    public void update() {
        List<Row> list = this.registryReader.read();
        this.tm.addData(list);
        ++this.tm.nRefresh;
        this.tm.fireTableStructureChanged();
        ColumnResizer.adjustColumnPreferredWidths(this.table);
        this.textarea.append("\n Update " + (this.tm.nRefresh - 1) + ": registry has " + list.size() + " entries");
        this.textarea.setCaretPosition(this.textarea.getDocument().getLength());
    }

    public static interface RegistryReader {
        public String frameTitle();

        public String[] columnNames();

        public List<Row> read();
    }

    protected class MapTableModel
    extends AbstractTableModel {
        protected String[] columnNames;
        protected List<Row> data = new ArrayList<Row>();
        protected int nRefresh = 0;

        public MapTableModel(String[] stringArray) {
            this.columnNames = stringArray;
        }

        public void addData(List<Row> list) {
            for (Row row : list) {
                this.addIncrementalData(row);
            }
        }

        protected void addIncrementalData(Row row) {
            Row row2 = row;
            boolean bl = false;
            for (Row row3 : this.data) {
                if (row3.key != row.key || row3.value != row.value) continue;
                row2 = row3;
                bl = true;
                break;
            }
            BitSet bitSet = new BitSet();
            bitSet.set(this.nRefresh);
            row2.tags.or(bitSet);
            if (!bl) {
                this.data.add(row);
                super.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length + this.nRefresh;
        }

        @Override
        public String getColumnName(int n) {
            if (n < this.columnNames.length) {
                return this.columnNames[n];
            }
            return String.valueOf(n - 2);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Row row = this.data.get(n);
            switch (n2) {
                case 0: {
                    return this.getValueAt(row.key);
                }
                case 1: {
                    return this.getValueAt(row.value);
                }
            }
            int n3 = n2 - 2;
            return row.tags.get(n3);
        }

        private String getValueAt(Object object) {
            if (object == null) {
                return "null";
            }
            if (object instanceof BusinessObject) {
                return MiscUtils.packageClassnameHash(object) + ": " + String.valueOf(object);
            }
            return String.valueOf(object);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Boolean.class;
        }
    }

    protected class ObjectClassRenderer
    implements TableCellRenderer {
        MapTableModel tm;
        JLabel comp = new JLabel();

        ObjectClassRenderer(RegistryViewer registryViewer, MapTableModel mapTableModel) {
            this.tm = mapTableModel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.comp.setOpaque(true);
            int n3 = jTable.convertRowIndexToModel(n);
            Color color = this.tm.data.get((int)n3).highlight ? Color.red : Color.black;
            this.comp.setForeground(color);
            Color color2 = bl ? Color.lightGray : null;
            this.comp.setBackground(color2);
            String string = String.valueOf(object);
            this.comp.setText(string);
            return this.comp;
        }
    }

    public static class Row {
        boolean highlight;
        Object key;
        Object value;
        BitSet tags = new BitSet();

        Row(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }
    }
}

