/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions;

import alma.Control.SkyFreqSideband;
import alma.obsprep.bo.enumerations.NetSideBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.services.losolutions.LOToolTuningParametersEditor;
import alma.obsprep.services.losolutions.wrappers.LO2ParametersWrapper;
import alma.obsprep.services.losolutions.wrappers.TuningParametersWrapper;
import alma.valuetypes.Frequency;
import javax.swing.table.AbstractTableModel;

public class LOToolTuningParametersModel
extends Model {
    private final LO2ParametersTableModel lO2TableModel = new LO2ParametersTableModel();

    public LOToolTuningParametersModel(Object object) {
        super(object);
    }

    public TuningParametersWrapper getTuningParameters() {
        return (TuningParametersWrapper)this.document;
    }

    public LO2ParametersTableModel getLO2TableModel() {
        return this.lO2TableModel;
    }

    @Override
    public void publish() {
        if (this.document != null) {
            TuningParametersWrapper tuningParametersWrapper = this.getTuningParameters();
            this.publish(LOToolTuningParametersEditor.RECEIVERBAND_FID, tuningParametersWrapper.getReceiverBand());
            this.publish(LOToolTuningParametersEditor.LSFREQUENCY_FID, (Object)tuningParametersWrapper.getLSFrequency());
            this.publish(LOToolTuningParametersEditor.FLOOGFREQUENCY_FID, (Object)tuningParametersWrapper.getFLOOGFrequency());
            this.publish(LOToolTuningParametersEditor.TUNEHIGH_FID, tuningParametersWrapper.getTuneHigh());
            this.publish(LOToolTuningParametersEditor.WEIGHTEDERROR_FID, tuningParametersWrapper.getWeightedError());
            this.publish(LOToolTuningParametersEditor.SCORE_FID, tuningParametersWrapper.getScore());
            this.publish(LOToolTuningParametersEditor.ACTUALLO1_FID, (Object)tuningParametersWrapper.getActualLO1());
        }
        this.lO2TableModel.fireTableDataChanged();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return object;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        if (object != null) {
            this.getTuningParameters();
        }
        this.publish();
    }

    class LO2ParametersTableModel
    extends AbstractTableModel {
        LO2ParametersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return LO2TableColumnDescriptor.values().length;
        }

        @Override
        public int getRowCount() {
            TuningParametersWrapper tuningParametersWrapper = LOToolTuningParametersModel.this.getTuningParameters();
            return tuningParametersWrapper == null ? 0 : tuningParametersWrapper.getBasebandCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TuningParametersWrapper tuningParametersWrapper = LOToolTuningParametersModel.this.getTuningParameters();
            if (tuningParametersWrapper == null) {
                return null;
            }
            LO2ParametersWrapper lO2ParametersWrapper = tuningParametersWrapper.getLO2(n);
            switch (LO2TableColumnDescriptor.getColumnDescriptor(n2).ordinal()) {
                case 0: {
                    return lO2ParametersWrapper.getDYTOFrequency();
                }
                case 1: {
                    return lO2ParametersWrapper.getFTSFrequency();
                }
                case 2: {
                    return lO2ParametersWrapper.getTuneHigh();
                }
                case 3: {
                    return lO2ParametersWrapper.getSkyFreqSideband();
                }
                case 4: {
                    return lO2ParametersWrapper.getIFFrequency();
                }
                case 5: {
                    return lO2ParametersWrapper.getLO2Frequency();
                }
                case 6: {
                    return lO2ParametersWrapper.getLSBSkyFrequency();
                }
                case 7: {
                    return lO2ParametersWrapper.getUSBSkyFrequency();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return LO2TableColumnDescriptor.getColumnDescriptor(n).getColumnClass();
        }

        @Override
        public String getColumnName(int n) {
            return LO2TableColumnDescriptor.getColumnDescriptor(n).getColumnName();
        }

        public Object[] getLongValues() {
            return new Object[]{Frequency.createFrequencyGHZ(9.9999), Frequency.createFrequencyMHZ(99.9999), true, SkyFreqSideband.LSB, Frequency.createFrequencyGHZ(99.9999), Frequency.createFrequencyGHZ(99.9999), Frequency.createFrequencyGHZ(999.9999), Frequency.createFrequencyGHZ(999.9999)};
        }
    }

    public static enum LO2TableColumnDescriptor {
        DYTO_FREQUENCY("DYTO", Frequency.class),
        FTS_FREQUENCY("FTS", Frequency.class),
        TUNEHIGH("Tune High", Boolean.class),
        SKYFREQ_SIDEBAND("Sideband", NetSideBand.class),
        IF_FREQUENCY("IF", Frequency.class),
        LO2_FREQUENCY("LO2", Frequency.class),
        LSB_FREQUENCY("ActualLSB", Frequency.class),
        USB_FREQUENCY("ActualUSB", Frequency.class);

        String label;
        Class<?> cl;

        static LO2TableColumnDescriptor getColumnDescriptor(int n) {
            return LO2TableColumnDescriptor.values()[n];
        }

        Class<?> getColumnClass() {
            return this.cl;
        }

        String getColumnName() {
            return this.label;
        }

        private LO2TableColumnDescriptor(String string2, Class<?> clazz) {
            this.label = string2;
            this.cl = clazz;
        }
    }
}

