/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.BaselineCalibrationObservingParametersFactory;
import alma.obsprep.services.generator.refactored.obsparams.CalibratorSurveyObservingParametersFactory;
import alma.obsprep.services.generator.refactored.obsparams.ObservingParametersFactory;
import alma.obsprep.services.generator.refactored.obsparams.RadiometricPointingObservingParametersFactory;
import alma.obsprep.services.generator.refactored.obsparams.ScienceGoalObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;

public class ObservingParametersAbstractFactory {
    public static ObservingParametersFactory getFactory(SpectralSetupParameters spectralSetupParameters, SpectralSpec spectralSpec, TargetWithIntent targetWithIntent, RequestedArray requestedArray, SBGenerationContext sBGenerationContext) {
        BusinessObject businessObject = spectralSetupParameters.getParent();
        if (businessObject instanceof ScienceGoal) {
            ScienceGoal scienceGoal = (ScienceGoal)businessObject;
            return new ScienceGoalObservingParametersFactory(scienceGoal, spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
        }
        if (businessObject instanceof ObservatoryGoal) {
            ObservatoryGoal observatoryGoal = (ObservatoryGoal)businessObject;
            return ObservingParametersAbstractFactory.getFactory(observatoryGoal, spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
        }
        throw new IllegalArgumentException("Cannot generate SBs for unhandled Observatory Goal");
    }

    private static ObservingParametersFactory getFactory(ObservatoryGoal observatoryGoal, SpectralSpec spectralSpec, TargetWithIntent targetWithIntent, RequestedArray requestedArray, SBGenerationContext sBGenerationContext) {
        String string = observatoryGoal.getPurpose();
        if ("Calibrator Survey".equals(string)) {
            return new CalibratorSurveyObservingParametersFactory(spectralSpec, targetWithIntent, requestedArray, observatoryGoal.getIntegrationTime(), sBGenerationContext);
        }
        if ("Baseline Calibration".equals(string)) {
            return new BaselineCalibrationObservingParametersFactory(spectralSpec, targetWithIntent, requestedArray, observatoryGoal.getIntegrationTime(), sBGenerationContext);
        }
        if ("Radiometric Pointing".equals(string)) {
            return new RadiometricPointingObservingParametersFactory(spectralSpec, targetWithIntent, requestedArray, observatoryGoal.getIntegrationTime(), sBGenerationContext);
        }
        throw new IllegalArgumentException("Cannot generate SBs for unhandled Observatory Goal");
    }
}

