/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.etc.SolarExecutionTimeCalculator;
import alma.obsprep.services.generator.refactored.InterferometericSolarSBConfigurator;
import alma.obsprep.services.generator.refactored.TPSolarSBConfigurator;
import lombok.NonNull;

public class SolarSBConfigurator {
    @NonNull
    private final SchedBlock sb;
    @NonNull
    private final SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult;

    public void configureSBForSolar() {
        if (this.sb.isInterferometric()) {
            new InterferometericSolarSBConfigurator(this.sb, this.solarExecutionTimeResult).configureSB();
        } else {
            new TPSolarSBConfigurator(this.sb, this.solarExecutionTimeResult).configureSB();
        }
    }

    public SolarSBConfigurator(@NonNull SchedBlock schedBlock, @NonNull SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (solarExecutionTimeResult == null) {
            throw new NullPointerException("solarExecutionTimeResult is marked non-null but is null");
        }
        this.sb = schedBlock;
        this.solarExecutionTimeResult = solarExecutionTimeResult;
    }
}

