/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import lombok.NonNull;

public class ACANecessityEstimator {
    private Angle largestScale;
    private double largestScaleArcsec;
    private double frequencyGHz;
    private String info;

    public ACANecessityEstimator(Angle angle, Angle angle2, Frequency frequency) {
        this.setParameters(angle, frequency);
    }

    public ACANecessityEstimator() {
    }

    public void setParameters(Angle angle, Frequency frequency) {
        this.setLargestScale(angle);
        this.setFrequency(frequency);
    }

    public void setFrequency(Frequency frequency) {
        this.frequencyGHz = frequency.getContentInGHz();
    }

    public void setLargestScale(Angle angle) {
        this.largestScale = angle;
        this.largestScaleArcsec = angle.getContentInUnits(Angle.UNIT_ARCSEC);
    }

    private boolean isRequestedLASRecoverable(Configuration configuration, TargetParameters[] targetParametersArray) throws InvalidConfigurationParametersException {
        double d = this.largestScale.getContentInUnits(Angle.UNIT_ARCSEC);
        return d < configuration.getRecoverableScale(this.frequencyGHz, targetParametersArray, RequestedArray.TWELVE_M);
    }

    private boolean isPointSource() {
        return this.largestScale.isZero();
    }

    public boolean isACAPermittedWithConfig(@NonNull Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return configuration.acaAllowed();
    }

    public boolean isACANecessary(@NonNull ScienceGoal scienceGoal) {
        boolean bl;
        boolean bl2;
        String string;
        StringBuilder stringBuilder;
        block17: {
            if (scienceGoal == null) {
                throw new NullPointerException("goal is marked non-null but is null");
            }
            stringBuilder = new StringBuilder();
            string = "input parameters not yet defined";
            bl2 = false;
            bl = true;
            try {
                if (scienceGoal.getScienceGoalMode().equals((Object)ScienceGoal.ScienceGoalMode.STANDALONEACA)) {
                    this.info = "<HTML>The science goal is configured for standalone ACA so the ACA is required.</HTML>";
                    return true;
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new RuntimeException("Unable to determine the science goal mode" + unknownEntityException.getMessage());
            }
            try {
                Configuration configuration;
                if (this.isPointSource()) {
                    bl2 = false;
                    string = "The ACA is not needed to observe point sources.";
                    break block17;
                }
                boolean bl3 = false;
                Configuration configuration2 = configuration = Configuration.getBestConfiguration(this.frequencyGHz, RequestedArray.TWELVE_M, scienceGoal);
                if (Configuration.getIsSecondConfigurationRequired(configuration, this.largestScaleArcsec, this.frequencyGHz, scienceGoal, RequestedArray.TWELVE_M, false)) {
                    try {
                        configuration2 = Configuration.getSecondCompactConfiguration(configuration);
                    }
                    catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                        // empty catch block
                    }
                }
                bl3 = this.isRequestedLASRecoverable(configuration2, scienceGoal.getTargetParameters());
                bl2 = false;
                if (!bl3) {
                    bl = this.isACAPermittedWithConfig(configuration2);
                    if (!bl) {
                        string = "It is not possible to schedule the ACA together with the largest scheduled 12-m configuration";
                        bl2 = false;
                    } else {
                        bl2 = true;
                        string = "The Max Recoverable Angular Scale of the smallest scheduled 12-m configuration is less than the Largest Angular Scale of the source";
                    }
                } else {
                    bl2 = false;
                    bl = true;
                    string = "The Max Recoverable Angular Scale of the smallest scheduled 12-m configuration is larger than the Largest Angular Scale of the source";
                }
            }
            catch (NullPointerException nullPointerException) {
                Log.logger((Object)this).warning("Set Resolution, Largest Angular Structure and Frequency first.");
                bl2 = false;
                string = "Input parameters are not yet defined.";
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                bl2 = false;
                string = "No suitable 12m configuration can be found.";
            }
        }
        if (!bl) {
            stringBuilder.append("<html><font size=+1>It is not possible to use the ACA because</font><br><br>");
        } else {
            stringBuilder.append("<html><font size=+1>ACA use is " + (bl2 ? "recommended" : "not recommended") + "</font><br><br>");
            stringBuilder.append("The ALMA Observing Tool suggests this observation <em>");
            stringBuilder.append(bl2 ? "needs" : "does not need");
            stringBuilder.append(" </em>the ACA because: <br><br>");
        }
        stringBuilder.append(string);
        stringBuilder.append("</html>");
        this.info = stringBuilder.toString();
        return bl2;
    }

    public String getInfo() {
        return this.info;
    }
}

