/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import javax.swing.table.AbstractTableModel;

public class ObservingGroupAllTargetsTableModel
extends AbstractTableModel {
    public static final int COLUMN_SOURCE_NAME = 0;
    public static final int COLUMN_RA = 1;
    public static final int COLUMN_DEC = 2;
    public static final int COLUMN_SPECTRAL_SPEC = 3;
    public static final int COLUMN_REST_FREQUENCY = 4;
    public static final int COLUMN_PURPOSE = 5;
    public static final int LAST_COLUMN = 5;
    private SchedBlock schedBlock;

    public ObservingGroupAllTargetsTableModel(SchedBlock schedBlock) {
        this.schedBlock = schedBlock;
    }

    private int getTargetCount() {
        return this.getSchedBlock() == null ? 0 : this.getSchedBlock().getTargetCount();
    }

    private Target getTargetAtRow(int n) {
        if (this.getSchedBlock() == null) {
            return null;
        }
        Target[] targetArray = this.getSchedBlock().getTarget();
        return targetArray[n];
    }

    private String getPurposeString(Target target) {
        String string;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (target.hasScienceParameters()) {
            stringBuilder.append("Science,");
        }
        if (target.hasPhaseCalParameters()) {
            stringBuilder.append("PhsCal,");
        }
        if (target.hasAmplitudeCalParameters()) {
            stringBuilder.append("AmpCal,");
        }
        if (target.hasPolarizationCalParameters()) {
            stringBuilder.append("PolCal,");
        }
        if (target.hasPointingCalParameters()) {
            stringBuilder.append("PntCal,");
        }
        if (target.hasAtmosphericCalParameters()) {
            stringBuilder.append("AtmCal,");
        }
        if (target.hasDelayCalParameters()) {
            stringBuilder.append("DlyCal,");
        }
        if (target.hasCheckSourceCalParameters()) {
            stringBuilder.append("ChkCal,");
        }
        if (target.hasDGCReferenceCalParameters()) {
            stringBuilder.append("DGCRefCal,");
        }
        if (target.hasDGCScienceCalParameters()) {
            stringBuilder.append("DGCScienceCal,");
        }
        if (target.hasBandpassCalParameters()) {
            stringBuilder.append("BndCal,");
        }
        if (target.hasFocusCalParameters()) {
            stringBuilder.append("FocCal,");
        }
        if (target.hasOpticalPointingParameters()) {
            stringBuilder.append("OptPtg,");
        }
        if (target.hasRadiometricPointingParameters()) {
            stringBuilder.append("RadPtg,");
        }
        if ((n = (string = stringBuilder.toString()).lastIndexOf(",")) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Longitude.class;
            }
            case 2: {
                return Latitude.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Frequency.class;
            }
            case 5: {
                return String.class;
            }
        }
        throw new RuntimeException("Invalid number of columns");
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "<html><div align=center>Source Name</div></html>";
            }
            case 1: {
                return "<html><div align=center>RA</div></html>";
            }
            case 2: {
                return "<html><div align=center>DEC</div></html>";
            }
            case 3: {
                return "<html><div align=center>Spectral Spec</div></html>";
            }
            case 4: {
                return "<html><div align=center>Rest Freq</div></html>";
            }
            case 5: {
                return "<html><div align=center>Purpose</div></html>";
            }
        }
        return "<html><div align=center><font color=red>**ERROR**</font></div></html>";
    }

    @Override
    public int getRowCount() {
        return this.getTargetCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Target target = this.getTargetAtRow(n);
        try {
            switch (n2) {
                case 0: {
                    return target.getFieldSource().getSourceName();
                }
                case 1: {
                    return target.getFieldSource().getSourceCoordinates().getJ2000SkyCoordinates().getLongitude();
                }
                case 2: {
                    return target.getFieldSource().getSourceCoordinates().getJ2000SkyCoordinates().getLatitude();
                }
                case 3: {
                    return target.getSpectralSpec().getName();
                }
                case 4: {
                    return target.getSpectralSpec().getRestFrequency();
                }
                case 5: {
                    return this.getPurposeString(target);
                }
            }
            return "<html><font color=\"red\">Error!</font></html>";
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    public Object[] getLongValues() {
        return new Object[]{"Source Name", "+00:00:00", "+00:00:00", "Spectral Spec Name", "123.4 GHz", "Phs,Amp,Plr"};
    }

    public SchedBlock getSchedBlock() {
        return this.schedBlock;
    }

    public void setSchedBlock(SchedBlock schedBlock) {
        this.schedBlock = schedBlock;
    }
}

