/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.FieldImportExporter;
import alma.obsprep.ot.editors.schedblock.IndividualPointingsExportOptions;
import alma.obsprep.ot.editors.schedblock.PointingExportFileDetails;
import alma.obsprep.ot.editors.schedblock.PointingImpexFactory;
import alma.obsprep.ot.editors.spatialvisual.ScienceGoalSpatialVisualModel;
import alma.obsprep.ot.models.obsproject.RectangleModel;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.services.experts.RectangleAreaExpert;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.SkyCoordinates;
import java.io.File;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import lombok.NonNull;

public class RectanglePatternImporterExporter
extends FieldImportExporter
implements PointingImpexFactory.PointingImpexInterface {
    private final Pattern p = Pattern.compile("(\\d+):(\\d+):(\\d+)");
    @NonNull
    private RectangleModel rectangleModel;
    @NonNull
    private ScienceGoalSpatialVisualModel scienceGoalSpatialVisualModel;

    public RectanglePatternImporterExporter(@NonNull Model model) {
        if (model == null) {
            throw new NullPointerException("scienceGoalSpatialVisualModel is marked non-null but is null");
        }
        if (!(model instanceof ScienceGoalSpatialVisualModel)) {
            throw new IllegalArgumentException("pointingSourceModel should be ScienceGoalSpatialVisualModel");
        }
        this.scienceGoalSpatialVisualModel = (ScienceGoalSpatialVisualModel)model;
        this.rectangleModel = this.scienceGoalSpatialVisualModel.getFormModel().getTargetParametersModel().getFieldModel().getRectangleModel();
    }

    @Override
    public void importPointingsFromFile(@NonNull JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("parentComponent is marked non-null but is null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportPointingsToFile(@NonNull JComponent jComponent) {
        PointingExportFileDetails pointingExportFileDetails;
        if (jComponent == null) {
            throw new NullPointerException("parentComponent is marked non-null but is null");
        }
        Rectangle rectangle = (Rectangle)this.rectangleModel.getDocument();
        RectangleAreaExpert rectangleAreaExpert = RectangleAreaExpert.of(rectangle);
        PointingPattern pointingPattern = rectangleAreaExpert.getPointingPattern(Array.ARRAY_12M);
        PointingPattern pointingPattern2 = rectangleAreaExpert.getPointingPattern(Array.ARRAY_7M);
        if (pointingPattern.getNumberOfPointings() == 0 && pointingPattern2.getNumberOfPointings() == 0) {
            GUIUtilities.info(null, "There are no pointings to export");
            return;
        }
        boolean bl = false;
        try {
            bl = ((ScienceGoal)this.scienceGoalSpatialVisualModel.getSpatialDocument()).getPerformanceParameters().getUseACA();
        }
        catch (Exception exception) {
            bl = false;
        }
        try {
            pointingExportFileDetails = this.getPointingFileNames(true, bl, jComponent);
        }
        catch (FieldImportExporter.AbortPointingExportException abortPointingExportException) {
            return;
        }
        if (pointingExportFileDetails.getDialogueRetCode() == 0) {
            SkyCoordinates skyCoordinates = (SkyCoordinates)this.scienceGoalSpatialVisualModel.getSourceCoordinatesModel().getDocument();
            pointingExportFileDetails.getTwelveMFile().ifPresent(file -> this.exportPointings(skyCoordinates, pointingPattern, (File)file, pointingExportFileDetails.getExpOpts()));
            pointingExportFileDetails.getAca7MFile().ifPresent(file -> this.exportPointings(skyCoordinates, pointingPattern2, (File)file, pointingExportFileDetails.getExpOpts()));
        }
    }

    private void exportPointings(@NonNull SkyCoordinates skyCoordinates, @NonNull PointingPattern pointingPattern, @NonNull File file, @NonNull IndividualPointingsExportOptions individualPointingsExportOptions) {
        if (skyCoordinates == null) {
            throw new NullPointerException("fieldCentre is marked non-null but is null");
        }
        if (pointingPattern == null) {
            throw new NullPointerException("pointingPattern is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("outputFile is marked non-null but is null");
        }
        if (individualPointingsExportOptions == null) {
            throw new NullPointerException("individualPointingsExportOptions is marked non-null but is null");
        }
        PointingPatternModel pointingPatternModel = new PointingPatternModel(pointingPattern);
        FieldSource fieldSource = FieldSource.createFieldSource();
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
        fieldSource.setSourceCoordinates(skyCoordinates);
        if (individualPointingsExportOptions.isAbsoluteCoords()) {
            pointingPatternModel.exportAbsoluteCoordsToFile(file, individualPointingsExportOptions.getAbsCoordsType(), Optional.empty());
        } else {
            pointingPatternModel.exportOffsetCoordsToFile(file, individualPointingsExportOptions.getOffsetCoordsType(), Optional.empty());
        }
    }
}

