/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.HistoricalProjectRefresher;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.PostRetrievalActionInterface;
import alma.obsprep.ot.actions.RetrieveInteractor;
import alma.obsprep.ot.actions.RetrievePerformer;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectRepository;
import java.io.IOException;
import lombok.NonNull;

public class RetrieveAsNewPerformer
extends RetrievePerformer {
    public RetrieveAsNewPerformer(Interactor interactor, ProjectRepository projectRepository) {
        super(interactor, projectRepository);
    }

    @Override
    public boolean postRetrieveProcessing(@NonNull ObsProject obsProject) throws PostRetrievalActionInterface.UnableToPerformPostRetrievalProcessingException {
        Object object;
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        RetrieveInteractor retrieveInteractor = (RetrieveInteractor)this.getGui();
        if (this.isProjectDDT && !retrieveInteractor.getUserConfirmation("Converting DDT proposal to non-DDT. Cancel if this is not what you intended", "Convert", "Cancel")) {
            return false;
        }
        this.projectRecycler.recycleProjectAsNewProject(obsProject);
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        try {
            obsProject.getObsProposal().setCycle(almaPolicies.getCycleNumber());
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(RetrieveAsNewPerformer.class).warning("Unable to get obsproposal " + unknownEntityException.getMessage());
        }
        obsProject.setIsDDT(false);
        try {
            object = Apdm_to_BO.decomposeIncludingFiles(obsProject);
            ImpexFactory.updateRevisionNumbersOfDocuments((Apdm_to_BO.BoBundle)object);
        }
        catch (UnknownEntityException | IOException throwable) {
            Log.logger(this.getClass()).warning("Unable to reset the revision number of document: " + throwable.getMessage());
        }
        object = new HistoricalProjectRefresher(obsProject);
        ((HistoricalProjectRefresher)object).applyCurrentCycleConstraints();
        return true;
    }
}

