/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.widgets;

import alma.obsprep.guiutil.mvc.widgets.OTTextArea;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.util.GUIUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OTFileWindow
extends JFrame
implements ActionListener {
    private static final String CANCEL = "Cancel";
    private static final String DONE = "OK";
    private static final String IMPORT = "Import";
    private static final String EXPORT = "Export";
    private static DialogId DIALOG_OVERWRITE_FILE = new DialogId("OTFileWindow.OverwriteFile");
    private JFileChooser fchooser;
    private JTextArea jta = null;
    private JScrollPane jsp = null;
    private OTTextArea master = null;

    public OTFileWindow(String string) {
        this(string, null, null);
    }

    public OTFileWindow(String string, String string2) {
        this(string, string2, null);
    }

    public OTFileWindow(String string, String string2, OTTextArea oTTextArea) {
        super(string);
        this.master = oTTextArea;
        Container container = this.getContentPane();
        this.jta = new JTextArea(string2);
        this.jta.setFont(new Font("Courier", 0, 12));
        this.jsp = new JScrollPane(this.jta);
        this.jsp.setVerticalScrollBarPolicy(20);
        this.jsp.setHorizontalScrollBarPolicy(30);
        this.jsp.setPreferredSize(new Dimension(580, 750));
        this.jsp.setOpaque(true);
        container.add((Component)this.jsp, "Center");
        JButton jButton = new JButton(DONE);
        jButton.addActionListener(this);
        jButton.setToolTipText("Close this editor; any changes you made are preserved.");
        JButton jButton2 = new JButton(CANCEL);
        jButton2.addActionListener(this);
        jButton2.setToolTipText("Close this editor, discarding all changes.");
        JButton jButton3 = new JButton(EXPORT);
        jButton3.addActionListener(this);
        jButton3.setToolTipText("Save the current text to an external file.");
        JButton jButton4 = new JButton(IMPORT);
        jButton4.addActionListener(this);
        jButton4.setToolTipText("Replace the current text with the contents of an external file.");
        Box box = Box.createHorizontalBox();
        box.add(Box.createGlue());
        box.add(jButton);
        box.add(Box.createGlue());
        box.add(jButton2);
        box.add(Box.createGlue());
        box.add(jButton3);
        box.add(Box.createGlue());
        box.add(jButton4);
        box.add(Box.createGlue());
        container.add((Component)box, "South");
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fchooser == null) {
            this.fchooser = new JFileChooser();
        }
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals(CANCEL)) {
                this.doCancel(actionEvent);
            }
            if (string.equals(DONE)) {
                this.doOk(actionEvent);
            }
            if (string.equals(EXPORT)) {
                this.doExport(actionEvent);
            } else if (string.equals(IMPORT)) {
                this.doImport(actionEvent);
            }
        }
        catch (IOException iOException) {
            GUIUtilities.error(null, "Failed to perform the operation.", iOException);
        }
    }

    public void doExport(ActionEvent actionEvent) throws IOException {
        String string;
        boolean bl;
        this.fchooser.setDialogTitle(EXPORT);
        this.fchooser.setApproveButtonText(EXPORT);
        int n = this.fchooser.showOpenDialog(this);
        System.out.println(">>> ret=" + n);
        if (n != 0) {
            return;
        }
        File file = this.fchooser.getSelectedFile();
        String string2 = file.getCanonicalPath();
        if (file.exists() && !(bl = GUIUtilities.confirm(DIALOG_OVERWRITE_FILE, string = "File " + string2 + " already exists.\nDo you want to replace it?"))) {
            return;
        }
        FileWriter fileWriter = new FileWriter(file, false);
        fileWriter.write(this.getText());
        fileWriter.close();
    }

    public void doImport(ActionEvent actionEvent) throws IOException {
        String string;
        this.fchooser.setDialogTitle(IMPORT);
        this.fchooser.setApproveButtonText(IMPORT);
        int n = this.fchooser.showOpenDialog(this);
        System.out.println(">>> ret=" + n);
        if (n != 0) {
            return;
        }
        File file = this.fchooser.getSelectedFile();
        System.out.println("Loading: " + file.getName());
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        this.setText(stringBuilder.toString());
        bufferedReader.close();
        this.scrollToTop();
    }

    public void doOk(ActionEvent actionEvent) {
        if (this.master != null) {
            this.master.setText(this.getText(), true);
        }
        this.setText(null);
        this.setVisible(false);
    }

    public void doCancel(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void SetMaster(OTTextArea oTTextArea) {
        this.master = oTTextArea;
    }

    public String getText() {
        return this.jta.getText();
    }

    public void setText(String string) {
        this.jta.setText(string);
    }

    public void setPreferredSize(int n, int n2) {
        this.jsp.setPreferredSize(new Dimension(n, n2));
    }

    public void scrollToTop() {
        this.jta.setCaretPosition(0);
    }

    public void scrollToBottom() {
        this.jta.setCaretPosition(this.jta.getText().length() - 1);
    }
}

