/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc;

import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.guiutil.mvc.ContextSwitchInterface;
import alma.obsprep.guiutil.mvc.Controller;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.View;
import alma.obsprep.guiutil.mvc.verifiers.Verifier;
import alma.obsprep.guiutil.mvc.widgets.OTBasicTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.guiutil.mvc.widgets.OTFileArea;
import alma.obsprep.guiutil.mvc.widgets.OTJTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTTabbedPane;
import alma.obsprep.guiutil.mvc.widgets.OTTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.boEditors.VelocityVerifier;
import alma.obsprep.ot.editors.misc.CompactIsoDatePicker;
import alma.obsprep.ot.editors.misc.IsoDatePicker;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.VelocityEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.EditorSelectedInterface;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import alma.obsprep.services.sfi.ScienceGoalEditorViewEnum;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import java.awt.AWTKeyStroke;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractSpinnerModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;

public abstract class Editor
extends View
implements ContextSwitchInterface,
EditorSelectedInterface {
    protected static final String FOCUSLOST_VERIFIER = "FOCUSLOST_VERIFIER";
    protected static final String KEYSTROKE_VERIFIER = "KEYSTROKE_VERIFIER";

    protected Editor() {
        this.makeEnterForwardTraversalKey();
    }

    protected Editor(Model model) {
        super(model, false);
        this.makeEnterForwardTraversalKey();
    }

    public String get(JButton jButton) {
        return jButton.getText();
    }

    public String get(JRadioButton jRadioButton) {
        return jRadioButton.getText();
    }

    public boolean get(JCheckBox jCheckBox) {
        return jCheckBox.isSelected();
    }

    public String get(JComboBox jComboBox) {
        return this.getUILabelToBOMapping(jComboBox, jComboBox.getSelectedItem().toString());
    }

    public String get(OTComboBox oTComboBox) {
        return oTComboBox.getSelectedItem().toString();
    }

    public String get(JFormattedTextField jFormattedTextField) {
        return jFormattedTextField.getText();
    }

    public Integer[] get(JList jList) {
        int[] nArray = jList.getSelectedIndices();
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public int get(JSlider jSlider) {
        return jSlider.getValue();
    }

    public Object get(JSpinner jSpinner) {
        SpinnerModel spinnerModel = jSpinner.getModel();
        if (spinnerModel instanceof SpinnerNumberModel) {
            SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)spinnerModel;
            return spinnerNumberModel.getNumber();
        }
        if (spinnerModel instanceof SpinnerDateModel) {
            SpinnerDateModel spinnerDateModel = (SpinnerDateModel)spinnerModel;
            return spinnerDateModel.getDate();
        }
        return null;
    }

    public int get(JTabbedPane jTabbedPane) {
        return jTabbedPane.getSelectedIndex();
    }

    public String get(JTextArea jTextArea) {
        return TextUtils.stripNonAsciiChars(jTextArea.getText());
    }

    public String get(OTTextArea oTTextArea) {
        return TextUtils.stripNonAsciiChars(oTTextArea.getText());
    }

    public String get(OTBasicTextArea oTBasicTextArea) {
        return TextUtils.stripNonAsciiChars(oTBasicTextArea.getText());
    }

    public String get(OTFileArea oTFileArea) {
        return oTFileArea.getText();
    }

    public String get(JTextField jTextField) {
        return TextUtils.stripNonAsciiChars(jTextField.getText());
    }

    public String get(OTButtonGroup oTButtonGroup) {
        return oTButtonGroup.getSelectedItem();
    }

    protected Verifier getVerifier(JComponent jComponent, String string) {
        return (Verifier)jComponent.getClientProperty(string);
    }

    private void selectAllText(JTextComponent jTextComponent) {
        jTextComponent.setCaretPosition(0);
        jTextComponent.moveCaretPosition(jTextComponent.getText().length());
    }

    public void initEvents(JButton jButton, FieldID fieldID) {
        JButton jButton2 = jButton;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        ActionListener actionListener = actionEvent -> {
            Controller controller = this.getController();
            String string = this.get(jButton2);
            ActionLog.edited(editor, jButton2, fieldID2, string);
            controller.widgetUpdated(editor, fieldID2, string);
        };
        jButton.addActionListener(actionListener);
        fieldID.addView(this);
        this.register(jButton, fieldID);
        this.listeners.put(jButton, actionListener);
    }

    public void initEvents(JRadioButton jRadioButton, FieldID fieldID) {
        JRadioButton jRadioButton2 = jRadioButton;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        ActionListener actionListener = actionEvent -> {
            Controller controller = this.getController();
            String string = this.get(jRadioButton2);
            ActionLog.edited(editor, jRadioButton2, fieldID2, string);
            controller.widgetUpdated(editor, fieldID2, string);
        };
        jRadioButton.addActionListener(actionListener);
        fieldID.addView(this);
        this.register(jRadioButton, fieldID);
        this.listeners.put(jRadioButton, actionListener);
    }

    public void initEvents(JCheckBox jCheckBox, FieldID fieldID) {
        JCheckBox jCheckBox2 = jCheckBox;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        ItemListener itemListener = itemEvent -> {
            Controller controller = this.getController();
            Boolean bl = this.get(jCheckBox2);
            ActionLog.edited(editor, jCheckBox2, fieldID2, bl);
            controller.widgetUpdated(editor, fieldID2, bl);
        };
        jCheckBox.addItemListener(itemListener);
        fieldID.addView(this);
        this.register(jCheckBox, fieldID);
        this.listeners.put(jCheckBox, itemListener);
    }

    public void initEvents(JComboBox jComboBox, FieldID fieldID) {
        JComboBox jComboBox2 = jComboBox;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        ActionListener actionListener = actionEvent -> {
            if (jComboBox2.getItemCount() == 0) {
                return;
            }
            Controller controller = this.getController();
            String string = this.get(jComboBox2);
            ActionLog.edited(editor, jComboBox2, fieldID2, string);
            int n = actionEvent.getModifiers() & 8;
            if (n == 0) {
                controller.widgetUpdated(editor, fieldID2, string);
            } else {
                controller.widgetModified(editor, fieldID2, string);
            }
        };
        jComboBox.addActionListener(actionListener);
        fieldID.addView(this);
        this.register(jComboBox, fieldID);
        this.listeners.put(jComboBox, actionListener);
    }

    public void initEvents(OTComboBox oTComboBox, FieldID fieldID) {
        OTComboBox oTComboBox2 = oTComboBox;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        ActionListener actionListener = actionEvent -> {
            if (oTComboBox2.getItemCount() == 0) {
                return;
            }
            Controller controller = this.getController();
            String string = this.get(oTComboBox2);
            ActionLog.edited(editor, oTComboBox2, fieldID2, string);
            controller.widgetUpdated(editor, fieldID2, string);
        };
        oTComboBox.addActionListener(actionListener);
        fieldID.addView(this);
        this.register(oTComboBox, fieldID);
        this.listeners.put(oTComboBox, actionListener);
    }

    public void initEvents(JLabel jLabel, FieldID fieldID) {
        fieldID.addView(this);
        this.register(jLabel, fieldID);
    }

    public void initEvents(JList jList, FieldID fieldID) {
        JList jList2 = jList;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        ListSelectionListener listSelectionListener = listSelectionEvent -> {
            Controller controller = this.getController();
            Integer[] integerArray = this.get(jList2);
            ActionLog.edited(editor, jList2, fieldID2, integerArray);
            controller.widgetUpdated(editor, fieldID2, integerArray);
        };
        jList.addListSelectionListener(listSelectionListener);
        fieldID.addView(this);
        this.register(jList, fieldID);
        this.listeners.put(jList, listSelectionListener);
    }

    public void initEvents(JSlider jSlider, FieldID fieldID) {
        JSlider jSlider2 = jSlider;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        jSlider.addChangeListener(changeEvent -> {
            if (jSlider2.getValueIsAdjusting()) {
                return;
            }
            Controller controller = this.getController();
            String string = String.valueOf(this.get(jSlider2));
            ActionLog.edited(editor, jSlider2, fieldID2, string);
            controller.widgetUpdated(editor, fieldID2, string);
        });
        fieldID.addView(this);
        this.register(jSlider, fieldID);
    }

    public void initEvents(JSpinner jSpinner, FieldID fieldID) {
        JSpinner jSpinner2 = jSpinner;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        ChangeListener changeListener = null;
        SpinnerModel spinnerModel = jSpinner.getModel();
        if (spinnerModel instanceof SpinnerNumberModel) {
            SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)spinnerModel;
            changeListener = changeEvent -> {
                Controller controller = this.getController();
                Number number = spinnerNumberModel.getNumber();
                ActionLog.edited(editor, jSpinner2, fieldID2, number);
                controller.widgetUpdated(editor, fieldID2, number);
            };
        } else if (spinnerModel instanceof SpinnerDateModel) {
            SpinnerDateModel spinnerDateModel = (SpinnerDateModel)spinnerModel;
            changeListener = changeEvent -> {
                Controller controller = this.getController();
                Date date = spinnerDateModel.getDate();
                ActionLog.edited(editor, jSpinner2, fieldID2, date);
                controller.widgetUpdated(editor, fieldID2, date);
            };
        }
        jSpinner.addChangeListener(changeListener);
        fieldID.addView(this);
        this.register(jSpinner, fieldID);
        this.listeners.put(jSpinner, changeListener);
    }

    public void initEvents(JTabbedPane jTabbedPane, FieldID fieldID) {
        JTabbedPane jTabbedPane2 = jTabbedPane;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        ChangeListener changeListener = changeEvent -> {
            Controller controller = this.getController();
            Integer n = this.get(jTabbedPane2);
            controller.widgetUpdated(editor, fieldID2, n);
        };
        jTabbedPane.getModel().addChangeListener(changeListener);
        fieldID.addView(this);
        this.register(jTabbedPane, fieldID);
        this.listeners.put(jTabbedPane, changeListener);
    }

    public void initEvents(JTable jTable, FieldID fieldID) {
        TableModelListener tableModelListener = tableModelEvent -> this.getController();
        jTable.getModel().addTableModelListener(tableModelListener);
        fieldID.addView(this);
        this.register(jTable, fieldID);
    }

    public void initEvents(JTextArea jTextArea, FieldID fieldID) {
        final JTextArea jTextArea2 = jTextArea;
        final Editor editor = this;
        final FieldID fieldID2 = fieldID;
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (Editor.this.getGuiApi().isFieldReplace()) {
                    Editor.this.selectAllText(jTextArea2);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Controller controller = Editor.this.getController();
                String string = Editor.this.get(jTextArea2);
                ActionLog.edited(editor, jTextArea2, fieldID2, string);
                controller.widgetUpdated(editor, fieldID2, string);
            }
        };
        jTextArea.addFocusListener(focusListener);
        fieldID.addView(this);
        this.register(jTextArea, fieldID);
    }

    public void initEvents(OTTextArea oTTextArea, FieldID fieldID) {
        OTTextArea oTTextArea2 = oTTextArea;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            if (propertyChangeEvent.getPropertyName().equals("EditorUpdate")) {
                Controller controller = this.getController();
                String string = this.get(oTTextArea2);
                ActionLog.edited(editor, oTTextArea2, fieldID2, string);
                controller.widgetUpdated(editor, fieldID2, string);
            }
        };
        oTTextArea.addPropertyChangeListener(propertyChangeListener);
        fieldID.addView(this);
        this.register(oTTextArea, fieldID);
    }

    public void initEvents(OTBasicTextArea oTBasicTextArea, FieldID fieldID) {
        OTBasicTextArea oTBasicTextArea2 = oTBasicTextArea;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            if (propertyChangeEvent.getPropertyName().equals("EditorUpdate")) {
                Controller controller = this.getController();
                String string = this.get(oTBasicTextArea2);
                controller.widgetUpdated(editor, fieldID2, string);
            }
        };
        oTBasicTextArea.addPropertyChangeListener(propertyChangeListener);
        fieldID.addView(this);
        this.register(oTBasicTextArea, fieldID);
    }

    public void initEvents(OTFileArea oTFileArea, FieldID fieldID) {
        OTFileArea oTFileArea2 = oTFileArea;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            if (propertyChangeEvent.getPropertyName().equals("Load Ephemeris")) {
                Controller controller = this.getController();
                String string = this.get(oTFileArea2);
                ActionLog.edited(editor, oTFileArea2, fieldID2, string);
                controller.widgetUpdated(editor, fieldID2, string);
            }
        };
        oTFileArea.addPropertyChangeListener(propertyChangeListener);
        fieldID.addView(this);
        this.register(oTFileArea, fieldID);
    }

    public void initEvents(JTextField jTextField, FieldID fieldID) {
        FocusListener focusListener = null;
        KeyListener keyListener = null;
        final JTextField jTextField2 = jTextField;
        final Editor editor = this;
        final FieldID fieldID2 = fieldID;
        keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Controller controller = Editor.this.getController();
                Object object = Editor.this.get(jTextField2);
                Verifier verifier = Editor.this.getVerifier(jTextField2, Editor.KEYSTROKE_VERIFIER);
                if (verifier != null) {
                    object = verifier.verify();
                }
                if (object == null) {
                    controller.widgetInvalid(editor, fieldID2, Editor.this.get(jTextField2));
                    return;
                }
                String string = Editor.this.get(jTextField2);
                controller.widgetChanged(editor, fieldID2, string);
            }
        };
        focusListener = new FocusListener(){
            private String valueOnEnter = null;

            @Override
            public void focusGained(FocusEvent focusEvent) {
                this.valueOnEnter = jTextField2.getText();
                if (Editor.this.getGuiApi().isFieldReplace()) {
                    Editor.this.selectAllText(jTextField2);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Controller controller = Editor.this.getController();
                Object object = Editor.this.get(jTextField2);
                Verifier verifier = Editor.this.getVerifier(jTextField2, Editor.KEYSTROKE_VERIFIER);
                if (verifier == null) {
                    verifier = Editor.this.getVerifier(jTextField2, Editor.FOCUSLOST_VERIFIER);
                }
                if (verifier != null) {
                    object = verifier.verify();
                }
                if (object == null) {
                    controller.widgetInvalid(editor, fieldID2, Editor.this.get(jTextField2));
                    return;
                }
                Editor.this.set((JComponent)jTextField2, object);
                String string = Editor.this.get(jTextField2);
                if (string != null && string.equals(this.valueOnEnter)) {
                    return;
                }
                ActionLog.edited(editor, jTextField2, fieldID2, string);
                controller.widgetUpdated(editor, fieldID2, string);
            }
        };
        jTextField.addKeyListener(keyListener);
        jTextField.addFocusListener(focusListener);
        fieldID.addView(this);
        this.register(jTextField, fieldID);
    }

    private Object getWidgetValue(JComponent jComponent) {
        Object object = null;
        if (jComponent instanceof JButton) {
            JButton jButton = (JButton)jComponent;
            object = jButton.getText();
        } else if (jComponent instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)jComponent;
            object = jRadioButton.getText();
        } else if (jComponent instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)jComponent;
            object = jCheckBox.isSelected();
        } else if (jComponent instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)jComponent;
            object = jComboBox.getSelectedItem().toString();
        } else if (jComponent instanceof OTComboBox) {
            OTComboBox oTComboBox = (OTComboBox)jComponent;
            object = oTComboBox.getSelectedItem().toString();
        } else if (jComponent instanceof JFormattedTextField) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)jComponent;
            object = jFormattedTextField.getText();
        } else if (jComponent instanceof JSlider) {
            JSlider jSlider = (JSlider)jComponent;
            object = jSlider.getValue();
        } else if (jComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
            object = jTabbedPane.getSelectedIndex();
        } else if (jComponent instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)jComponent;
            object = jTextArea.getText();
        } else if (jComponent instanceof OTTextArea) {
            OTTextArea oTTextArea = (OTTextArea)jComponent;
            object = oTTextArea.getText();
        } else if (jComponent instanceof OTBasicTextArea) {
            OTBasicTextArea oTBasicTextArea = (OTBasicTextArea)jComponent;
            object = oTBasicTextArea.getText();
        } else if (jComponent instanceof OTFileArea) {
            OTFileArea oTFileArea = (OTFileArea)jComponent;
            object = oTFileArea.getText();
        } else if (jComponent instanceof OTButtonGroup) {
            OTButtonGroup oTButtonGroup = (OTButtonGroup)jComponent;
            object = oTButtonGroup.getSelectedItem();
        } else if (jComponent instanceof JTextField) {
            JTextField jTextField = (JTextField)jComponent;
            object = jTextField.getText();
        } else if (jComponent instanceof JList) {
            JList jList = (JList)jComponent;
            int[] nArray = jList.getSelectedIndices();
            Integer[] integerArray = new Integer[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                integerArray[i] = nArray[i];
            }
            object = integerArray;
        } else if (jComponent instanceof JSpinner) {
            AbstractSpinnerModel abstractSpinnerModel;
            JSpinner jSpinner = (JSpinner)jComponent;
            SpinnerModel spinnerModel = jSpinner.getModel();
            if (spinnerModel instanceof SpinnerNumberModel) {
                abstractSpinnerModel = (SpinnerNumberModel)spinnerModel;
                object = ((SpinnerNumberModel)abstractSpinnerModel).getNumber();
            }
            if (spinnerModel instanceof SpinnerDateModel) {
                abstractSpinnerModel = (SpinnerDateModel)spinnerModel;
                object = ((SpinnerDateModel)abstractSpinnerModel).getDate();
            }
        }
        return object;
    }

    public void updateField(FieldID fieldID) {
        Controller controller = this.getController();
        JComponent jComponent = this.getComponent(fieldID);
        if (jComponent != null) {
            Object object = this.getWidgetValue(jComponent);
            Verifier verifier = this.getVerifier(jComponent, KEYSTROKE_VERIFIER);
            if (verifier == null) {
                verifier = this.getVerifier(jComponent, FOCUSLOST_VERIFIER);
            }
            if (verifier != null) {
                object = verifier.verify();
            }
            controller.widgetUpdated(this, fieldID, object);
        }
    }

    public void initEvents(JTextField jTextField, FieldID fieldID, String string, Verifier verifier) {
        this.initEvents(jTextField, fieldID);
        this.setVerifier(jTextField, string, verifier);
    }

    public void initEvents(OTButtonGroup oTButtonGroup, FieldID fieldID) {
        OTButtonGroup oTButtonGroup2 = oTButtonGroup;
        Editor editor = this;
        FieldID fieldID2 = fieldID;
        ActionListener actionListener = actionEvent -> {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            Object object = jRadioButton.getClientProperty(View.BO_MAPPING_CLIENT_PROPERTY);
            String string = object != null ? (String)object : this.get(oTButtonGroup2);
            Controller controller = this.getController();
            ActionLog.edited(editor, oTButtonGroup2, fieldID2, string);
            controller.widgetUpdated(editor, fieldID2, string);
        };
        oTButtonGroup.addActionListener(actionListener);
        fieldID.addView(this);
        this.register(oTButtonGroup, fieldID);
        this.listeners.put(oTButtonGroup, actionListener);
    }

    private void makeEnterForwardTraversalKey() {
        Set<AWTKeyStroke> set = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(set);
        hashSet.add(KeyStroke.getKeyStroke(10, 0));
        this.setFocusTraversalKeys(0, hashSet);
    }

    @Override
    public void set(JTextField jTextField, String string) {
        if (string == null) {
            return;
        }
        super.set(jTextField, string);
        this.revalidate(jTextField);
    }

    public void setVerifier(JComponent jComponent, String string, Verifier verifier) {
        if (!string.equals(FOCUSLOST_VERIFIER) && !string.equals(KEYSTROKE_VERIFIER)) {
            throw new IllegalArgumentException("Invalid verifier type:" + string);
        }
        jComponent.putClientProperty(FOCUSLOST_VERIFIER, null);
        jComponent.putClientProperty(KEYSTROKE_VERIFIER, null);
        jComponent.putClientProperty(string, verifier);
    }

    public Object widgetUpdated(FieldID fieldID, Object object) {
        return object;
    }

    public Object widgetModified(FieldID fieldID, Object object) {
        return object;
    }

    protected void configureEditorForView(ScienceGoalEditorViewEnum scienceGoalEditorViewEnum) {
        throw new UnsupportedOperationException();
    }

    public List<JComponent> getUserRestrictedEditableComponents() {
        return new ArrayList<JComponent>();
    }

    protected JButton makeButton(FieldID fieldID, String string, Icon icon) {
        JButton jButton = new JButton(icon);
        jButton.setFocusPainted(false);
        jButton.setToolTipText(string);
        this.initEvents(jButton, fieldID);
        return jButton;
    }

    protected JButton makeButton(FieldID fieldID, String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setFocusPainted(false);
        jButton.setToolTipText(string2);
        this.initEvents(jButton, fieldID);
        return jButton;
    }

    protected JButton makeButton(FieldID fieldID, String string, String string2, Icon icon) {
        JButton jButton = new JButton(string, icon);
        jButton.setFocusPainted(false);
        jButton.setToolTipText(string2);
        this.initEvents(jButton, fieldID);
        return jButton;
    }

    protected JCheckBox makeCheckBox(FieldID fieldID, String string) {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setFocusPainted(false);
        this.initEvents(jCheckBox, fieldID);
        jCheckBox.setToolTipText(string);
        return jCheckBox;
    }

    protected JPanel createLineContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 5));
        return jPanel;
    }

    protected JCheckBox makeCheckBox(FieldID fieldID, String string, boolean bl, String string2) {
        JCheckBox jCheckBox = new JCheckBox(string, bl);
        jCheckBox.setFocusPainted(false);
        this.initEvents(jCheckBox, fieldID);
        jCheckBox.setToolTipText(string2);
        return jCheckBox;
    }

    protected JCheckBox makeCheckBox(FieldID fieldID, String string, String string2) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setFocusPainted(false);
        this.initEvents(jCheckBox, fieldID);
        jCheckBox.setToolTipText(string2);
        return jCheckBox;
    }

    protected JComboBox makeComboBox(FieldID fieldID, String[] stringArray, String string) {
        return this.makeComboBox(fieldID, stringArray, string, null);
    }

    protected JComboBox makeComboBox(FieldID fieldID, String[] stringArray, String string, Map<String, String> map) {
        return this.makeComboBox(fieldID, stringArray, string, map, Optional.empty());
    }

    protected JComboBox makeComboBox(FieldID fieldID, String[] stringArray, String string, Map<String, String> map, Optional<DefaultComboBoxModel<String>> optional) {
        JComboBox<Object> jComboBox = optional.isPresent() ? new JComboBox(optional.get()) : (stringArray != null && stringArray.length > 0 ? new JComboBox<String>(stringArray) : new JComboBox());
        if (map != null) {
            for (String string2 : map.keySet()) {
                this.createUILabelMapping(jComboBox, string2, map.get(string2));
            }
        }
        this.initEvents(jComboBox, fieldID);
        jComboBox.setToolTipText(string);
        return jComboBox;
    }

    protected CompactIsoDatePicker makeCompactIsoDateTimePanel(Editor editor, FieldID fieldID, String string, ZonedDateTime zonedDateTime) {
        CompactIsoDatePicker compactIsoDatePicker = new CompactIsoDatePicker(editor, fieldID, zonedDateTime);
        this.initEvents(compactIsoDatePicker.getIsoDateTimeField(), fieldID);
        compactIsoDatePicker.setToolTipText(string);
        return compactIsoDatePicker;
    }

    protected IsoDatePicker makeIsoDateTimePanel(Editor editor, FieldID fieldID, String string) {
        IsoDatePicker isoDatePicker = new IsoDatePicker(editor, fieldID);
        this.initEvents(isoDatePicker.getIsoDateTimeField(), fieldID);
        isoDatePicker.setToolTipText(string);
        return isoDatePicker;
    }

    protected JList<String> makeJList(FieldID fieldID, String[] stringArray, String string) {
        JList<String> jList = new JList<String>(stringArray);
        this.initEvents(jList, fieldID);
        jList.setToolTipText(string);
        return jList;
    }

    protected JLabel makeLabel(FieldID fieldID, String string, String string2) {
        JLabel jLabel = new JLabel(string);
        this.initEvents(jLabel, fieldID);
        jLabel.setToolTipText(string2);
        return jLabel;
    }

    protected JLabel makeLabel(String string) {
        return new JLabel(string);
    }

    protected OTBasicTextArea makeOTBasicTextArea(FieldID fieldID, String string, int n, int n2, boolean bl) {
        OTBasicTextArea oTBasicTextArea = new OTBasicTextArea(bl, string);
        oTBasicTextArea.setPreferredSize(n, n2);
        this.initEvents(oTBasicTextArea, fieldID);
        oTBasicTextArea.setToolTipText(string);
        return oTBasicTextArea;
    }

    protected OTButtonGroup makeOTButtonGroup(FieldID fieldID, String[] stringArray, String string) {
        OTButtonGroup oTButtonGroup = new OTButtonGroup(stringArray);
        this.initEvents(oTButtonGroup, fieldID);
        oTButtonGroup.setToolTipText(string);
        return oTButtonGroup;
    }

    protected OTButtonGroup makeOTButtonGroup(FieldID fieldID, String[] stringArray, String string, int n, int n2) {
        OTButtonGroup oTButtonGroup = new OTButtonGroup(stringArray, n, n2);
        this.initEvents(oTButtonGroup, fieldID);
        oTButtonGroup.setToolTipText(string);
        return oTButtonGroup;
    }

    protected OTButtonGroup makeOTButtonGroup(FieldID fieldID, String[] stringArray, String[] stringArray2) {
        OTButtonGroup oTButtonGroup = new OTButtonGroup(stringArray, 0, stringArray2);
        this.initEvents(oTButtonGroup, fieldID);
        return oTButtonGroup;
    }

    protected <T extends Enum<T>> OTButtonGroup makeOTButtonGroup(FieldID fieldID, T[] TArray, String[] stringArray) {
        return this.makeOTButtonGroup(fieldID, (Enum[])TArray, stringArray, 0);
    }

    protected <T extends Enum<T>> OTButtonGroup makeOTButtonGroup(FieldID fieldID, T[] TArray, String[] stringArray, int n) {
        OTButtonGroup oTButtonGroup = new OTButtonGroup(TArray, n, stringArray);
        this.initEvents(oTButtonGroup, fieldID);
        return oTButtonGroup;
    }

    protected OTComboBox makeOTComboBox(FieldID fieldID, String[] stringArray, String string) {
        OTComboBox oTComboBox = new OTComboBox(stringArray);
        this.initEvents(oTComboBox, fieldID);
        oTComboBox.setToolTipText(string);
        return oTComboBox;
    }

    protected OTFileArea makeOTFileArea(FieldID fieldID, String string, int n, int n2) {
        OTFileArea oTFileArea = new OTFileArea();
        oTFileArea.setPreferredSize(n, n2);
        this.initEvents(oTFileArea, fieldID);
        oTFileArea.setToolTipText(string);
        return oTFileArea;
    }

    protected OTTextArea makeOTTextArea(FieldID fieldID, String string, int n, int n2, boolean bl) {
        OTTextArea oTTextArea = new OTTextArea(bl, string);
        oTTextArea.setPreferredSize(n, n2);
        this.initEvents(oTTextArea, fieldID);
        oTTextArea.setToolTipText(string);
        return oTTextArea;
    }

    protected SkyCoordsEditor makeSkyCoordsEditor(SkyCoordsModel skyCoordsModel, String string) {
        SkyCoordsEditor skyCoordsEditor = new SkyCoordsEditor(skyCoordsModel);
        this.registerSubView(skyCoordsEditor);
        skyCoordsEditor.setToolTipText(string);
        return skyCoordsEditor;
    }

    protected ValueUnitPairEditor makeSmallAngleEditor(AbstractValueUnitPairModel abstractValueUnitPairModel, String string) {
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(abstractValueUnitPairModel, Angle.units_mas_sec);
        this.registerSubView(valueUnitPairEditor);
        valueUnitPairEditor.setToolTipText(string);
        return valueUnitPairEditor;
    }

    protected JTabbedPane makeTabbedPane(FieldID fieldID, String string) {
        OTTabbedPane oTTabbedPane = new OTTabbedPane();
        oTTabbedPane.setTabPlacement(3);
        oTTabbedPane.setToolTipText(string);
        this.initEvents(oTTabbedPane, fieldID);
        return oTTabbedPane;
    }

    protected Table makeTable(FieldID fieldID, String string, boolean bl, String[] stringArray) {
        DefaultTableModel defaultTableModel = new DefaultTableModel(stringArray, 0);
        Table table = new Table(defaultTableModel);
        table.setEditable(bl);
        this.initEvents(table, fieldID);
        table.setToolTipText(string);
        return table;
    }

    protected JTextArea makeTextArea(FieldID fieldID, String string) {
        OTJTextArea oTJTextArea = new OTJTextArea();
        oTJTextArea.setLineWrap(true);
        this.initEvents(oTJTextArea, fieldID);
        oTJTextArea.setToolTipText(string);
        return oTJTextArea;
    }

    protected OTTextField makeTextField(FieldID fieldID, int n, boolean bl, String string) {
        OTTextField oTTextField = new OTTextField();
        this.initEvents(oTTextField, fieldID);
        oTTextField.setColumns(n);
        oTTextField.setEditable(bl);
        oTTextField.setFocusable(bl);
        oTTextField.setToolTipText(string);
        return oTTextField;
    }

    protected OTTextField makeTextField(FieldID fieldID, int n, boolean bl, boolean bl2, String string) {
        OTTextField oTTextField = new OTTextField();
        this.initEvents(oTTextField, fieldID);
        oTTextField.setColumns(n);
        oTTextField.setEditable(bl);
        oTTextField.setFocusable(bl2);
        oTTextField.setToolTipText(string);
        return oTTextField;
    }

    protected ValueUnitPairEditor makeValueUnitPairEditor(AbstractValueUnitPairModel abstractValueUnitPairModel, String string) {
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(abstractValueUnitPairModel);
        this.registerSubView(valueUnitPairEditor);
        valueUnitPairEditor.setToolTipText(string);
        return valueUnitPairEditor;
    }

    protected ValueUnitPairEditor makeValueUnitPairEditor(AbstractValueUnitPairModel abstractValueUnitPairModel, String[] stringArray, String string) {
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(abstractValueUnitPairModel, stringArray);
        this.registerSubView(valueUnitPairEditor);
        valueUnitPairEditor.setToolTipText(string);
        return valueUnitPairEditor;
    }

    protected ValueUnitPairEditor makeValueUnitPairEditor(AbstractValueUnitPairModel abstractValueUnitPairModel, UnitMap unitMap, String string) {
        Object[] objectArray = unitMap.getUnitsSorted();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < unitMap.size(); ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(abstractValueUnitPairModel, stringArray);
        this.registerSubView(valueUnitPairEditor);
        valueUnitPairEditor.setToolTipText(string);
        return valueUnitPairEditor;
    }

    protected VelocityEditor makeVelocityEditor(VelocityModel velocityModel, String string) {
        VelocityEditor velocityEditor = new VelocityEditor(velocityModel);
        this.registerSubView(velocityEditor);
        VelocityVerifier velocityVerifier = new VelocityVerifier(velocityEditor, -1.7976931348623157E308, Double.MAX_VALUE);
        this.setVerifier(velocityEditor.getInput(), FOCUSLOST_VERIFIER, velocityVerifier);
        velocityEditor.setToolTipText(string);
        return velocityEditor;
    }
}

