/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.CalibrationSetupParametersT;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.data.CalibrationSetupParametersData;
import alma.obsprep.bo.obsproject.data.ScienceGoalData;
import java.util.stream.Stream;
import lombok.NonNull;

public class CalibrationSetupParameters
extends CalibrationSetupParametersData {
    public static final String DEFAULT_SELECTION = SELECTION_SYSTEM;

    public CalibrationSetupParameters(CalibrationSetupParametersT calibrationSetupParametersT) {
        super(calibrationSetupParametersT);
    }

    protected void initAsNew() {
        this.setSelection(DEFAULT_SELECTION);
        this.setPositionalAccuracy(POSITIONALACCURACY_STANDARD);
        this.setForcedDGCStrategy(FORCEDDGCSTRATEGY_NONE);
    }

    public boolean hasCalibration(String string) {
        for (CalibrationTargetParameters targetWithIntent : this.getCalibrationTargetParameters()) {
            if (!targetWithIntent.getIntendedUse().equals(string)) continue;
            return true;
        }
        for (TargetWithIntent targetWithIntent : this.getQuerySource()) {
            if (!targetWithIntent.getIntendedUse().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSystemDefinedCalibration() {
        return SELECTION_SYSTEM.equals(this.getSelection());
    }

    public boolean isAmplitudeSpecificSystemDefinedCalibration() {
        return SELECTION_SYSTEMALTERNATE.equals(this.getSelection());
    }

    public boolean isUserDefinedCalibration() {
        return SELECTION_USER.equals(this.getSelection());
    }

    public boolean isEnhancedAstrometry() {
        return POSITIONALACCURACY_ENHANCED.equals(this.getPositionalAccuracy());
    }

    public boolean isStandardAstrometry() {
        return POSITIONALACCURACY_STANDARD.equals(this.getPositionalAccuracy());
    }

    public static void setAttributesForHistoricalProjects(@NonNull ObsProject obsProject) throws UnknownEntityException {
        if (obsProject == null) {
            throw new NullPointerException("lastObsProjectLoaded is marked non-null but is null");
        }
        Stream.of(obsProject.getObsProposal().getAbstractScienceGoalScienceGoal()).map(ScienceGoalData::getCalibrationSetupParameters).forEach(CalibrationSetupParameters::setCalibrationSetupParameterDefaults);
        Stream.of(obsProject.getObsProgram().getAbstractScienceGoalScienceGoal()).map(ScienceGoalData::getCalibrationSetupParameters).forEach(CalibrationSetupParameters::setCalibrationSetupParameterDefaults);
    }

    private static void setCalibrationSetupParameterDefaults(@NonNull CalibrationSetupParameters calibrationSetupParameters) {
        if (calibrationSetupParameters == null) {
            throw new NullPointerException("csp is marked non-null but is null");
        }
        if (calibrationSetupParameters.getPositionalAccuracy() == null) {
            calibrationSetupParameters.setPositionalAccuracy(POSITIONALACCURACY_STANDARD);
        }
        if (calibrationSetupParameters.getForcedDGCStrategy() == null) {
            calibrationSetupParameters.setForcedDGCStrategy(FORCEDDGCSTRATEGY_NONE);
        }
    }

    public boolean isForcedDGC() {
        String string = this.getForcedDGCStrategy();
        return FORCEDDGCSTRATEGY_BWSW.equals(string) || FORCEDDGCSTRATEGY_B2B.equals(string) || FORCEDDGCSTRATEGY_BWSWB2B.equals(string);
    }

    public boolean isForcedDGCBWSW() {
        String string = this.getForcedDGCStrategy();
        return FORCEDDGCSTRATEGY_BWSW.equals(string) || FORCEDDGCSTRATEGY_BWSWB2B.equals(string);
    }

    public boolean isForcedB2BDGC() {
        String string = this.getForcedDGCStrategy();
        return FORCEDDGCSTRATEGY_B2B.equals(string) || FORCEDDGCSTRATEGY_BWSWB2B.equals(string);
    }
}

