/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.flatfile;

import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.SimpleMeasurement;
import alma.common.sourcecatalog.flatfile.MeasurementFilter;
import alma.common.sourcecatalog.utilities.Convert;
import alma.common.sourcecatalog.utilities.InvalidCoordException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CatalogImporter {
    private static final String OVRO_CALTABLE = "alma/common/sourcecatalog/flatfile/ovroCalibratorTable.dat";
    private static final String SMA_CALTABLE = "alma/common/sourcecatalog/flatfile/smaCalibratorTable.dat";
    private static final Logger logger = Logger.getLogger(CatalogImporter.class.getName());
    private static volatile CatalogImporter instance;
    String tableFileName = "alma/common/sourcecatalog/flatfile/smaCalibratorTable.dat";
    private final Collection<Measurement> measurements = new ArrayList<Measurement>();
    public static final double FREQGHZ_7MM = 42.827494;
    public static final double FREQGHZ_3MM = 99.930819;
    public static final double FREQGHZ_1MM = 299.792458;
    public static final String UNKNOWN = "unknown";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CatalogImporter getInstance() throws IOException {
        if (instance != null) return instance;
        Class<CatalogImporter> clazz = CatalogImporter.class;
        synchronized (CatalogImporter.class) {
            if (instance != null) return instance;
            instance = new CatalogImporter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Collection<Measurement> getCalibratorList() {
        return Collections.unmodifiableCollection(this.measurements);
    }

    private CatalogImporter() throws IOException {
        try {
            this.readCalTable();
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, "", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Catalogue unavailable", e);
        }
    }

    private void readCalTable() throws NumberFormatException, IOException, FileNotFoundException {
        if (this.tableFileName.equals(OVRO_CALTABLE)) {
            this.readOvroCalTable();
        } else if (this.tableFileName.equals(SMA_CALTABLE)) {
            this.readSmaCalTable();
        } else {
            throw new FileNotFoundException("Unknown calibrator table " + this.tableFileName + " requested");
        }
    }

    private void readSmaCalTable() throws IOException {
        logger.log(Level.INFO, "CalibratorTable.readSmaCalTable");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(SMA_CALTABLE);
        if (is == null) {
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String target = in.readLine();
        target = in.readLine();
        target = in.readLine();
        this.measurements.clear();
        double ra = 0.0;
        double dec = 0.0;
        double frequency = 0.0;
        double flux = 0.0;
        Date date = null;
        int sourceId = 0;
        double tolerance = 2.7777777777777776E-7;
        while ((target = in.readLine()) != null) {
            Measurement m;
            String[] tokens = target.split(",");
            ArrayList<String> names = new ArrayList<String>();
            if (tokens[0].trim().equals("--")) {
                names.add("J" + tokens[1].trim());
            } else {
                names.add("J" + tokens[1].trim());
                names.add(tokens[0].trim());
            }
            ra = 0.0;
            try {
                ra = Convert.HHMMSSToDeg(tokens[2].trim());
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Error reading calibrator from file - discarding.", e);
                continue;
            }
            catch (InvalidCoordException e) {
                logger.log(Level.WARNING, "Error reading calibrator from file - discarding.", e);
                continue;
            }
            dec = 0.0;
            try {
                dec = Convert.DDMMSSToDeg(tokens[3].trim());
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Error reading calibrator from file - discarding.", e);
                continue;
            }
            catch (InvalidCoordException e) {
                logger.log(Level.WARNING, "Error reading calibrator from file - discarding.", e);
                continue;
            }
            frequency = 0.0;
            try {
                frequency = this.wavelengthMToFrequencyHz(Double.parseDouble(tokens[4].trim()));
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Error reading calibrator from file - discarding.", e);
                continue;
            }
            flux = 0.0;
            try {
                flux = Double.parseDouble(tokens[7].trim());
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Error reading calibrator from file - discarding.", e);
                continue;
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy", Locale.ROOT);
                date = df.parse(tokens[5].trim());
            }
            catch (ParseException e) {
                logger.log(Level.WARNING, "Error reading calibrator from file - discarding.", e);
                continue;
            }
            String obs = tokens[6].trim();
            if (obs.length() == 0) {
                obs = UNKNOWN;
            }
            CatalogQueryParameters query = new CatalogQueryParameters();
            query.setRightAscension(ra);
            query.setDeclination(dec);
            query.setRadius(tolerance);
            List<Measurement> l = MeasurementFilter.filterMeasurements(this.measurements, query);
            if (l.size() > 0) {
                m = l.get(0);
                sourceId = m.getSourceId();
            } else {
                ++sourceId;
            }
            m = new SimpleMeasurement().sourceId(sourceId).names(names).ra(ra).dec(dec).frequency(frequency).flux(flux).date(date);
            this.measurements.add(m);
        }
        in.close();
    }

    private double wavelengthMToFrequencyHz(double wavelength) {
        double C = 2.99792458E8;
        return 2.99792458E8 / wavelength;
    }

    private void readOvroCalTable() throws NumberFormatException, IOException, FileNotFoundException {
        logger.info("CalibratorTable.readOvroCalTable");
        InputStream is = this.getClass().getResourceAsStream(OVRO_CALTABLE);
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String target = in.readLine();
        target = in.readLine();
        this.measurements.clear();
        int i = 0;
        while ((target = in.readLine()) != null) {
            String[] tokens = target.split("\\t");
            String name = tokens[0].trim();
            String s = tokens[1];
            double ra = 0.0;
            try {
                ra = Convert.HHMMSSToDeg(s);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "", e);
            }
            catch (InvalidCoordException e) {
                logger.log(Level.WARNING, "", e);
            }
            s = tokens[2];
            double dec = 0.0;
            try {
                dec = Convert.DDMMSSToDeg(s);
            }
            catch (NumberFormatException e1) {
                logger.log(Level.WARNING, "", e1);
            }
            catch (InvalidCoordException e1) {
                logger.log(Level.WARNING, "", e1);
            }
            float flux7 = 0.0f;
            try {
                flux7 = Float.parseFloat(tokens[3]);
            }
            catch (NumberFormatException e2) {
                logger.log(Level.FINE, "", e2);
            }
            catch (RuntimeException e6) {
                logger.log(Level.FINE, "", e6);
            }
            float flux3 = 0.0f;
            try {
                flux3 = Float.parseFloat(tokens[4]);
            }
            catch (NumberFormatException e3) {
                logger.log(Level.FINE, "", e3);
            }
            catch (RuntimeException e6) {
                logger.log(Level.FINE, "", e6);
            }
            float flux1 = 0.0f;
            try {
                flux1 = Float.parseFloat(tokens[5]);
            }
            catch (NumberFormatException e4) {
                logger.log(Level.FINE, "", e4);
            }
            catch (RuntimeException e6) {
                logger.log(Level.FINE, "", e6);
            }
            String date3 = UNKNOWN;
            try {
                date3 = tokens[6].trim();
            }
            catch (RuntimeException e5) {
                logger.log(Level.FINE, "", e5);
            }
            String date1 = UNKNOWN;
            try {
                date1 = tokens[7].trim();
            }
            catch (RuntimeException e6) {
                logger.log(Level.FINE, "", e6);
            }
            String date7 = UNKNOWN;
            Date d1 = this.parseDate(date1).getTime();
            Date d3 = this.parseDate(date3).getTime();
            Date d7 = this.parseDate(date7).getTime();
            this.measurements.add(new SimpleMeasurement().name(name).ra(ra).dec(dec).frequency(42.827494).flux(new Double(flux7)).date(d7));
            this.measurements.add(new SimpleMeasurement().name(name).ra(ra).dec(dec).frequency(99.930819).flux(new Double(flux3)).date(d3));
            this.measurements.add(new SimpleMeasurement().name(name).ra(ra).dec(dec).frequency(299.792458).flux(new Double(flux1)).date(d1));
            ++i;
        }
        in.close();
    }

    private Calendar parseDate(String date) {
        int month;
        if (date.equals(UNKNOWN) || date.isEmpty()) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            return cal;
        }
        String monthStr = date.substring(0, 3).toLowerCase();
        if (monthStr.equals("jan")) {
            month = 0;
        } else if (monthStr.equals("feb")) {
            month = 1;
        } else if (monthStr.equals("mar")) {
            month = 2;
        } else if (monthStr.equals("apr")) {
            month = 3;
        } else if (monthStr.equals("may")) {
            month = 4;
        } else if (monthStr.equals("jun")) {
            month = 5;
        } else if (monthStr.equals("jul")) {
            month = 6;
        } else if (monthStr.equals("aug")) {
            month = 7;
        } else if (monthStr.equals("sep")) {
            month = 8;
        } else if (monthStr.equals("oct")) {
            month = 9;
        } else if (monthStr.equals("nov")) {
            month = 10;
        } else if (monthStr.equals("dec")) {
            month = 11;
        } else {
            return null;
        }
        int year = Integer.parseInt(date.substring(3));
        year = year >= 70 ? (year += 1900) : (year += 2000);
        Calendar cal = Calendar.getInstance();
        cal.set(2, month);
        cal.set(1, year);
        return cal;
    }
}

