/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.dynwrapper;

import alma.acs.component.dynwrapper.ComponentInvocationHandler;
import alma.acs.component.dynwrapper.DynWrapperException;
import alma.acs.container.ComponentHelper;
import alma.acs.util.StopWatch;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicProxyFactory {
    private static DynamicProxyFactory s_instance;
    private Logger m_logger = null;

    public static DynamicProxyFactory getDynamicProxyFactory(Logger logger) {
        if (s_instance == null) {
            s_instance = new DynamicProxyFactory(logger);
        }
        return s_instance;
    }

    private DynamicProxyFactory(Logger logger) {
        this.m_logger = logger;
    }

    public <T, F> T createClientProxy(Class<T> componentInterface, F corbaStub, Class<F> corbaOperationsIF) throws DynWrapperException {
        T proxy = null;
        try {
            ComponentInvocationHandler handler = new ComponentInvocationHandler(corbaStub, corbaOperationsIF, this.m_logger);
            this.checkMethodMatching(componentInterface, handler);
            proxy = componentInterface.cast(Proxy.newProxyInstance(componentInterface.getClassLoader(), new Class[]{componentInterface}, (InvocationHandler)handler));
        }
        catch (DynWrapperException e) {
            throw e;
        }
        catch (RuntimeException e2) {
            String msg = "failed to create a binding-class aware client proxy implementing " + componentInterface.getName();
            this.m_logger.log(Level.SEVERE, msg, e2);
            throw new DynWrapperException(msg, e2);
        }
        return proxy;
    }

    public Object createServerProxy(Class<?> corbaIF, Object componentImpl, Class<?> componentIF) throws DynWrapperException {
        ComponentInvocationHandler handler = new ComponentInvocationHandler(componentImpl, componentIF, this.m_logger);
        this.checkMethodMatching(corbaIF, handler);
        Object proxy = Proxy.newProxyInstance(corbaIF.getClassLoader(), new Class[]{corbaIF}, (InvocationHandler)handler);
        return proxy;
    }

    private boolean checkMethodMatching(Class facade, ComponentInvocationHandler invHandler) throws DynWrapperException {
        StopWatch methodMatchCheckTimer = new StopWatch(this.m_logger);
        boolean autonomousMapping = true;
        Method[] facadeMethods = facade.getMethods();
        for (int i = 0; i < facadeMethods.length; ++i) {
            Class<?> facadeRet;
            Class<?>[] delegParams;
            Method delegateMethod = invHandler.findDelegateMethod(facadeMethods[i]);
            Class<?>[] facadeParams = facadeMethods[i].getParameterTypes();
            if (facadeParams.length != (delegParams = delegateMethod.getParameterTypes()).length) {
                String msg = "unmatching numbers of parameters in method " + delegateMethod.getName();
                throw new DynWrapperException(msg);
            }
            for (int pIndex = 0; pIndex < facadeParams.length; ++pIndex) {
                if (invHandler.canTranslate(facadeParams[pIndex], delegParams[pIndex]) && invHandler.canTranslate(delegParams[pIndex], facadeParams[pIndex])) continue;
                String msg = "unable to map automatically between parameter type '" + facadeParams[pIndex].getName() + "' and '" + delegParams[pIndex].getName() + "' in method '" + facadeMethods[i].getName() + "'. This functionality must therefore be provided  by the component's associated " + ComponentHelper.class.getName() + " class.";
                this.m_logger.info(msg);
                autonomousMapping = false;
            }
            Class<?> delegateRet = delegateMethod.getReturnType();
            if (invHandler.canTranslate(delegateRet, facadeRet = facadeMethods[i].getReturnType())) continue;
            String msg = "unable to map automatically from return type '" + delegateRet.getName() + "' to type '" + facadeRet.getName() + "' in method '" + facadeMethods[i].getName() + "'.";
            this.m_logger.info(msg);
            autonomousMapping = false;
        }
        methodMatchCheckTimer.logLapTime("verify automatic translation for methods in " + facade.getName());
        return autonomousMapping;
    }
}

