/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.client;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.component.client.ComponentClient;
import alma.acs.component.client.ManagerClient;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.CleaningDaemonThreadFactory;
import alma.acs.container.ContainerServices;
import alma.acs.container.ContainerServicesImpl;
import alma.acs.container.corba.AcsCorba;
import alma.acs.logging.AcsLogger;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DALHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import si.ijs.maci.Client;

public class AdvancedComponentClient
extends ComponentClient {
    private Map<ContainerServicesImpl, AcsManagerProxy> additionalContainerServices = new HashMap<ContainerServicesImpl, AcsManagerProxy>();

    public AdvancedComponentClient(Logger logger, String managerLoc, String clientName) throws Exception {
        super(logger, managerLoc, clientName);
    }

    public AdvancedComponentClient(Logger logger, String managerLoc, String clientName, AcsCorba externalAcsCorba) throws Exception {
        super(logger, managerLoc, clientName, externalAcsCorba);
    }

    public ContainerServices createContainerServices(String clientName, Logger csLogger) throws AcsJContainerServicesEx {
        if (clientName == null) {
            throw new IllegalArgumentException("clientName must not be null");
        }
        if (csLogger == null) {
            throw new IllegalArgumentException("csLogger must not be null");
        }
        try {
            AcsLogger acsLogger = AcsLogger.fromJdkLogger((Logger)csLogger, null);
            CleaningDaemonThreadFactory threadFactory = new CleaningDaemonThreadFactory(clientName, csLogger);
            AcsManagerProxy acsManagerProxy = this.m_acsManagerProxy.createInstance();
            ManagerClient clImpl = new ManagerClient(clientName, (Logger)acsLogger);
            Client managerClient = clImpl._this(this.acsCorba.getORB());
            acsManagerProxy.loginToManager(managerClient, 0);
            int clientHandle = acsManagerProxy.getManagerHandle();
            DAL cdb = DALHelper.narrow((Object)this.m_acsManagerProxy.get_service("CDB", false));
            ContainerServicesImpl cs = new ContainerServicesImpl(acsManagerProxy, cdb, this.acsCorba.getRootPOA(), this.acsCorba, acsLogger, clientHandle, clientName, null, threadFactory);
            this.additionalContainerServices.put(cs, acsManagerProxy);
            return cs;
        }
        catch (Throwable thr) {
            throw new AcsJContainerServicesEx(thr);
        }
    }

    public void destroyContainerServices(ContainerServices cs) throws AcsJContainerServicesEx {
        if (!this.additionalContainerServices.containsKey(cs)) {
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx();
            ex.setContextInfo("The given ContainerServices object was not created by this AdvancedComponentClient!");
            throw ex;
        }
        try {
            ContainerServicesImpl csImpl = (ContainerServicesImpl)cs;
            AcsManagerProxy acsManagerProxy = this.additionalContainerServices.get(cs);
            acsManagerProxy.shutdownNotify();
            csImpl.releaseAllComponents();
            ((CleaningDaemonThreadFactory)csImpl.getThreadFactory()).cleanUp();
            acsManagerProxy.logoutFromManager();
            this.additionalContainerServices.remove(cs);
            csImpl.cleanUp();
        }
        catch (Throwable thr) {
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx();
            ex.setContextInfo("Failed to destroy additional container services instance");
            throw ex;
        }
    }

    public AcsCorba getAcsCorba() {
        return this.acsCorba;
    }

    public AcsManagerProxy getAcsManagerProxy() {
        return this.m_acsManagerProxy;
    }
}

