/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.Stack;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.NamespacesStack;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAX2ANY
implements ContentHandler,
DocumentHandler,
ErrorHandler {
    private static final String XMLNS_PREFIX = "xmlns";
    private static final int XMLNS_PREFIX_LENGTH = "xmlns".length() + 1;
    private AnyNode _startingNode;
    private AnyNode _node;
    private Stack<AnyNode> _nodeStack = new Stack();
    private Stack<AnyNode> _namespaces = new Stack();
    private boolean _processNamespace = true;
    private boolean _character = false;
    private NamespacesStack namespacesStack;
    private boolean _wsPreserve = false;

    public SAX2ANY() {
        this.init();
    }

    public SAX2ANY(NamespacesStack namespacesStack, boolean wsPreserve) {
        this.namespacesStack = namespacesStack;
        this._wsPreserve = wsPreserve;
        this.init();
    }

    private void init() {
        if (this.namespacesStack == null) {
            this.namespacesStack = new NamespacesStack();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        AnyNode temp = new AnyNode(3, null, prefix, uri, null);
        this._namespaces.push(temp);
        if (this._processNamespace) {
            this.namespacesStack.addNewNamespaceScope();
            this._processNamespace = true;
        }
        this.namespacesStack.addNamespace(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespacesStack.removeNamespace(prefix);
    }

    @Override
    public void startElement(String name, AttributeList atts) throws SAXException {
        String value;
        String qName;
        int i;
        this._character = false;
        AnyNode tempNode = null;
        this.namespacesStack.addNewNamespaceScope();
        String prefix = "";
        String namespaceURI = null;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            prefix = name.substring(0, idx);
        }
        namespaceURI = this.namespacesStack.getNamespaceURI(prefix);
        for (i = 0; i < atts.getLength(); ++i) {
            qName = atts.getName(i);
            value = atts.getValue(i);
            String nsPrefix = null;
            if (!qName.startsWith(XMLNS_PREFIX)) continue;
            nsPrefix = qName.equals(XMLNS_PREFIX) ? null : qName.substring(XMLNS_PREFIX_LENGTH);
            tempNode = new AnyNode(3, this.getLocalPart(qName), nsPrefix, value, null);
            this.namespacesStack.addNamespace(nsPrefix, value);
            this._namespaces.push(tempNode);
            if (!prefix.equals(nsPrefix)) continue;
            namespaceURI = value;
        }
        this.createNodeElement(namespaceURI, this.getLocalPart(name), name);
        while (!this._namespaces.empty()) {
            tempNode = this._namespaces.pop();
            this._node.addNamespace(tempNode);
        }
        for (i = 0; i < atts.getLength(); ++i) {
            qName = atts.getName(i);
            value = atts.getValue(i);
            if (qName.startsWith(XMLNS_PREFIX)) continue;
            tempNode = new AnyNode(2, this.getLocalPart(qName), null, null, value);
            this._node.addAttribute(tempNode);
        }
        tempNode = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        AnyNode tempNode;
        if (this._processNamespace) {
            this.namespacesStack.addNewNamespaceScope();
            String prefix = "";
            int idx = qName.indexOf(58);
            if (idx >= 0) {
                prefix = qName.substring(0, idx);
            }
            namespaceURI = this.namespacesStack.getNamespaceURI(prefix);
            for (int i = 0; i < atts.getLength(); ++i) {
                String attrqName = atts.getQName(i);
                String value = atts.getValue(i);
                String nsPrefix = null;
                if (!attrqName.startsWith(XMLNS_PREFIX)) continue;
                nsPrefix = attrqName.equals(XMLNS_PREFIX) ? null : attrqName.substring(XMLNS_PREFIX_LENGTH);
                tempNode = new AnyNode(3, this.getLocalPart(attrqName), nsPrefix, value, null);
                this.namespacesStack.addNamespace(nsPrefix, value);
                this._namespaces.push(tempNode);
                if (!prefix.equals(nsPrefix)) continue;
                namespaceURI = value;
            }
        }
        this.createNodeElement(namespaceURI, localName, qName);
        for (int i = 0; i < atts.getLength(); ++i) {
            String uri = atts.getURI(i);
            String attqName = atts.getQName(i);
            String value = atts.getValue(i);
            String prefix = null;
            if (this._processNamespace && attqName.startsWith(XMLNS_PREFIX)) continue;
            if (attqName.length() != 0 && attqName.indexOf(58) != -1) {
                prefix = attqName.substring(0, attqName.indexOf(58));
            }
            if (this._processNamespace && prefix != null) {
                uri = this.namespacesStack.getNamespaceURI(prefix);
            }
            tempNode = new AnyNode(2, this.getLocalPart(attqName), prefix, uri, value);
            this._node.addAttribute(tempNode);
        }
        while (!this._namespaces.empty()) {
            tempNode = this._namespaces.pop();
            this._node.addNamespace(tempNode);
        }
        tempNode = null;
    }

    @Override
    public void endElement(String name) throws SAXException {
        int idx = name.indexOf(58);
        String prefix = idx >= 0 ? name.substring(0, idx) : "";
        String namespaceURI = this.namespacesStack.getNamespaceURI(prefix);
        this.endElement(namespaceURI, this.getLocalPart(name), name);
        this.namespacesStack.removeNamespaceScope();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this._character = false;
        String name = null;
        name = localName != null && localName.length() > 0 ? localName : this.getLocalPart(qName);
        if (this._startingNode.getLocalName().equals(name) && this._nodeStack.empty()) {
            return;
        }
        this._node = this._nodeStack.pop();
        if (this._nodeStack.empty()) {
            this._startingNode.addChild(this._node);
            this._node = this._startingNode;
        } else {
            AnyNode previousNode = this._nodeStack.peek();
            previousNode.addChild(this._node);
            this._node = previousNode;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String temp = new String(ch, start, length);
        if (this.isWhitespace(temp) && !this._wsPreserve && !this._character) {
            return;
        }
        AnyNode tempNode = new AnyNode(6, null, null, null, temp);
        this._node.addChild(tempNode);
        this._character = true;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        String err = "SAX2ANY warning\nLine : " + e.getLineNumber() + "\nURI : " + e.getSystemId() + "\n" + e.getMessage();
        throw new SAXException(err, e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        String err = "SAX2ANY Error \nLine : " + e.getLineNumber() + "\nURI : " + e.getSystemId() + "\n" + e.getMessage();
        throw new SAXException(err, e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        String err = "SAX2ANY Fatal Error \nLine : " + e.getLineNumber() + "\nURI : " + e.getSystemId() + "\n" + e.getMessage();
        throw new SAXException(err, e);
    }

    public AnyNode getStartingNode() {
        return this._startingNode;
    }

    private boolean isWhitespace(String string) {
        block3: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private String getLocalPart(String ncName) {
        int idx = ncName.indexOf(58);
        if (idx >= 0) {
            return ncName.substring(idx + 1);
        }
        return ncName;
    }

    private void createNodeElement(String namespaceURI, String localName, String qName) {
        String prefix = null;
        if (namespaceURI != null) {
            prefix = this.namespacesStack.getNamespacePrefix(namespaceURI);
        } else if (qName != null && qName.length() != 0 && qName.indexOf(58) != -1) {
            prefix = qName.substring(0, qName.indexOf(58));
        }
        String name = null;
        name = localName != null && localName.length() > 0 ? localName : this.getLocalPart(qName);
        if (this._nodeStack.empty() && this._startingNode == null) {
            this._node = this._startingNode = new AnyNode(1, name, prefix, namespaceURI, null);
        } else {
            this._node = new AnyNode(1, name, prefix, namespaceURI, null);
            this._nodeStack.push(this._node);
        }
    }
}

